/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.markers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnit;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnitManager;
import org.eclipse.ajdt.core.javaelements.AspectElement;
import org.eclipse.ajdt.internal.ui.markers.CustomMarkerImageProvider;
import org.eclipse.ajdt.internal.ui.markers.MarkerUpdating;
import org.eclipse.ajdt.internal.ui.preferences.AspectJPreferences;
import org.eclipse.ajdt.internal.ui.resources.AspectJImages;
import org.eclipse.ajdt.internal.ui.text.UIMessages;
import org.eclipse.ajdt.internal.utils.AJDTUtils;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class AJMarkersDialog
extends Dialog {
    private static final String SAMPLE = "SAMPLE";
    private static final String DEFAULT_MARKERS;
    public static final String NO_MARKERS;
    private Table table;
    private boolean pageChanged = false;
    private IProject project;
    private Map tableItemsToAspects = new HashMap();
    private List aspectNames = new ArrayList();
    private Image[] images16x16;
    private List imagesToDispose;
    private Image defaultImage = AspectJImages.instance().getRegistry().get(AspectJImages.ADVICE.getImageDescriptor());
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    static {
        Factory factory = new Factory("AJMarkersDialog.java", Class.forName("org.eclipse.ajdt.internal.ui.markers.AJMarkersDialog"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.markers.AJMarkersDialog-org.eclipse.core.runtime.CoreException-<missing>-"), 158);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-createDialogArea-org.eclipse.ajdt.internal.ui.markers.AJMarkersDialog-org.eclipse.swt.widgets.Composite:-parent:--org.eclipse.swt.widgets.Control-"), 107);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.markers.AJMarkersDialog-org.eclipse.jdt.core.JavaModelException-<missing>-"), 212);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-getAspectImage-org.eclipse.ajdt.internal.ui.markers.AJMarkersDialog-org.eclipse.jdt.core.IType:-type:--org.eclipse.swt.graphics.Image-"), 208);
        DEFAULT_MARKERS = UIMessages.AJMarkersPropertyPage_default;
        NO_MARKERS = UIMessages.AJMarkersPropertyPage_none;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(UIMessages.AJMarkersDialog_configure_title);
    }

    public AJMarkersDialog(Shell parentShell, IProject project) {
        super(parentShell);
        this.images16x16 = new Image[CustomMarkerImageProvider.sampleImageDescriptors.length];
        int i = 0;
        while (i < CustomMarkerImageProvider.sampleImageDescriptors.length) {
            Image image16;
            Image image = AspectJImages.instance().getRegistry().get(CustomMarkerImageProvider.sampleImageDescriptors[i]);
            this.images16x16[i] = image16 = this.create16x16Image(image);
            ++i;
        }
        this.project = project;
    }

    public AJMarkersDialog(IShellProvider parentShell, IProject project) {
        super(parentShell);
        this.project = project;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gd = new GridData(1808);
        gd.heightHint = 400;
        composite.setLayoutData((Object)gd);
        GridLayout gl = new GridLayout(2, false);
        gl.marginHeight = 15;
        gl.marginWidth = 15;
        composite.setLayout((Layout)gl);
        Label label = new Label(composite, 0);
        label.setText(UIMessages.AJMarkersPropertyPage_configure_icons);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        Label spacer = new Label(composite, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        spacer.setLayoutData((Object)gd);
        this.table = new Table(composite, 68356);
        gd = new GridData(1808);
        this.table.setLayoutData((Object)gd);
        TableColumn aspectsColumn = new TableColumn(this.table, 16384);
        TableColumn iconsColumn = new TableColumn(this.table, 16384);
        aspectsColumn.setText(UIMessages.AJMarkersPropertyPage_aspect);
        iconsColumn.setText(UIMessages.AJMarkersPropertyPage_icon_for_markers);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        Composite buttonsComposite = new Composite(composite, 0);
        buttonsComposite.setLayoutData((Object)new GridData(1808));
        buttonsComposite.setLayout((Layout)new GridLayout(1, false));
        final Button editButton = new Button(buttonsComposite, 8);
        editButton.setText(UIMessages.AJMarkersPropertyPage_edit);
        editButton.setEnabled(false);
        editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AJMarkersDialog.this.edit(AJMarkersDialog.this.table);
            }
        });
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                AJMarkersDialog.this.edit(AJMarkersDialog.this.table);
            }

            public void widgetSelected(SelectionEvent e) {
                editButton.setEnabled(true);
            }
        });
        try {
            this.addAspects(this.table);
        }
        catch (CoreException coreException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_0, ajc$tjp_1);
        }
        iconsColumn.pack();
        aspectsColumn.pack();
        aspectsColumn.setWidth(aspectsColumn.getWidth() + 20);
        return composite;
    }

    private void addAspects(Table table) throws CoreException {
        List ajcus = AJCompilationUnitManager.INSTANCE.getAJCompilationUnits(JavaCore.create((IProject)this.project));
        Iterator iter = ajcus.iterator();
        while (iter.hasNext()) {
            AJCompilationUnit unit = (AJCompilationUnit)iter.next();
            IType[] types = unit.getAllTypes();
            int j = 0;
            while (j < types.length) {
                IType type = types[j];
                if (type instanceof AspectElement) {
                    String fullyQualifiedAspectName = AJMarkersDialog.getFullyQualifiedAspectName(type);
                    String aspectName = this.getAspectDisplayName(type);
                    this.aspectNames.add(aspectName);
                    TableItem tableItem = new TableItem(table, 0);
                    this.tableItemsToAspects.put(tableItem, type);
                    tableItem.setText(0, aspectName);
                    tableItem.setImage(this.getAspectImage(type));
                    String savedValue = AspectJPreferences.getSavedIcon(this.project, fullyQualifiedAspectName);
                    if (savedValue == null || savedValue.trim().equals("")) {
                        tableItem.setText(1, DEFAULT_MARKERS);
                        tableItem.setImage(1, this.defaultImage);
                    } else if (savedValue.equals(NO_MARKERS)) {
                        tableItem.setText(1, NO_MARKERS);
                    } else if (savedValue.startsWith(SAMPLE)) {
                        int index = this.getSampleIndex(savedValue);
                        tableItem.setImage(1, this.images16x16[index]);
                        tableItem.setText(1, CustomMarkerImageProvider.sampleImageNames[index]);
                        tableItem.setData((Object)CustomMarkerImageProvider.sampleImageLocations[index]);
                    } else {
                        Image image = this.create16x16Image(CustomMarkerImageProvider.getImage(savedValue));
                        if (image == null) {
                            tableItem.setText(1, DEFAULT_MARKERS);
                            tableItem.setImage(1, this.defaultImage);
                        } else {
                            tableItem.setImage(1, image);
                            tableItem.setText(1, savedValue.substring(savedValue.lastIndexOf(47) + 1));
                            tableItem.setData((Object)savedValue);
                        }
                    }
                }
                ++j;
            }
        }
    }

    private Image getAspectImage(IType type) {
        int flags = 1;
        try {
            flags = type.getFlags();
        }
        catch (JavaModelException javaModelException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, (Object)this, ajc$tjp_2, ajc$tjp_3);
        }
        if (Flags.isPublic((int)flags)) {
            return AspectJImages.instance().getRegistry().get(AspectJImages.ASPECT_PUBLIC.getImageDescriptor());
        }
        if (Flags.isPrivate((int)flags)) {
            return AspectJImages.instance().getRegistry().get(AspectJImages.ASPECT_PRIVATE.getImageDescriptor());
        }
        if (Flags.isProtected((int)flags)) {
            return AspectJImages.instance().getRegistry().get(AspectJImages.ASPECT_PROTECTED.getImageDescriptor());
        }
        return AspectJImages.instance().getRegistry().get(AspectJImages.ASPECT_PACKAGE.getImageDescriptor());
    }

    private String getAspectDisplayName(IType type) {
        char[][] enclosingTypes = AJDTUtils.getEnclosingTypes(type);
        if (type.getPackageFragment().isDefaultPackage()) {
            return String.valueOf(type.getElementName()) + " - " + UIMessages.AJMarkersDialog_defaultPackage;
        }
        String name = type.getPackageFragment().getElementName();
        int i = 0;
        while (i < enclosingTypes.length) {
            name = String.valueOf(name) + ".";
            name = String.valueOf(name) + new String(enclosingTypes[i]);
            ++i;
        }
        return String.valueOf(type.getElementName()) + " - " + name;
    }

    public static String getFullyQualifiedAspectName(IType type) {
        char[][] enclosingTypes = AJDTUtils.getEnclosingTypes(type);
        String name = type.getPackageFragment().getElementName();
        if (name != null && !name.equals("")) {
            name = String.valueOf(name) + ".";
        }
        int i = 0;
        while (i < enclosingTypes.length) {
            name = String.valueOf(name) + new String(enclosingTypes[i]);
            name = String.valueOf(name) + ".";
            ++i;
        }
        name = String.valueOf(name) + type.getElementName();
        return name;
    }

    protected void okPressed() {
        TableItem[] items = this.table.getItems();
        int i = 0;
        while (i < items.length) {
            TableItem item = items[i];
            AspectElement aspectEl = (AspectElement)this.tableItemsToAspects.get(item);
            if (aspectEl != null) {
                String fullyQualifiedName = AJMarkersDialog.getFullyQualifiedAspectName((IType)aspectEl);
                String text = item.getText(1);
                if (text == DEFAULT_MARKERS) {
                    AspectJPreferences.setSavedIcon(this.project, fullyQualifiedName, null);
                } else if (text == NO_MARKERS) {
                    AspectJPreferences.setSavedIcon(this.project, fullyQualifiedName, NO_MARKERS);
                } else {
                    AspectJPreferences.setSavedIcon(this.project, fullyQualifiedName, (String)item.getData());
                }
            }
            ++i;
        }
        if (this.pageChanged) {
            MarkerUpdating.deleteAllMarkers(this.project);
            MarkerUpdating.addNewMarkers(this.project);
        }
        super.okPressed();
        Iterator iter = this.imagesToDispose.iterator();
        while (iter.hasNext()) {
            Image image = (Image)iter.next();
            image.dispose();
        }
        this.images16x16 = null;
        this.imagesToDispose = null;
    }

    protected void cancelPressed() {
        super.cancelPressed();
        Iterator iter = this.imagesToDispose.iterator();
        while (iter.hasNext()) {
            Image image = (Image)iter.next();
            image.dispose();
        }
        this.images16x16 = null;
        this.imagesToDispose = null;
    }

    private void edit(Table table) {
        MarkerSelectionDialog dialog = new MarkerSelectionDialog(this.getShell(), this.project, (String)table.getSelection()[0].getData(), table.getSelection()[0].getText(0), this.aspectNames);
        dialog.create();
        if (dialog.open() == 0) {
            this.pageChanged = true;
            String selection = dialog.getSelection();
            String aspectName = dialog.getAspectName();
            if (!table.getSelection()[0].getText(0).equals(aspectName)) {
                Set items = this.tableItemsToAspects.keySet();
                Iterator iter = items.iterator();
                while (iter.hasNext()) {
                    TableItem item = (TableItem)iter.next();
                    if (!item.getText(0).equals(aspectName)) continue;
                    table.setSelection(item);
                    break;
                }
            }
            if (selection == null) {
                table.getSelection()[0].setText(1, DEFAULT_MARKERS);
                table.getSelection()[0].setImage(1, this.defaultImage);
                table.getSelection()[0].setData(null);
            } else if (selection == NO_MARKERS) {
                table.getSelection()[0].setText(1, NO_MARKERS);
                table.getSelection()[0].setImage(1, null);
                table.getSelection()[0].setData((Object)NO_MARKERS);
            } else if (selection.startsWith(SAMPLE)) {
                int index = this.getSampleIndex(selection);
                table.getSelection()[0].setText(1, CustomMarkerImageProvider.sampleImageNames[index]);
                table.getSelection()[0].setImage(1, this.images16x16[index]);
                table.getSelection()[0].setData((Object)CustomMarkerImageProvider.sampleImageLocations[index]);
            } else {
                table.getSelection()[0].setText(1, selection.substring(selection.lastIndexOf(47) + 1));
                table.getSelection()[0].setImage(1, this.create16x16Image(CustomMarkerImageProvider.getImage(selection)));
                table.getSelection()[0].setData((Object)selection);
            }
            table.layout();
        }
    }

    private int getSampleIndex(String selection) {
        String[] split = selection.split("_");
        int index = Integer.parseInt(split[1]);
        return index;
    }

    private Image create16x16Image(Image orig) {
        Image img = new Image(orig.getDevice(), 16, 16);
        GC gc = new GC((Drawable)img);
        gc.drawImage(orig, 0, 0);
        gc.dispose();
        if (this.imagesToDispose == null) {
            this.imagesToDispose = new ArrayList();
        }
        this.imagesToDispose.add(img);
        return img;
    }

    public class MarkerImageSelectionDialog
    extends Dialog {
        private String selection;
        private String fileName;
        private IProject project;

        protected MarkerImageSelectionDialog(Shell parentShell, IProject project) {
            super(parentShell);
            this.project = project;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getFileLocation() {
            return this.selection;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(UIMessages.AJMarkersPropertyPage_select_icon);
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)new GridData(1808));
            GridLayout gl = new GridLayout(1, false);
            gl.marginHeight = 10;
            gl.marginWidth = 10;
            composite.setLayout((Layout)gl);
            Tree tree = new Tree(composite, 2052);
            GridData gd = new GridData(1808);
            gd.heightHint = 150;
            gd.widthHint = 200;
            tree.setLayoutData((Object)gd);
            this.fillTree(this.project, tree);
            tree.addSelectionListener((SelectionListener)new SelectionAdapter(this, tree){
                final /* synthetic */ MarkerImageSelectionDialog this$1;
                private final /* synthetic */ Tree val$tree;
                {
                    this.this$1 = markerImageSelectionDialog;
                    this.val$tree = tree;
                }

                public void widgetSelected(SelectionEvent e) {
                    MarkerImageSelectionDialog.access$1(this.this$1, MarkerImageSelectionDialog.access$0(this.this$1, this.val$tree.getSelection()[0]));
                    MarkerImageSelectionDialog.access$3(this.this$1, MarkerImageSelectionDialog.access$2(this.this$1, this.val$tree.getSelection()[0]));
                    MarkerImageSelectionDialog.access$4(this.this$1, 0).setEnabled(MarkerImageSelectionDialog.access$5(this.this$1) != null);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    MarkerImageSelectionDialog.access$1(this.this$1, MarkerImageSelectionDialog.access$0(this.this$1, this.val$tree.getSelection()[0]));
                    MarkerImageSelectionDialog.access$3(this.this$1, MarkerImageSelectionDialog.access$2(this.this$1, this.val$tree.getSelection()[0]));
                    MarkerImageSelectionDialog.access$4(this.this$1, 0).setEnabled(MarkerImageSelectionDialog.access$5(this.this$1) != null);
                    if (MarkerImageSelectionDialog.access$5(this.this$1) != null) {
                        MarkerImageSelectionDialog.access$6(this.this$1);
                    }
                }
            });
            return composite;
        }

        private String getNameForItem(TreeItem item) {
            if (item.getData() instanceof IFile) {
                return ((IFile)item.getData()).getName();
            }
            return null;
        }

        private String getSelectionForItem(TreeItem item) {
            if (item.getData() instanceof IFile) {
                return ((IFile)item.getData()).getFullPath().toString();
            }
            return null;
        }

        private void fillTree(IProject project, Tree tree) {
            TreeViewer viewer = new TreeViewer(tree);
            viewer.setContentProvider((IContentProvider)new ITreeContentProvider(this){
                final /* synthetic */ MarkerImageSelectionDialog this$1;
                private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
                private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
                {
                    this.this$1 = markerImageSelectionDialog;
                }

                public Object[] getChildren(Object parentElement) {
                    if (parentElement instanceof IContainer) {
                        try {
                            IResource[] members = ((IContainer)parentElement).members();
                            ArrayList<IResource> children = new ArrayList<IResource>();
                            int i = 0;
                            while (i < members.length) {
                                IResource resource = members[i];
                                if (resource instanceof IContainer || resource.getFileExtension().equals("gif") || resource.getFileExtension().equals("png")) {
                                    children.add(resource);
                                }
                                ++i;
                            }
                            return children.toArray();
                        }
                        catch (CoreException coreException) {
                            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, this, ajc$tjp_0, ajc$tjp_1);
                        }
                    }
                    return new Object[0];
                }

                public Object getParent(Object element) {
                    if (element instanceof IResource) {
                        return ((IResource)element).getParent();
                    }
                    return null;
                }

                public boolean hasChildren(Object element) {
                    return element instanceof IContainer;
                }

                public Object[] getElements(Object inputElement) {
                    if (inputElement instanceof Object[]) {
                        return (Object[])inputElement;
                    }
                    return this.getChildren(inputElement);
                }

                public void dispose() {
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }

                static {
                    Factory factory = new Factory("AJMarkersDialog.java", Class.forName("org.eclipse.ajdt.internal.ui.markers.AJMarkersDialog$5"));
                    ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.markers.AJMarkersDialog$5-org.eclipse.core.runtime.CoreException-<missing>-"), 595);
                    ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getChildren-org.eclipse.ajdt.internal.ui.markers.AJMarkersDialog$5-java.lang.Object:-parentElement:--[Ljava.lang.Object;-"), 583);
                }
            });
            viewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
            viewer.setInput((Object)new Object[]{project});
        }

        protected String getSelection() {
            return this.selection;
        }

        static /* synthetic */ String access$0(MarkerImageSelectionDialog markerImageSelectionDialog, TreeItem treeItem) {
            return markerImageSelectionDialog.getSelectionForItem(treeItem);
        }

        static /* synthetic */ void access$1(MarkerImageSelectionDialog markerImageSelectionDialog, String string) {
            markerImageSelectionDialog.selection = string;
        }

        static /* synthetic */ String access$2(MarkerImageSelectionDialog markerImageSelectionDialog, TreeItem treeItem) {
            return markerImageSelectionDialog.getNameForItem(treeItem);
        }

        static /* synthetic */ void access$3(MarkerImageSelectionDialog markerImageSelectionDialog, String string) {
            markerImageSelectionDialog.fileName = string;
        }

        static /* synthetic */ Button access$4(MarkerImageSelectionDialog markerImageSelectionDialog, int n) {
            return markerImageSelectionDialog.getButton(n);
        }

        static /* synthetic */ String access$5(MarkerImageSelectionDialog markerImageSelectionDialog) {
            return markerImageSelectionDialog.selection;
        }

        static /* synthetic */ void access$6(MarkerImageSelectionDialog markerImageSelectionDialog) {
            markerImageSelectionDialog.okPressed();
        }
    }

    public class MarkerSelectionDialog
    extends Dialog {
        private String selection;
        private String aspectName;
        private IProject project;
        private List aspects;

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(UIMessages.AJMarkersPropertyPage_select_icon);
        }

        protected MarkerSelectionDialog(Shell shell, IProject project, String selection, String aspectName, List aspects) {
            super(shell);
            this.project = project;
            this.selection = selection;
            this.aspectName = aspectName;
            this.aspects = aspects;
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)new GridData(1808));
            GridLayout gl = new GridLayout(3, false);
            gl.marginHeight = 10;
            gl.marginWidth = 10;
            composite.setLayout((Layout)gl);
            Label label = new Label(composite, 0);
            label.setText(UIMessages.AJMarkersPropertyPage_select_an_icon);
            GridData gd = new GridData(1808);
            gd.horizontalSpan = 3;
            label.setLayoutData((Object)gd);
            Label aspectLabel = new Label(composite, 0);
            aspectLabel.setText(UIMessages.AJMarkersDialog_aspect);
            Combo aspectCombo = new Combo(composite, 2056);
            Iterator iter = this.aspects.iterator();
            while (iter.hasNext()) {
                String aspectNameStr = (String)iter.next();
                aspectCombo.add(aspectNameStr);
            }
            aspectCombo.select(aspectCombo.indexOf(this.aspectName));
            gd = new GridData(1808);
            gd.widthHint = 250;
            aspectCombo.setLayoutData((Object)gd);
            new Label(composite, 0);
            aspectCombo.addSelectionListener((SelectionListener)new SelectionAdapter(this, aspectCombo){
                final /* synthetic */ MarkerSelectionDialog this$1;
                private final /* synthetic */ Combo val$aspectCombo;
                {
                    this.this$1 = markerSelectionDialog;
                    this.val$aspectCombo = combo;
                }

                public void widgetSelected(SelectionEvent e) {
                    MarkerSelectionDialog.access$0(this.this$1, this.val$aspectCombo.getItem(this.val$aspectCombo.getSelectionIndex()));
                }
            });
            Label iconLabel = new Label(composite, 0);
            iconLabel.setText(UIMessages.AJMarkersDialog_icon);
            iconLabel.setLayoutData((Object)new GridData(2));
            Table table = new Table(composite, 2564);
            TableColumn column = new TableColumn(table, 16384);
            TableItem noneItem = new TableItem(table, 0);
            noneItem.setText(NO_MARKERS);
            noneItem.setData((Object)NO_MARKERS);
            if (NO_MARKERS.equals(this.selection)) {
                table.setSelection(noneItem);
            }
            TableItem defaultItem = new TableItem(table, 0);
            defaultItem.setText(DEFAULT_MARKERS);
            if (this.selection == null) {
                table.setSelection(defaultItem);
            }
            defaultItem.setImage(AJMarkersDialog.this.defaultImage);
            if (this.selection != NO_MARKERS && this.selection != null && !this.selection.startsWith(AJMarkersDialog.SAMPLE)) {
                TableItem customItem = new TableItem(table, 0);
                customItem.setText(this.selection.substring(this.selection.lastIndexOf(47) + 1));
                customItem.setImage(AJMarkersDialog.this.create16x16Image(CustomMarkerImageProvider.getImage(this.selection)));
                customItem.setData((Object)this.selection);
                table.setSelection(customItem);
            }
            int i = 0;
            while (i < AJMarkersDialog.this.images16x16.length) {
                TableItem item = new TableItem(table, 0);
                item.setImage(AJMarkersDialog.this.images16x16[i]);
                item.setText(CustomMarkerImageProvider.sampleImageNames[i]);
                item.setData((Object)CustomMarkerImageProvider.sampleImageLocations[i]);
                if (CustomMarkerImageProvider.sampleImageLocations[i].equals(this.selection)) {
                    table.setSelection(item);
                }
                ++i;
            }
            column.pack();
            table.addSelectionListener((SelectionListener)new SelectionAdapter(this, table){
                final /* synthetic */ MarkerSelectionDialog this$1;
                private final /* synthetic */ Table val$table;
                {
                    this.this$1 = markerSelectionDialog;
                    this.val$table = table;
                }

                public void widgetSelected(SelectionEvent e) {
                    int selected = this.val$table.getSelectionIndex();
                    TableItem[] items = this.val$table.getItems();
                    MarkerSelectionDialog.access$1(this.this$1, (String)items[selected].getData());
                    MarkerSelectionDialog.access$2(this.this$1, 0).setEnabled(true);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    int selected = this.val$table.getSelectionIndex();
                    TableItem[] items = this.val$table.getItems();
                    MarkerSelectionDialog.access$1(this.this$1, (String)items[selected].getData());
                    MarkerSelectionDialog.access$2(this.this$1, 0).setEnabled(true);
                    MarkerSelectionDialog.access$3(this.this$1);
                }
            });
            table.setLayoutData((Object)new GridData(1808));
            Button browseIconButton = new Button(composite, 8);
            browseIconButton.setText(UIMessages.AJMarkersPropertyPage_browse);
            browseIconButton.setLayoutData((Object)new GridData(2));
            browseIconButton.addSelectionListener((SelectionListener)new SelectionAdapter(this, table, column){
                final /* synthetic */ MarkerSelectionDialog this$1;
                private final /* synthetic */ Table val$table;
                private final /* synthetic */ TableColumn val$column;
                {
                    this.this$1 = markerSelectionDialog;
                    this.val$table = table;
                    this.val$column = tableColumn;
                }

                public void widgetSelected(SelectionEvent e) {
                    MarkerImageSelectionDialog dialog = MarkerSelectionDialog.access$6(this.this$1).new MarkerImageSelectionDialog(this.this$1.getShell(), MarkerSelectionDialog.access$4(this.this$1));
                    dialog.create();
                    if (dialog.open() == 0) {
                        MarkerSelectionDialog.access$1(this.this$1, dialog.getFileLocation());
                        boolean alreadyThere = false;
                        TableItem[] items = this.val$table.getItems();
                        int i = 0;
                        while (i < items.length) {
                            if (MarkerSelectionDialog.access$5(this.this$1).equals(items[i].getData())) {
                                alreadyThere = true;
                                this.val$table.setSelection(items[i]);
                                break;
                            }
                            ++i;
                        }
                        if (!alreadyThere) {
                            TableItem tableItem = new TableItem(this.val$table, 0, 2);
                            tableItem.setText(dialog.getFileName());
                            tableItem.setData((Object)MarkerSelectionDialog.access$5(this.this$1));
                            tableItem.setImage(AJMarkersDialog.access$2(MarkerSelectionDialog.access$6(this.this$1), CustomMarkerImageProvider.getImage(MarkerSelectionDialog.access$5(this.this$1))));
                            this.val$table.setSelection(tableItem);
                            this.val$column.pack();
                        }
                        MarkerSelectionDialog.access$2(this.this$1, 0).setEnabled(true);
                    }
                }
            });
            return composite;
        }

        public String getSelection() {
            return this.selection;
        }

        public String getAspectName() {
            return this.aspectName;
        }

        static /* synthetic */ void access$0(MarkerSelectionDialog markerSelectionDialog, String string) {
            markerSelectionDialog.aspectName = string;
        }

        static /* synthetic */ void access$1(MarkerSelectionDialog markerSelectionDialog, String string) {
            markerSelectionDialog.selection = string;
        }

        static /* synthetic */ Button access$2(MarkerSelectionDialog markerSelectionDialog, int n) {
            return markerSelectionDialog.getButton(n);
        }

        static /* synthetic */ void access$3(MarkerSelectionDialog markerSelectionDialog) {
            markerSelectionDialog.okPressed();
        }

        static /* synthetic */ IProject access$4(MarkerSelectionDialog markerSelectionDialog) {
            return markerSelectionDialog.project;
        }

        static /* synthetic */ String access$5(MarkerSelectionDialog markerSelectionDialog) {
            return markerSelectionDialog.selection;
        }

        static /* synthetic */ AJMarkersDialog access$6(MarkerSelectionDialog markerSelectionDialog) {
            return markerSelectionDialog.AJMarkersDialog.this;
        }
    }
}

