/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.compiler.ast;

import java.util.ArrayList;
import java.util.List;
import org.aspectj.ajdt.internal.compiler.ast.AccessForInlineVisitor;
import org.aspectj.ajdt.internal.compiler.ast.AjMethodDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.AspectDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.AstUtil;
import org.aspectj.ajdt.internal.compiler.ast.AtAspectJAnnotationFactory;
import org.aspectj.ajdt.internal.compiler.ast.EclipseAttributeAdapter;
import org.aspectj.ajdt.internal.compiler.ast.MakeDeclsPublicVisitor;
import org.aspectj.ajdt.internal.compiler.ast.PointcutDesignator;
import org.aspectj.ajdt.internal.compiler.ast.Proceed;
import org.aspectj.ajdt.internal.compiler.ast.ThisJoinPointVisitor;
import org.aspectj.ajdt.internal.compiler.lookup.AjTypeConstants;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseFactory;
import org.aspectj.ajdt.internal.compiler.lookup.PrivilegedHandler;
import org.aspectj.bridge.context.CompilationAndWeavingContext;
import org.aspectj.bridge.context.ContextToken;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.aspectj.org.eclipse.jdt.internal.compiler.ClassFile;
import org.aspectj.org.eclipse.jdt.internal.compiler.CompilationResult;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Argument;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.aspectj.weaver.AdviceKind;
import org.aspectj.weaver.AjAttribute;
import org.aspectj.weaver.NameMangler;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.UnresolvedType;

public class AdviceDeclaration
extends AjMethodDeclaration {
    public PointcutDesignator pointcutDesignator;
    int baseArgumentCount;
    public Argument extraArgument;
    public AdviceKind kind;
    private int extraArgumentFlags = 0;
    public MethodBinding proceedMethodBinding;
    public List proceedCalls = new ArrayList(2);
    private boolean proceedInInners;
    private ResolvedMember[] proceedCallSignatures;
    private boolean[] formalsUnchangedToProceed;
    private UnresolvedType[] declaredExceptions;

    public AdviceDeclaration(CompilationResult result, AdviceKind kind) {
        super(result);
        this.returnType = TypeReference.baseTypeReference(6, 0);
        this.kind = kind;
    }

    protected int generateInfoAttributes(ClassFile classFile) {
        ArrayList<EclipseAttributeAdapter> l = new ArrayList<EclipseAttributeAdapter>(1);
        l.add(new EclipseAttributeAdapter(this.makeAttribute()));
        this.addDeclarationStartLineAttribute(l, classFile);
        return classFile.generateMethodInfoAttribute(this.binding, false, l);
    }

    private AjAttribute makeAttribute() {
        if (this.kind == AdviceKind.Around) {
            return new AjAttribute.AdviceAttribute(this.kind, this.pointcutDesignator.getPointcut(), this.extraArgumentFlags, this.sourceStart, this.sourceEnd, null, this.proceedInInners, this.proceedCallSignatures, this.formalsUnchangedToProceed, this.declaredExceptions);
        }
        return new AjAttribute.AdviceAttribute(this.kind, this.pointcutDesignator.getPointcut(), this.extraArgumentFlags, this.sourceStart, this.sourceEnd, null);
    }

    public void resolveStatements() {
        ReferenceBinding expectedTb;
        TypeBinding argTb;
        int bindingModifiers;
        if (this.binding == null || this.ignoreFurtherInvestigation) {
            return;
        }
        ClassScope upperScope = (ClassScope)this.scope.parent;
        this.modifiers = this.checkAndSetModifiers(this.modifiers, upperScope);
        this.binding.modifiers = bindingModifiers = this.modifiers | this.binding.modifiers & 0x40000000;
        if (this.kind == AdviceKind.AfterThrowing && this.extraArgument != null && !(argTb = this.extraArgument.binding.type).isCompatibleWith(expectedTb = upperScope.getJavaLangThrowable())) {
            this.scope.problemReporter().typeMismatchError(argTb, expectedTb, this.extraArgument);
            this.ignoreFurtherInvestigation = true;
            return;
        }
        this.pointcutDesignator.finishResolveTypes(this, this.binding, this.baseArgumentCount, upperScope.referenceContext.binding);
        if (this.binding == null || this.ignoreFurtherInvestigation) {
            return;
        }
        if (this.kind == AdviceKind.Around) {
            ReferenceBinding[] exceptions = new ReferenceBinding[]{upperScope.getJavaLangThrowable()};
            this.proceedMethodBinding = new MethodBinding(4104, "proceed".toCharArray(), this.binding.returnType, AdviceDeclaration.resize(this.baseArgumentCount + 1, this.binding.parameters), exceptions, this.binding.declaringClass);
            this.proceedMethodBinding.selector = CharOperation.concat(this.selector, this.proceedMethodBinding.selector);
        }
        super.resolveStatements();
        if (this.binding != null) {
            this.determineExtraArgumentFlags();
        }
        if (this.kind == AdviceKind.Around) {
            int n = this.proceedCalls.size();
            this.formalsUnchangedToProceed = new boolean[this.baseArgumentCount];
            this.proceedCallSignatures = new ResolvedMember[0];
            this.proceedInInners = false;
            this.declaredExceptions = new UnresolvedType[0];
            for (int i = 0; i < n; ++i) {
                Proceed call = (Proceed)this.proceedCalls.get(i);
                if (!call.inInner) continue;
                this.proceedInInners = true;
            }
            if (!this.proceedInInners) {
                PrivilegedHandler handler = (PrivilegedHandler)upperScope.referenceContext.binding.privilegedHandler;
                if (handler == null) {
                    handler = new PrivilegedHandler((AspectDeclaration)upperScope.referenceContext);
                }
                this.traverse((ASTVisitor)new MakeDeclsPublicVisitor(), (ClassScope)null);
                AccessForInlineVisitor v = new AccessForInlineVisitor((AspectDeclaration)upperScope.referenceContext, handler);
                ContextToken tok = CompilationAndWeavingContext.enteringPhase((int)17, (Object)this.selector);
                this.traverse((ASTVisitor)v, (ClassScope)null);
                CompilationAndWeavingContext.leavingPhase((ContextToken)tok);
                if (!v.isInlinable) {
                    this.proceedInInners = true;
                }
            }
        }
    }

    public int getDeclaredParameterCount() {
        return this.arguments.length - 3 - (this.extraArgument == null ? 0 : 1);
    }

    private void generateProceedMethod(ClassScope classScope, ClassFile classFile) {
        MethodBinding binding = this.proceedMethodBinding;
        classFile.generateMethodInfoHeader(binding);
        int methodAttributeOffset = classFile.contentsOffset;
        int attributeNumber = classFile.generateMethodInfoAttribute(binding, false, AstUtil.getAjSyntheticAttribute());
        int codeAttributeOffset = classFile.contentsOffset;
        classFile.generateCodeAttributeHeader();
        CodeStream codeStream = classFile.codeStream;
        codeStream.reset(this, classFile);
        int nargs = binding.parameters.length;
        int closureIndex = 0;
        for (int i = 0; i < nargs - 1; ++i) {
            closureIndex += AstUtil.slotsNeeded(binding.parameters[i]);
        }
        codeStream.aload(closureIndex);
        codeStream.generateInlinedValue(nargs - 1);
        codeStream.newArray(new ArrayBinding(classScope.getType(TypeConstants.JAVA_LANG_OBJECT, TypeConstants.JAVA_LANG_OBJECT.length), 1, classScope.environment()));
        int index = 0;
        for (int i = 0; i < nargs - 1; ++i) {
            TypeBinding type = binding.parameters[i];
            codeStream.dup();
            codeStream.generateInlinedValue(i);
            codeStream.load(type, index);
            index += AstUtil.slotsNeeded(type);
            if (type.isBaseType()) {
                codeStream.invokestatic(AjTypeConstants.getConversionMethodToObject(classScope, type));
            }
            codeStream.aastore();
        }
        ReferenceBinding closureType = (ReferenceBinding)binding.parameters[nargs - 1];
        MethodBinding runMethod = closureType.getMethods("run".toCharArray())[0];
        codeStream.invokevirtual(runMethod);
        TypeBinding returnType = binding.returnType;
        if (returnType.isBaseType()) {
            codeStream.invokestatic(AjTypeConstants.getConversionMethodFromObject(classScope, returnType));
        } else {
            codeStream.checkcast(returnType);
        }
        AstUtil.generateReturn(returnType, codeStream);
        codeStream.recordPositionsFrom(0, 1);
        classFile.completeCodeAttribute(codeAttributeOffset);
        classFile.completeMethodInfo(methodAttributeOffset, ++attributeNumber);
    }

    public void generateCode(ClassScope classScope, ClassFile classFile) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        super.generateCode(classScope, classFile);
        if (this.proceedMethodBinding != null) {
            this.generateProceedMethod(classScope, classFile);
        }
    }

    private void determineExtraArgumentFlags() {
        if (this.extraArgument != null) {
            this.extraArgumentFlags |= 1;
        }
        ThisJoinPointVisitor tjp = new ThisJoinPointVisitor(this);
        this.extraArgumentFlags |= tjp.removeUnusedExtraArguments();
    }

    private static TypeBinding[] resize(int newSize, TypeBinding[] bindings) {
        int len = bindings.length;
        TypeBinding[] ret = new TypeBinding[newSize];
        System.arraycopy(bindings, 0, ret, 0, Math.min(newSize, len));
        return ret;
    }

    public void addAtAspectJAnnotations() {
        Annotation adviceAnnotation = null;
        String pointcutExpression = this.pointcutDesignator.getPointcut().toString();
        String extraArgumentName = "";
        if (this.extraArgument != null) {
            extraArgumentName = new String(this.extraArgument.name);
        }
        String argNames = this.buildArgNameRepresentation();
        if (this.kind == AdviceKind.Before) {
            adviceAnnotation = AtAspectJAnnotationFactory.createBeforeAnnotation(pointcutExpression, argNames, this.declarationSourceStart);
        } else if (this.kind == AdviceKind.After) {
            adviceAnnotation = AtAspectJAnnotationFactory.createAfterAnnotation(pointcutExpression, argNames, this.declarationSourceStart);
        } else if (this.kind == AdviceKind.AfterReturning) {
            adviceAnnotation = AtAspectJAnnotationFactory.createAfterReturningAnnotation(pointcutExpression, argNames, extraArgumentName, this.declarationSourceStart);
        } else if (this.kind == AdviceKind.AfterThrowing) {
            adviceAnnotation = AtAspectJAnnotationFactory.createAfterThrowingAnnotation(pointcutExpression, argNames, extraArgumentName, this.declarationSourceStart);
        } else if (this.kind == AdviceKind.Around) {
            adviceAnnotation = AtAspectJAnnotationFactory.createAroundAnnotation(pointcutExpression, argNames, this.declarationSourceStart);
        }
        AtAspectJAnnotationFactory.addAnnotation(this, adviceAnnotation, this.scope);
    }

    private String buildArgNameRepresentation() {
        StringBuffer args = new StringBuffer();
        int numArgsWeCareAbout = this.getDeclaredParameterCount();
        if (this.arguments != null) {
            for (int i = 0; i < numArgsWeCareAbout; ++i) {
                if (i != 0) {
                    args.append(",");
                }
                args.append(new String(this.arguments[i].name));
            }
        }
        if (this.extraArgument != null) {
            if (numArgsWeCareAbout > 0) {
                args.append(",");
            }
            args.append(new String(this.extraArgument.name));
        }
        return args.toString();
    }

    public void postParse(TypeDeclaration typeDec) {
        AspectDeclaration aspectDecl = (AspectDeclaration)typeDec;
        int adviceSequenceNumberInType = aspectDecl.adviceCounter++;
        StringBuffer stringifiedPointcut = new StringBuffer(30);
        this.pointcutDesignator.print(0, stringifiedPointcut);
        this.selector = NameMangler.adviceName((String)EclipseFactory.getName(typeDec.binding).replace('.', '_'), (AdviceKind)this.kind, (int)adviceSequenceNumberInType, (int)stringifiedPointcut.toString().hashCode()).toCharArray();
        if (this.arguments != null) {
            this.baseArgumentCount = this.arguments.length;
        }
        if (this.kind == AdviceKind.Around) {
            this.extraArgument = AdviceDeclaration.makeFinalArgument("ajc_aroundClosure", AjTypeConstants.getAroundClosureType());
        }
        int addedArguments = 3;
        if (this.extraArgument != null) {
            ++addedArguments;
        }
        this.arguments = AdviceDeclaration.extendArgumentsLength(this.arguments, addedArguments);
        int index = this.baseArgumentCount;
        if (this.extraArgument != null) {
            this.arguments[index++] = this.extraArgument;
        }
        this.arguments[index++] = AdviceDeclaration.makeFinalArgument("thisJoinPointStaticPart", AjTypeConstants.getJoinPointStaticPartType());
        this.arguments[index++] = AdviceDeclaration.makeFinalArgument("thisJoinPoint", AjTypeConstants.getJoinPointType());
        this.arguments[index++] = AdviceDeclaration.makeFinalArgument("thisEnclosingJoinPointStaticPart", AjTypeConstants.getJoinPointStaticPartType());
        if (this.pointcutDesignator.isError()) {
            this.ignoreFurtherInvestigation = true;
        }
        this.pointcutDesignator.postParse(typeDec, this);
    }

    private int checkAndSetModifiers(int modifiers, ClassScope scope) {
        if (modifiers == 0) {
            return 1;
        }
        if (modifiers == 2048) {
            return 2049;
        }
        this.tagAsHavingErrors();
        scope.problemReporter().signalError(this.declarationSourceStart, this.sourceStart - 1, "illegal modifier on advice, only strictfp is allowed");
        return 1;
    }

    public static Argument[] addTjpArguments(Argument[] arguments) {
        int index = arguments.length;
        arguments = AdviceDeclaration.extendArgumentsLength(arguments, 3);
        arguments[index++] = AdviceDeclaration.makeFinalArgument("thisJoinPointStaticPart", AjTypeConstants.getJoinPointStaticPartType());
        arguments[index++] = AdviceDeclaration.makeFinalArgument("thisJoinPoint", AjTypeConstants.getJoinPointType());
        arguments[index++] = AdviceDeclaration.makeFinalArgument("thisEnclosingJoinPointStaticPart", AjTypeConstants.getJoinPointStaticPartType());
        return arguments;
    }

    private static Argument makeFinalArgument(String name, TypeReference typeRef) {
        long pos = 0L;
        return new Argument(name.toCharArray(), pos, typeRef, 16);
    }

    private static Argument[] extendArgumentsLength(Argument[] args, int addedArguments) {
        if (args == null) {
            return new Argument[addedArguments];
        }
        int len = args.length;
        Argument[] ret = new Argument[len + addedArguments];
        System.arraycopy(args, 0, ret, 0, len);
        return ret;
    }

    public StringBuffer printBody(int indent, StringBuffer output) {
        output.append(": ");
        if (this.pointcutDesignator != null) {
            output.append(this.pointcutDesignator.toString());
        }
        return super.printBody(indent, output);
    }

    public StringBuffer printReturnType(int indent, StringBuffer output) {
        if (this.kind == AdviceKind.Around) {
            return super.printReturnType(indent, output);
        }
        return output;
    }
}

