/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.core.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aspectj.asm.AsmManager;
import org.aspectj.asm.HierarchyWalker;
import org.aspectj.asm.IHierarchy;
import org.aspectj.asm.IProgramElement;
import org.aspectj.asm.IRelationshipMap;
import org.aspectj.asm.internal.Relationship;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AJLog;
import org.eclipse.ajdt.core.AspectJCore;
import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.core.CoreUtils;
import org.eclipse.ajdt.core.javaelements.AJCodeElement;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnit;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnitManager;
import org.eclipse.ajdt.core.javaelements.AJInjarElement;
import org.eclipse.ajdt.core.javaelements.AdviceElement;
import org.eclipse.ajdt.core.javaelements.AdviceElementInfo;
import org.eclipse.ajdt.core.javaelements.AspectElement;
import org.eclipse.ajdt.core.javaelements.AspectElementInfo;
import org.eclipse.ajdt.core.javaelements.DeclareElementInfo;
import org.eclipse.ajdt.core.javaelements.IntertypeElementInfo;
import org.eclipse.ajdt.core.javaelements.MockAdviceElement;
import org.eclipse.ajdt.core.javaelements.MockAspectElement;
import org.eclipse.ajdt.core.javaelements.MockDeclareElement;
import org.eclipse.ajdt.core.javaelements.MockIntertypeElement;
import org.eclipse.ajdt.core.javaelements.MockPointcutElement;
import org.eclipse.ajdt.core.javaelements.MockSourceMethod;
import org.eclipse.ajdt.core.javaelements.PointcutElementInfo;
import org.eclipse.ajdt.core.model.AJModel;
import org.eclipse.ajdt.core.model.AJRelationship;
import org.eclipse.ajdt.core.model.AJRelationshipManager;
import org.eclipse.ajdt.core.model.AJRelationshipType;
import org.eclipse.ajdt.core.text.CoreMessages;
import org.eclipse.ajdt.internal.core.model.BinaryWeavingSupport;
import org.eclipse.ajdt.internal.core.ras.CoreFFDC;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.CompilationUnitElementInfo;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.osgi.util.NLS;

public class AJProjectModel {
    private static final int MODEL_VERSION = 106;
    private static final String MODEL_FILE = ".elementMap";
    IProject project;
    private Map ipeToije = new HashMap();
    private Map jeLinkNames = new HashMap();
    private Map[] perRelMaps = new Map[]{new HashMap(), new HashMap(), new HashMap()};
    private Map kindMap = new HashMap();
    private Map extraChildren = new HashMap();
    private Set hasRuntime = new HashSet();
    private Map lineNumbers = new HashMap();
    private Persistence persistence;
    private int relsCount;
    private Map aspectsInJavaFiles = new HashMap();
    private List projectsToAsk = new ArrayList();
    private boolean fIncremental;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    public AJProjectModel(IProject project) {
        this.project = project;
        this.kindMap.put("advises", AJRelationshipManager.ADVISES);
        this.kindMap.put("advised by", AJRelationshipManager.ADVISED_BY);
        this.kindMap.put("declared on", AJRelationshipManager.DECLARED_ON);
        this.kindMap.put("aspect declarations", AJRelationshipManager.ASPECT_DECLARATIONS);
        this.kindMap.put("matched by", AJRelationshipManager.MATCHED_BY);
        this.kindMap.put("matches declare", AJRelationshipManager.MATCHES_DECLARE);
        this.kindMap.put("annotates", AJRelationshipManager.ANNOTATES);
        this.kindMap.put("annotated by", AJRelationshipManager.ANNOTATED_BY);
        this.kindMap.put("softens", AJRelationshipManager.SOFTENS);
        this.kindMap.put("softened by", AJRelationshipManager.SOFTENED_BY);
        this.kindMap.put("uses pointcut", AJRelationshipManager.USES_POINTCUT);
        this.kindMap.put("pointcut used by", AJRelationshipManager.POINTCUT_USED_BY);
    }

    public IJavaElement getCorrespondingJavaElement(IProgramElement ipe) {
        return (IJavaElement)this.ipeToije.get(ipe);
    }

    private Persistence getPersistence() {
        if (this.persistence == null) {
            this.persistence = new Persistence();
        }
        return this.persistence;
    }

    public void saveModel() {
        this.getPersistence().saveModel(null);
    }

    public void saveModel(IPath file) {
        this.getPersistence().saveModel(file);
    }

    public void loadModel() {
        if (!this.getPersistence().isPersisted()) {
            return;
        }
        AJLog.logStart("Load serialized element map");
        boolean worked = this.getPersistence().loadModel(null);
        AJLog.logEnd(0, "Load serialized element map", String.valueOf(this.relsCount) + " rels in project: " + this.project.getName());
        if (!worked && this.getPersistence().isPersisted()) {
            AJLog.log("Loading model failed for project: " + this.project.getName());
        }
    }

    public boolean loadModel(IPath file) {
        AJLog.logStart("Load serialized element map");
        boolean worked = this.getPersistence().loadModel(file);
        AJLog.logEnd(0, "Load serialized element map", String.valueOf(this.relsCount) + " rels in project: " + this.project.getName());
        if (!worked) {
            AJLog.log("Loading model failed for file: " + file);
            return false;
        }
        return true;
    }

    public void deleteModelFile() {
        this.getPersistence().deleteModelFile();
    }

    public List getRelatedElements(AJRelationshipType rel, IJavaElement je) {
        List rels = this.getLocalRelatedElements(rel, je);
        if (rels != null && rels.size() == 0) {
            rels = null;
        }
        ArrayList otherRels = null;
        Iterator iter = this.projectsToAsk.iterator();
        while (iter.hasNext()) {
            IProject otherProject = (IProject)iter.next();
            AJProjectModel otherModel = AJModel.getInstance().getModelForProject(otherProject);
            List l = otherModel.getOtherProjectRelatedElements(rel, je);
            if (l == null || l.size() <= 0) continue;
            if (otherRels == null) {
                otherRels = new ArrayList();
            }
            otherRels.addAll(l);
        }
        if (rels == null && otherRels == null) {
            return null;
        }
        if (otherRels == null) {
            return rels;
        }
        if (rels == null) {
            return otherRels;
        }
        ArrayList combined = new ArrayList(rels);
        combined.addAll(otherRels);
        return combined;
    }

    private List getLocalRelatedElements(AJRelationshipType rel, IJavaElement je) {
        Map relMap1 = (Map)this.perRelMaps[0].get(rel);
        Map relMap2 = (Map)this.perRelMaps[1].get(rel);
        List l1 = null;
        List l2 = null;
        if (relMap1 != null) {
            l1 = (List)relMap1.get(je);
        }
        if (relMap2 != null) {
            l2 = (List)relMap2.get(je);
        }
        if (l1 == null && l2 == null) {
            return null;
        }
        if (l2 == null) {
            return l1;
        }
        if (l1 == null) {
            return l2;
        }
        ArrayList combined = new ArrayList(l1);
        combined.addAll(l2);
        return combined;
    }

    private List getOtherProjectRelatedElements(AJRelationshipType rel, IJavaElement je) {
        Map relMap1 = (Map)this.perRelMaps[2].get(rel);
        List l1 = null;
        if (relMap1 != null) {
            l1 = (List)relMap1.get(je);
        }
        return l1;
    }

    public List getOtherProjectAllRelationships(AJRelationshipType[] rels) {
        ArrayList<AJRelationship> allRels = new ArrayList<AJRelationship>();
        int i = 0;
        while (i < rels.length) {
            Map relMap = (Map)this.perRelMaps[2].get(rels[i]);
            if (relMap != null) {
                Iterator iter = relMap.keySet().iterator();
                while (iter.hasNext()) {
                    IJavaElement source = (IJavaElement)iter.next();
                    List targetList = (List)relMap.get(source);
                    Iterator iter2 = targetList.iterator();
                    while (iter2.hasNext()) {
                        IJavaElement target = (IJavaElement)iter2.next();
                        allRels.add(new AJRelationship(source, rels[i], target, false));
                    }
                }
            }
            ++i;
        }
        return allRels;
    }

    public List getAllRelationships(AJRelationshipType[] rels) {
        ArrayList<AJRelationship> allRels = new ArrayList<AJRelationship>();
        int i = 0;
        while (i < rels.length) {
            int j = 0;
            while (j <= 1) {
                Map relMap = (Map)this.perRelMaps[j].get(rels[i]);
                if (relMap != null) {
                    Iterator iter = relMap.keySet().iterator();
                    while (iter.hasNext()) {
                        IJavaElement source = (IJavaElement)iter.next();
                        List targetList = (List)relMap.get(source);
                        Iterator iter2 = targetList.iterator();
                        while (iter2.hasNext()) {
                            IJavaElement target = (IJavaElement)iter2.next();
                            allRels.add(new AJRelationship(source, rels[i], target, j == 0));
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        Iterator iter = this.projectsToAsk.iterator();
        while (iter.hasNext()) {
            IProject otherProject = (IProject)iter.next();
            AJProjectModel otherModel = AJModel.getInstance().getModelForProject(otherProject);
            List l = otherModel.getOtherProjectAllRelationships(rels);
            if (l == null) continue;
            allRels.addAll(l);
        }
        return allRels;
    }

    public boolean isAdvised(IJavaElement je) {
        List advisedBy = this.getRelatedElements(AJRelationshipManager.ADVISED_BY, je);
        if (advisedBy != null && advisedBy.size() > 0) {
            return true;
        }
        List extras = this.getExtraChildren(je);
        if (extras != null) {
            Iterator iter = extras.iterator();
            while (iter.hasNext()) {
                IJavaElement element = (IJavaElement)iter.next();
                advisedBy = this.getRelatedElements(AJRelationshipManager.ADVISED_BY, element);
                if (advisedBy == null || advisedBy.size() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasRuntimeTest(IJavaElement je) {
        return this.hasRuntime.contains(je);
    }

    public int getJavaElementLineNumber(IJavaElement je) {
        Integer i = (Integer)this.lineNumbers.get(je);
        if (i != null) {
            return i;
        }
        Iterator iter = this.projectsToAsk.iterator();
        while (iter.hasNext()) {
            IProject otherProject = (IProject)iter.next();
            AJProjectModel otherModel = AJModel.getInstance().getModelForProject(otherProject);
            int l = otherModel.getJavaElementLineNumber(je);
            if (l == -1) continue;
            return l;
        }
        return -1;
    }

    public String getJavaElementLinkName(IJavaElement je) {
        String name = (String)this.jeLinkNames.get(je);
        if (name != null && name.length() > 0) {
            return name;
        }
        if (je.getParent() != null) {
            return String.valueOf(je.getParent().getElementName()) + '.' + je.getElementName();
        }
        return je.getElementName();
    }

    public List getExtraChildren(IJavaElement je) {
        return (List)this.extraChildren.get(je);
    }

    public Set getAspectsForJavaFile(ICompilationUnit javaFile) {
        Set aspects = (Set)this.aspectsInJavaFiles.get(javaFile);
        return aspects != null ? aspects : Collections.EMPTY_SET;
    }

    public void createProjectMap(boolean wasIncremental) {
        AJLog.logStart("Create element map");
        try {
            this.project.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) {
                    if (resource instanceof IFolder) {
                        return true;
                    }
                    if (resource instanceof IFile) {
                        IFile f = (IFile)resource;
                        if (CoreUtils.ASPECTJ_SOURCE_FILTER.accept(f.getName())) {
                            AJProjectModel.this.createMapForFile(f);
                        }
                        return false;
                    }
                    return true;
                }
            });
        }
        catch (CoreException coreException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, this, ajc$tjp_0, ajc$tjp_1);
        }
        this.processRelationships();
        this.fIncremental = wasIncremental;
        AJLog.logEnd(2, "Create element map", String.valueOf(this.relsCount) + " rels in project: " + this.project.getName());
    }

    protected boolean wasIncremental() {
        return this.fIncremental;
    }

    private void processRelationships() {
        this.relsCount = 0;
        IRelationshipMap asmRelMap = AsmManager.getDefault().getRelationshipMap();
        Iterator iter = asmRelMap.getEntries().iterator();
        while (iter.hasNext()) {
            String sourceOfRelationship = (String)iter.next();
            IProgramElement ipe = AsmManager.getDefault().getHierarchy().findElementForHandle(sourceOfRelationship);
            List relationships = asmRelMap.get(ipe);
            if (relationships == null) continue;
            Iterator iterator = relationships.iterator();
            while (iterator.hasNext()) {
                Relationship rel = (Relationship)iterator.next();
                AJRelationshipType ajRel = (AJRelationshipType)this.kindMap.get(rel.getName());
                List targets = rel.getTargets();
                Iterator iterator2 = targets.iterator();
                while (iterator2.hasNext()) {
                    ArrayList<IJavaElement> l;
                    Map perRelMap;
                    HashMap<IJavaElement, ArrayList<IJavaElement>> relMap;
                    String t = (String)iterator2.next();
                    IProgramElement link = AsmManager.getDefault().getHierarchy().findElementForHandle(t);
                    IJavaElement sourceEl = (IJavaElement)this.ipeToije.get(ipe);
                    IJavaElement targetEl = (IJavaElement)this.ipeToije.get(link);
                    if (ajRel == null || sourceEl == null) continue;
                    if (targetEl == null) {
                        IJavaElement foundTarget = null;
                        if (BinaryWeavingSupport.isActive) {
                            foundTarget = BinaryWeavingSupport.locateBinaryElementsInWorkspace(link);
                        }
                        if (foundTarget != null) {
                            targetEl = foundTarget;
                            int line = link.getSourceLocation().getLine();
                            this.addOppositeRelationship(ajRel, sourceEl, targetEl, line);
                        } else {
                            String filename = link.getSourceLocation().getSourceFileName();
                            String name = filename != null && filename.length() > 0 ? NLS.bind((String)CoreMessages.injarElementLabel2, (Object)link.getName(), (Object)filename) : NLS.bind((String)CoreMessages.injarElementLabel, (Object)link.getName());
                            targetEl = new AJInjarElement(name, link.getExtraInfo());
                            this.jeLinkNames.put(targetEl, name);
                            this.lineNumbers.put(targetEl, new Integer(0));
                        }
                    }
                    if (sourceEl == null || targetEl == null) continue;
                    if (sourceEl instanceof AdviceElement && rel.hasRuntimeTest()) {
                        this.hasRuntime.add(sourceEl);
                    }
                    if ((relMap = (HashMap<IJavaElement, ArrayList<IJavaElement>>)(perRelMap = rel.hasRuntimeTest() ? this.perRelMaps[0] : this.perRelMaps[1]).get(ajRel)) == null) {
                        relMap = new HashMap<IJavaElement, ArrayList<IJavaElement>>();
                        perRelMap.put(ajRel, relMap);
                    }
                    if ((l = (ArrayList<IJavaElement>)relMap.get(sourceEl)) == null) {
                        l = new ArrayList<IJavaElement>();
                        relMap.put(sourceEl, l);
                    }
                    l.add(targetEl);
                    ++this.relsCount;
                }
            }
        }
    }

    private void addRelationshipProvidingProject(IProject otherProject) {
        if (!this.projectsToAsk.contains(otherProject)) {
            this.projectsToAsk.add(otherProject);
        }
    }

    private void addOppositeRelationship(AJRelationshipType rel, IJavaElement sourceEl, IJavaElement targetEl, int line) {
        ArrayList<IJavaElement> l;
        AJRelationshipType oppRel = AJRelationshipManager.getInverseRelationship(rel);
        IProject otherProject = targetEl.getJavaProject().getProject();
        AJProjectModel otherModel = AJModel.getInstance().getModelForProject(otherProject);
        otherModel.addRelationshipProvidingProject(this.project);
        Map perRelMap = this.perRelMaps[2];
        HashMap<IJavaElement, ArrayList<IJavaElement>> relMap = (HashMap<IJavaElement, ArrayList<IJavaElement>>)perRelMap.get(oppRel);
        if (relMap == null) {
            relMap = new HashMap<IJavaElement, ArrayList<IJavaElement>>();
            perRelMap.put(oppRel, relMap);
        }
        if ((l = (ArrayList<IJavaElement>)relMap.get(targetEl)) == null) {
            l = new ArrayList<IJavaElement>();
            relMap.put(targetEl, l);
        }
        l.add(sourceEl);
        this.lineNumbers.put(targetEl, new Integer(line));
        if (oppRel == AJRelationshipManager.ADVISES) {
            BinaryWeavingSupport.removeAdviceDidNotMatchWarnings(targetEl, line);
        }
    }

    private void createMapForFile(IFile file) {
        AJCompilationUnit unit;
        IProject project = file.getProject();
        if (project == null || !project.isOpen() || !AspectJPlugin.isAJProject(project)) {
            return;
        }
        String path = file.getRawLocation().toOSString();
        HashMap annotationsMap = AsmManager.getDefault().getInlineAnnotations(path, true, true);
        if (annotationsMap == null) {
            return;
        }
        AJCompilationUnit u = AJCompilationUnitManager.INSTANCE.getAJCompilationUnit(file);
        if (u == null && file.getName().endsWith(".java")) {
            u = JavaCore.createCompilationUnitFrom((IFile)file);
        }
        if ((unit = u) == null) {
            return;
        }
        if (unit instanceof AJCompilationUnit) {
            try {
                unit.reconcile(0, false, null, null);
            }
            catch (JavaModelException javaModelException) {
                CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, this, ajc$tjp_2, ajc$tjp_3);
            }
        }
        Set keys = annotationsMap.keySet();
        if (!(unit instanceof AJCompilationUnit)) {
            IHierarchy hierarchy = AsmManager.getDefault().getHierarchy();
            IProgramElement pe = hierarchy.findElementForSourceFile(path.replace('\\', '/'));
            pe.walk(new HierarchyWalker((ICompilationUnit)unit){
                private final /* synthetic */ ICompilationUnit val$unit;
                private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
                private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
                {
                    this.val$unit = iCompilationUnit;
                }

                protected void preProcess(IProgramElement node) {
                    if (node.getKind() == IProgramElement.Kind.ASPECT) {
                        Set<AspectElement> l;
                        IProgramElement aspectPE = node;
                        String aspectName = aspectPE.getName();
                        if (AJProjectModel.this.aspectsInJavaFiles.get(this.val$unit) instanceof Set) {
                            l = (Set)AJProjectModel.this.aspectsInJavaFiles.get(this.val$unit);
                        } else {
                            l = new HashSet();
                            AJProjectModel.this.aspectsInJavaFiles.put(this.val$unit, l);
                        }
                        AspectElement aspectEl = null;
                        Iterator iter = l.iterator();
                        while (iter.hasNext()) {
                            AspectElement element = (AspectElement)iter.next();
                            if (!element.getElementName().equals(aspectName)) continue;
                            aspectEl = element;
                        }
                        if (aspectEl == null) {
                            AspectElementInfo info = new AspectElementInfo();
                            info.setAJKind(IProgramElement.Kind.ASPECT);
                            info.setSourceRangeStart(aspectPE.getSourceLocation().getOffset());
                            info.setAJAccessibility(aspectPE.getAccessibility());
                            aspectEl = new MockAspectElement((JavaElement)this.val$unit, aspectName, info);
                            l.add(aspectEl);
                            try {
                                ((CompilationUnitElementInfo)((CompilationUnit)this.val$unit).getElementInfo()).addChild((IJavaElement)aspectEl);
                            }
                            catch (JavaModelException javaModelException) {
                                CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, (Object)this, ajc$tjp_0, ajc$tjp_1);
                            }
                        }
                    }
                }

                static {
                    Factory factory = new Factory("AJProjectModel.java", Class.forName("org.eclipse.ajdt.core.model.AJProjectModel$2"));
                    ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.core.model.AJProjectModel$2-org.eclipse.jdt.core.JavaModelException-<missing>-"), 656);
                    ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-preProcess-org.eclipse.ajdt.core.model.AJProjectModel$2-org.aspectj.asm.IProgramElement:-node:--void-"), 629);
                }
            });
        }
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            Object key = it.next();
            List annotations = (List)annotationsMap.get(key);
            Iterator it2 = annotations.iterator();
            while (it2.hasNext()) {
                int offset;
                IProgramElement node = (IProgramElement)it2.next();
                ISourceLocation sl = node.getSourceLocation();
                int fff = 0;
                String declare = "declare ";
                if (node.toLinkLabelString().indexOf(declare) != -1) {
                    fff = declare.length();
                }
                if ((offset = sl.getOffset()) == 0) {
                    offset = node.getParent().getSourceLocation().getOffset();
                }
                try {
                    Set<AspectElement> l;
                    IJavaElement el = unit.getElementAt(offset + fff);
                    if (node.getKind() == IProgramElement.Kind.CODE) {
                        IJavaElement parent = el;
                        el = new AJCodeElement((JavaElement)parent, sl.getLine(), node.toLabelString(false));
                        ArrayList<IJavaElement> l2 = (ArrayList<IJavaElement>)this.extraChildren.get(parent);
                        if (l2 == null) {
                            l2 = new ArrayList<IJavaElement>();
                            this.extraChildren.put(parent, l2);
                        }
                        l2.add(el);
                    }
                    if (el != null && this.suitableMatch(el, node)) {
                        this.ipeToije.put(node, el);
                        this.jeLinkNames.put(el, node.toLinkLabelString(false));
                        this.lineNumbers.put(el, new Integer(sl.getLine()));
                        continue;
                    }
                    IProgramElement aspectPE = this.getAspect(node);
                    String aspectName = aspectPE.getName();
                    if (this.aspectsInJavaFiles.get((Object)unit) instanceof Set) {
                        l = (Set)this.aspectsInJavaFiles.get((Object)unit);
                    } else {
                        l = new HashSet();
                        this.aspectsInJavaFiles.put(unit, l);
                    }
                    AspectElement aspectEl = null;
                    Iterator iter = l.iterator();
                    while (iter.hasNext()) {
                        AspectElement element = (AspectElement)iter.next();
                        if (!element.getElementName().equals(aspectName)) continue;
                        aspectEl = element;
                    }
                    if (aspectEl == null) {
                        AspectElementInfo info = new AspectElementInfo();
                        info.setAJKind(IProgramElement.Kind.ASPECT);
                        info.setSourceRangeStart(aspectPE.getSourceLocation().getOffset());
                        info.setAJAccessibility(aspectPE.getAccessibility());
                        aspectEl = new MockAspectElement((JavaElement)unit, aspectName, info);
                        l.add(aspectEl);
                        ((CompilationUnitElementInfo)((CompilationUnit)unit).getElementInfo()).addChild((IJavaElement)aspectEl);
                    }
                    List params = node.getParameterNames();
                    String[] parameternames = null;
                    char[][] parameterNames = null;
                    if (params != null) {
                        parameternames = new String[params.size()];
                        parameterNames = new char[params.size()][];
                        int i = 0;
                        while (i < parameternames.length) {
                            parameternames[i] = (String)params.get(i);
                            parameterNames[i] = parameternames[i].toCharArray();
                            ++i;
                        }
                    }
                    if (node.getKind() == IProgramElement.Kind.ADVICE) {
                        AdviceElementInfo info = new AdviceElementInfo();
                        info.setAJKind(IProgramElement.Kind.ADVICE);
                        info.setAJExtraInfo(node.getExtraInfo());
                        info.setSourceRangeStart(node.getSourceLocation().getOffset());
                        info.setName(node.getName().toCharArray());
                        info.setArgumentNames(parameterNames);
                        el = new MockAdviceElement((JavaElement)aspectEl, node.getName(), parameternames, node.getExtraInfo(), info);
                    } else if (node.getKind() == IProgramElement.Kind.INTER_TYPE_CONSTRUCTOR || node.getKind() == IProgramElement.Kind.INTER_TYPE_FIELD || node.getKind() == IProgramElement.Kind.INTER_TYPE_METHOD || node.getKind() == IProgramElement.Kind.INTER_TYPE_PARENT) {
                        IntertypeElementInfo info = new IntertypeElementInfo();
                        info.setAJKind(node.getKind());
                        info.setAJExtraInfo(node.getExtraInfo());
                        info.setAJAccessibility(node.getAccessibility());
                        info.setSourceRangeStart(node.getSourceLocation().getOffset());
                        info.setName(node.getName().toCharArray());
                        info.setArgumentNames(parameterNames);
                        el = new MockIntertypeElement((JavaElement)aspectEl, node.getName(), parameternames, node.getExtraInfo(), info);
                    } else if (node.getKind() == IProgramElement.Kind.DECLARE_ANNOTATION_AT_CONSTRUCTOR || node.getKind() == IProgramElement.Kind.DECLARE_ANNOTATION_AT_FIELD || node.getKind() == IProgramElement.Kind.DECLARE_ANNOTATION_AT_METHOD || node.getKind() == IProgramElement.Kind.DECLARE_ANNOTATION_AT_TYPE || node.getKind() == IProgramElement.Kind.DECLARE_ERROR || node.getKind() == IProgramElement.Kind.DECLARE_WARNING || node.getKind() == IProgramElement.Kind.DECLARE_PARENTS || node.getKind() == IProgramElement.Kind.DECLARE_PRECEDENCE || node.getKind() == IProgramElement.Kind.DECLARE_SOFT) {
                        DeclareElementInfo info = new DeclareElementInfo();
                        String name = node.getName();
                        if (node.getKind() == IProgramElement.Kind.DECLARE_ERROR || node.getKind() == IProgramElement.Kind.DECLARE_WARNING) {
                            name = String.valueOf(name) + ": " + node.getDetails();
                        }
                        info.setAJKind(node.getKind());
                        info.setAJExtraInfo(node.getExtraInfo());
                        info.setSourceRangeStart(node.getSourceLocation().getOffset());
                        info.setName(name.toCharArray());
                        info.setArgumentNames(parameterNames);
                        el = new MockDeclareElement((JavaElement)aspectEl, name, parameternames, node.getExtraInfo(), info);
                    } else if (node.getKind() == IProgramElement.Kind.POINTCUT) {
                        PointcutElementInfo info = new PointcutElementInfo();
                        info.setAJKind(node.getKind());
                        info.setAJExtraInfo(node.getExtraInfo());
                        info.setSourceRangeStart(node.getSourceLocation().getOffset());
                        info.setName(node.getName().toCharArray());
                        info.setAJAccessibility(node.getAccessibility());
                        info.setArgumentNames(parameterNames);
                        el = new MockPointcutElement((JavaElement)aspectEl, node.getName(), parameternames, node.getExtraInfo(), info);
                    } else if (node.getKind() == IProgramElement.Kind.ASPECT) {
                        el = aspectEl;
                    } else if (node.getKind() == IProgramElement.Kind.METHOD) {
                        MockSourceMethod.MethodElementInfo info = new MockSourceMethod.MethodElementInfo();
                        info.setAJKind(node.getKind());
                        info.setAJExtraInfo(node.getExtraInfo());
                        info.setAJAccessibility(node.getAccessibility());
                        info.setSourceRangeStart(node.getSourceLocation().getOffset());
                        info.setName(node.getName().toCharArray());
                        info.setArgumentNames(parameterNames);
                        el = new MockSourceMethod((JavaElement)aspectEl, node.getName(), parameternames, info);
                    } else {
                        AJLog.log("AJProjectModel not able to create Mock element for " + node.getKind());
                    }
                    if (el == null) continue;
                    ArrayList<IJavaElement> l2 = (ArrayList<IJavaElement>)this.extraChildren.get((Object)unit);
                    if (l2 == null) {
                        l2 = new ArrayList<IJavaElement>();
                        this.extraChildren.put(unit, l2);
                    }
                    l2.add(el);
                    this.ipeToije.put(node, el);
                    this.jeLinkNames.put(el, node.toLinkLabelString(false));
                    this.lineNumbers.put(el, new Integer(sl.getLine()));
                }
                catch (JavaModelException javaModelException) {
                    CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, this, ajc$tjp_4, ajc$tjp_3);
                }
            }
        }
    }

    private boolean suitableMatch(IJavaElement el, IProgramElement node) {
        return !(el instanceof IType) || node.getKind() == IProgramElement.Kind.ASPECT || node.getKind() == IProgramElement.Kind.CLASS || node.getKind() == IProgramElement.Kind.ANNOTATION || node.getKind() == IProgramElement.Kind.INTERFACE || node.getKind() == IProgramElement.Kind.ENUM;
    }

    private IProgramElement getAspect(IProgramElement node) {
        if (node.getKind() == IProgramElement.Kind.ASPECT) {
            return node;
        }
        if (node.getParent() != null) {
            return this.getAspect(node.getParent());
        }
        return null;
    }

    static {
        Factory factory = new Factory("AJProjectModel.java", Class.forName("org.eclipse.ajdt.core.model.AJProjectModel"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.core.model.AJProjectModel-org.eclipse.core.runtime.CoreException-<missing>-"), 420);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-createProjectMap-org.eclipse.ajdt.core.model.AJProjectModel-boolean:-wasIncremental:--void-"), 402);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.core.model.AJProjectModel-org.eclipse.jdt.core.JavaModelException-<missing>-"), 619);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-createMapForFile-org.eclipse.ajdt.core.model.AJProjectModel-org.eclipse.core.resources.IFile:-file:--void-"), 578);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.core.model.AJProjectModel-org.eclipse.jdt.core.JavaModelException-<missing>-"), 820);
    }

    private class Persistence {
        private static final int RUNTIME_OFFSET = 100;
        private static final int OTHER_PROJ_OFFSET = 200;
        private Map idMap;
        private int idCount;
        private List elementList;
        private AJRelationshipType[] relTypes = AJRelationshipManager.getAllRelationshipTypes();
        private Map relIDs = new HashMap();
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;

        public Persistence() {
            int i = 0;
            while (i < this.relTypes.length) {
                this.relIDs.put(this.relTypes[i], new Integer(i));
                ++i;
            }
        }

        public boolean isPersisted() {
            return this.getDefaultFile().toFile().exists();
        }

        private IPath getDefaultFile() {
            return AspectJPlugin.getDefault().getStateLocation().append(String.valueOf(AJProjectModel.this.project.getName()) + AJProjectModel.MODEL_FILE);
        }

        public void saveModel(IPath path) {
            if (path == null) {
                path = this.getDefaultFile();
            }
            try {
                FileOutputStream fos = new FileOutputStream(path.toFile());
                ObjectOutputStream oos = new ObjectOutputStream(fos);
                this.saveVersion(oos);
                this.saveJavaElements(oos);
                this.saveRelationships(oos);
                this.saveExtraChildren(oos);
                this.saveAspects(oos);
                this.saveOtherProjectList(oos);
                oos.flush();
                fos.flush();
                oos.close();
                fos.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(fileNotFoundException, this, ajc$tjp_0, ajc$tjp_1);
            }
            catch (IOException iOException) {
                CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(iOException, this, ajc$tjp_2, ajc$tjp_1);
            }
        }

        public boolean loadModel(IPath path) {
            if (path == null) {
                path = this.getDefaultFile();
            }
            if (!path.toFile().exists()) {
                return false;
            }
            try {
                FileInputStream fis = new FileInputStream(path.toFile());
                ObjectInputStream ois = new ObjectInputStream(fis);
                int version = this.loadVersion(ois);
                if (version == 105 || version == 106) {
                    this.loadJavaElements(ois);
                    this.loadRelationships(ois);
                    this.loadExtraChildren(ois);
                    this.loadAspects(ois);
                }
                if (version == 106) {
                    this.loadOtherProjectList(ois);
                }
                ois.close();
                fis.close();
                return true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(classNotFoundException, this, ajc$tjp_3, ajc$tjp_4);
            }
            catch (FileNotFoundException fileNotFoundException) {
                CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(fileNotFoundException, this, ajc$tjp_5, ajc$tjp_4);
            }
            catch (IOException iOException) {
                CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(iOException, this, ajc$tjp_6, ajc$tjp_4);
            }
            return false;
        }

        public void deleteModelFile() {
            IPath path = this.getDefaultFile();
            File modelFile = path.toFile();
            if (modelFile.exists()) {
                modelFile.delete();
            }
        }

        private int getID(IJavaElement el) {
            return (Integer)this.idMap.get(el);
        }

        void saveVersion(ObjectOutputStream oos) throws IOException {
            oos.writeInt(106);
        }

        int loadVersion(ObjectInputStream ois) throws IOException {
            return ois.readInt();
        }

        void saveJavaElements(ObjectOutputStream oos) throws IOException {
            this.idMap = new HashMap();
            this.idCount = 0;
            int numElements = AJProjectModel.this.lineNumbers.keySet().size();
            oos.writeInt(numElements);
            Iterator iter = AJProjectModel.this.lineNumbers.keySet().iterator();
            while (iter.hasNext()) {
                IJavaElement element = (IJavaElement)iter.next();
                this.idMap.put(element, new Integer(this.idCount++));
                String handleIdentifier = element.getHandleIdentifier().intern();
                oos.writeObject(handleIdentifier);
                String linkName = (String)AJProjectModel.this.jeLinkNames.get(element);
                oos.writeObject(linkName);
                Integer lineNum = (Integer)AJProjectModel.this.lineNumbers.get(element);
                oos.writeInt(lineNum);
            }
        }

        void loadJavaElements(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            int numElements = ois.readInt();
            this.elementList = new ArrayList(numElements);
            int i = 0;
            while (i < numElements) {
                String handleIdentifier = (String)ois.readObject();
                IJavaElement element = AspectJCore.create(handleIdentifier);
                this.elementList.add(element);
                String linkName = (String)ois.readObject();
                AJProjectModel.this.jeLinkNames.put(element, linkName);
                Integer lineNum = new Integer(ois.readInt());
                AJProjectModel.this.lineNumbers.put(element, lineNum);
                ++i;
            }
        }

        private int encodeRelType(AJRelationshipType rel, boolean hasRuntimeTest, boolean isOtherProjectRel) {
            int id = (Integer)this.relIDs.get(rel);
            if (hasRuntimeTest) {
                id += 100;
            } else if (isOtherProjectRel) {
                id += 200;
            }
            return id;
        }

        private AJRelationshipType decodeRelType(int id) {
            if (id >= 200) {
                id -= 200;
            }
            if (id >= 100) {
                id -= 100;
            }
            if (id < this.relTypes.length) {
                return this.relTypes[id];
            }
            return null;
        }

        private boolean hasRuntimeTest(int id) {
            return id >= 100 && id < 200;
        }

        private boolean isOtherProjectRel(int id) {
            return id >= 200;
        }

        void saveRelationships(ObjectOutputStream oos) throws IOException {
            Map relMap;
            int i;
            AJRelationshipType rel;
            int numRelTypes = 0;
            Iterator iter = AJProjectModel.this.kindMap.values().iterator();
            while (iter.hasNext()) {
                rel = (AJRelationshipType)iter.next();
                i = 0;
                while (i <= 2) {
                    relMap = (Map)AJProjectModel.this.perRelMaps[i].get(rel);
                    if (relMap != null) {
                        ++numRelTypes;
                    }
                    ++i;
                }
            }
            oos.writeInt(numRelTypes);
            iter = AJProjectModel.this.kindMap.values().iterator();
            while (iter.hasNext()) {
                rel = (AJRelationshipType)iter.next();
                i = 0;
                while (i <= 2) {
                    relMap = (Map)AJProjectModel.this.perRelMaps[i].get(rel);
                    if (relMap != null) {
                        oos.writeInt(this.encodeRelType(rel, i == 0, i == 2));
                        oos.writeInt(relMap.size());
                        Iterator iter2 = relMap.keySet().iterator();
                        while (iter2.hasNext()) {
                            IJavaElement source = (IJavaElement)iter2.next();
                            oos.writeInt(this.getID(source));
                            List targetList = (List)relMap.get(source);
                            oos.writeInt(targetList.size());
                            Iterator iter3 = targetList.iterator();
                            while (iter3.hasNext()) {
                                IJavaElement target = (IJavaElement)iter3.next();
                                oos.writeInt(this.getID(target));
                            }
                        }
                    }
                    ++i;
                }
            }
        }

        void loadRelationships(ObjectInputStream ois) throws IOException {
            AJProjectModel.this.relsCount = 0;
            int numRelTypes = ois.readInt();
            int i = 0;
            while (i < numRelTypes) {
                int relType = ois.readInt();
                int numRels = ois.readInt();
                AJRelationshipType ajRel = this.decodeRelType(relType);
                if (ajRel == null) {
                    int j = 0;
                    while (j < numRels) {
                        ois.readInt();
                        int numTargets = ois.readInt();
                        int k = 0;
                        while (k < numTargets) {
                            ois.readInt();
                            ++k;
                        }
                        ++j;
                    }
                } else {
                    HashMap relMap;
                    Map perRelMap;
                    Map map = perRelMap = this.hasRuntimeTest(relType) ? AJProjectModel.this.perRelMaps[0] : AJProjectModel.this.perRelMaps[1];
                    if (this.isOtherProjectRel(relType)) {
                        perRelMap = AJProjectModel.this.perRelMaps[2];
                    }
                    if ((relMap = (HashMap)perRelMap.get(ajRel)) == null) {
                        relMap = new HashMap();
                        perRelMap.put(ajRel, relMap);
                    }
                    int j = 0;
                    while (j < numRels) {
                        ArrayList<IJavaElement> l;
                        int sourceID = ois.readInt();
                        IJavaElement sourceEl = (IJavaElement)this.elementList.get(sourceID);
                        if (this.hasRuntimeTest(relType)) {
                            AJProjectModel.this.hasRuntime.add(sourceEl);
                        }
                        if ((l = (ArrayList<IJavaElement>)relMap.get(sourceEl)) == null) {
                            l = new ArrayList<IJavaElement>();
                            relMap.put(sourceEl, l);
                        }
                        int numTargets = ois.readInt();
                        int k = 0;
                        while (k < numTargets) {
                            int targetID = ois.readInt();
                            IJavaElement targetEl = (IJavaElement)this.elementList.get(targetID);
                            l.add(targetEl);
                            AJProjectModel aJProjectModel = AJProjectModel.this;
                            aJProjectModel.relsCount = aJProjectModel.relsCount + 1;
                            ++k;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }

        void saveExtraChildren(ObjectOutputStream oos) throws IOException {
            int numParents = AJProjectModel.this.extraChildren.size();
            oos.writeInt(numParents);
            Iterator iter = AJProjectModel.this.extraChildren.keySet().iterator();
            while (iter.hasNext()) {
                IJavaElement parent = (IJavaElement)iter.next();
                oos.writeObject(parent.getHandleIdentifier());
                List children = (List)AJProjectModel.this.extraChildren.get(parent);
                oos.writeInt(children.size());
                Iterator iterator = children.iterator();
                while (iterator.hasNext()) {
                    IJavaElement child = (IJavaElement)iterator.next();
                    oos.writeInt(this.getID(child));
                }
            }
        }

        void loadExtraChildren(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            int numParents = ois.readInt();
            int i = 0;
            while (i < numParents) {
                String parentHandle = (String)ois.readObject();
                IJavaElement parent = AspectJCore.create(parentHandle);
                int numChildren = ois.readInt();
                ArrayList<IJavaElement> children = new ArrayList<IJavaElement>(numChildren);
                int j = 0;
                while (j < numChildren) {
                    int childID = ois.readInt();
                    IJavaElement je = (IJavaElement)this.elementList.get(childID);
                    children.add(je);
                    ++j;
                }
                AJProjectModel.this.extraChildren.put(parent, children);
                ++i;
            }
        }

        void saveAspects(ObjectOutputStream oos) throws IOException {
            Set aspects;
            int numAspects = 0;
            Iterator iter = AJProjectModel.this.aspectsInJavaFiles.values().iterator();
            while (iter.hasNext()) {
                aspects = (Set)iter.next();
                numAspects += aspects.size();
            }
            oos.writeInt(numAspects);
            iter = AJProjectModel.this.aspectsInJavaFiles.values().iterator();
            while (iter.hasNext()) {
                aspects = (Set)iter.next();
                Iterator iterator = aspects.iterator();
                while (iterator.hasNext()) {
                    IJavaElement aspect = (IJavaElement)iterator.next();
                    oos.writeObject(aspect.getHandleIdentifier());
                }
            }
        }

        void loadAspects(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            int numAspects = ois.readInt();
            int i = 0;
            while (i < numAspects) {
                String aspectHandle = (String)ois.readObject();
                IJavaElement aspect = AspectJCore.create(aspectHandle);
                ICompilationUnit file = ((AspectElement)aspect).getCompilationUnit();
                HashSet<IJavaElement> aspectsForFile = (HashSet<IJavaElement>)AJProjectModel.this.aspectsInJavaFiles.get(file);
                if (aspectsForFile == null) {
                    aspectsForFile = new HashSet<IJavaElement>();
                    AJProjectModel.this.aspectsInJavaFiles.put(file, aspectsForFile);
                }
                aspectsForFile.add(aspect);
                ++i;
            }
        }

        void saveOtherProjectList(ObjectOutputStream oos) throws IOException {
            int numProjects = AJProjectModel.this.projectsToAsk.size();
            oos.writeInt(numProjects);
            Iterator iter = AJProjectModel.this.projectsToAsk.iterator();
            while (iter.hasNext()) {
                IProject project = (IProject)iter.next();
                oos.writeObject(project.getName());
            }
        }

        void loadOtherProjectList(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            int numProjects = ois.readInt();
            int i = 0;
            while (i < numProjects) {
                String projName = (String)ois.readObject();
                AJProjectModel.this.projectsToAsk.add(AspectJPlugin.getWorkspace().getRoot().getProject(projName));
                ++i;
            }
        }

        static {
            Factory factory = new Factory("AJProjectModel.java", Class.forName("org.eclipse.ajdt.core.model.AJProjectModel$Persistence"));
            ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.core.model.AJProjectModel$Persistence-java.io.FileNotFoundException-<missing>-"), 974);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-saveModel-org.eclipse.ajdt.core.model.AJProjectModel$Persistence-org.eclipse.core.runtime.IPath:-path:--void-"), 955);
            ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.core.model.AJProjectModel$Persistence-java.io.IOException-<missing>-"), 975);
            ajc$tjp_3 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.core.model.AJProjectModel$Persistence-java.lang.ClassNotFoundException-<missing>-"), 1006);
            ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-loadModel-org.eclipse.ajdt.core.model.AJProjectModel$Persistence-org.eclipse.core.runtime.IPath:-path:--boolean-"), 982);
            ajc$tjp_5 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.core.model.AJProjectModel$Persistence-java.io.FileNotFoundException-<missing>-"), 1007);
            ajc$tjp_6 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.core.model.AJProjectModel$Persistence-java.io.IOException-<missing>-"), 1008);
        }
    }
}

