/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.core.ajde;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.aspectj.ajde.core.IOutputLocationManager;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.internal.core.ras.CoreFFDC;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class CoreOutputLocationManager
implements IOutputLocationManager {
    private String projectName;
    private IProject project;
    private IJavaProject jProject;
    private File defaultOutput;
    private Map srcFolderToOutput = new HashMap();
    private List allOutputFolders = new ArrayList();
    private boolean outputIsRoot;
    private File commonOutputDir;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    public CoreOutputLocationManager(IProject project) {
        this.project = project;
        this.jProject = JavaCore.create((IProject)project);
        if (!this.isUsingSeparateOutputFolders(this.jProject)) {
            this.setCommonOutputDir();
            this.allOutputFolders.add(this.commonOutputDir);
        } else {
            this.init();
        }
    }

    private void init() {
        this.outputIsRoot = false;
        this.projectName = this.jProject.getProject().getName();
        try {
            this.defaultOutput = this.workspacePathToFile(this.jProject.getOutputLocation());
            this.allOutputFolders.add(this.defaultOutput);
            IClasspathEntry[] cpe = this.jProject.getRawClasspath();
            int i = 0;
            while (i < cpe.length) {
                IPath output;
                if (cpe[i].getEntryKind() == 3 && (output = cpe[i].getOutputLocation()) != null) {
                    IPath path = cpe[i].getPath();
                    String srcFolder = path.removeFirstSegments(1).toPortableString();
                    if (path.segmentCount() == 1) {
                        srcFolder = path.toPortableString();
                    }
                    File out = this.workspacePathToFile(output);
                    this.srcFolderToOutput.put(srcFolder, out);
                    if (!this.allOutputFolders.contains(out)) {
                        this.allOutputFolders.add(out);
                    }
                    if (this.outputIsRoot) {
                        this.defaultOutput = out;
                    }
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, this, ajc$tjp_0, ajc$tjp_1);
        }
    }

    public File getOutputLocationForClass(File compilationUnit) {
        return this.getOutputLocationForResource(compilationUnit);
    }

    public File getOutputLocationForResource(File resource) {
        if (!this.isUsingSeparateOutputFolders(this.jProject)) {
            return this.commonOutputDir;
        }
        String fileName = resource.toString().replace('\\', '/');
        int ind = fileName.indexOf(this.projectName);
        if (ind != -1) {
            String rest = fileName.substring(ind + this.projectName.length() + 1);
            Iterator iter = this.srcFolderToOutput.keySet().iterator();
            while (iter.hasNext()) {
                String src = (String)iter.next();
                if (!rest.startsWith(src)) continue;
                File out = (File)this.srcFolderToOutput.get(src);
                return out;
            }
        }
        return this.defaultOutput;
    }

    private boolean isUsingSeparateOutputFolders(IJavaProject jp) {
        try {
            IClasspathEntry[] cpe = jp.getRawClasspath();
            int i = 0;
            while (i < cpe.length) {
                if (cpe[i].getEntryKind() == 3 && cpe[i].getOutputLocation() != null) {
                    return true;
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, this, ajc$tjp_2, ajc$tjp_3);
        }
        return false;
    }

    private void setCommonOutputDir() {
        IPath workspaceRelativeOutputPath;
        IJavaProject jProject = JavaCore.create((IProject)this.project);
        try {
            workspaceRelativeOutputPath = jProject.getOutputLocation();
        }
        catch (JavaModelException javaModelException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, this, ajc$tjp_4, ajc$tjp_5);
            this.commonOutputDir = this.project.getLocation().toFile();
            return;
        }
        if (workspaceRelativeOutputPath.segmentCount() == 1) {
            this.commonOutputDir = jProject.getResource().getLocation().toFile();
            return;
        }
        IFolder out = ResourcesPlugin.getWorkspace().getRoot().getFolder(workspaceRelativeOutputPath);
        this.commonOutputDir = out.getLocation().toFile();
    }

    private File workspacePathToFile(IPath path) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        if (path.segmentCount() == 1) {
            IResource res = root.findMember(path);
            this.outputIsRoot = true;
            return res.getLocation().toFile();
        }
        IFolder out = root.getFolder(path);
        return out.getLocation().toFile();
    }

    public List getAllOutputLocations() {
        return this.allOutputFolders;
    }

    public File getDefaultOutputLocation() {
        if (!this.isUsingSeparateOutputFolders(this.jProject)) {
            return this.commonOutputDir;
        }
        return this.defaultOutput;
    }

    static {
        Factory factory = new Factory("CoreOutputLocationManager.java", Class.forName("org.eclipse.ajdt.internal.core.ajde.CoreOutputLocationManager"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.core.ajde.CoreOutputLocationManager-org.eclipse.jdt.core.JavaModelException-<missing>-"), 101);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-init-org.eclipse.ajdt.internal.core.ajde.CoreOutputLocationManager----void-"), 73);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.core.ajde.CoreOutputLocationManager-org.eclipse.jdt.core.JavaModelException-<missing>-"), 143);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-isUsingSeparateOutputFolders-org.eclipse.ajdt.internal.core.ajde.CoreOutputLocationManager-org.eclipse.jdt.core.IJavaProject:-jp:--boolean-"), 133);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.core.ajde.CoreOutputLocationManager-org.eclipse.jdt.core.JavaModelException-<missing>-"), 157);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-setCommonOutputDir-org.eclipse.ajdt.internal.core.ajde.CoreOutputLocationManager----void-"), 152);
    }
}

