/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.internal.core.ras.CoreFFDC;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.util.Util;

public class BuildConfig {
    private static Map projectsToIncludedSourceFiles;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    static {
        Factory factory = new Factory("BuildConfig.java", Class.forName("org.eclipse.ajdt.core.BuildConfig"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.core.BuildConfig-org.eclipse.jdt.core.JavaModelException-<missing>-"), 72);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-getIncludedSourceFiles-org.eclipse.ajdt.core.BuildConfig-org.eclipse.core.resources.IProject:-project:--java.util.List-"), 44);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.core.BuildConfig-org.eclipse.core.runtime.CoreException-<missing>-"), 113);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-allFiles-org.eclipse.ajdt.core.BuildConfig-org.eclipse.core.resources.IContainer:-folder:--java.util.List-"), 100);
        projectsToIncludedSourceFiles = new WeakHashMap();
    }

    public static List getIncludedSourceFiles(IProject project) {
        if (projectsToIncludedSourceFiles.get(project) instanceof List) {
            return (List)projectsToIncludedSourceFiles.get(project);
        }
        ArrayList<IFile> sourceFiles = new ArrayList<IFile>();
        try {
            IJavaProject jp = JavaCore.create((IProject)project);
            IClasspathEntry[] cpes = jp.getRawClasspath();
            int i = 0;
            while (i < cpes.length) {
                if (cpes[i] instanceof ClasspathEntry && cpes[i].getEntryKind() == 3) {
                    ClasspathEntry cp = (ClasspathEntry)cpes[i];
                    char[][] incl = cp.fullInclusionPatternChars();
                    char[][] excl = cp.fullExclusionPatternChars();
                    IPath path = cpes[i].getPath();
                    IResource res = project.findMember(path.removeFirstSegments(1));
                    if (res != null && res instanceof IContainer) {
                        List l = BuildConfig.allFiles((IContainer)res);
                        Iterator iter = l.iterator();
                        while (iter.hasNext()) {
                            IFile file = (IFile)iter.next();
                            if (Util.isExcluded((IResource)file, (char[][])incl, (char[][])excl)) continue;
                            sourceFiles.add(file);
                        }
                    }
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$1$31280822(javaModelException, ajc$tjp_0, ajc$tjp_1);
        }
        projectsToIncludedSourceFiles.put(project, sourceFiles);
        return sourceFiles;
    }

    public static void flushIncludedSourceFileCache(IProject project) {
        projectsToIncludedSourceFiles.remove(project);
    }

    public static boolean isIncluded(IResource file) {
        IJavaProject jp = JavaCore.create((IProject)file.getProject());
        return jp.isOnClasspath(file);
    }

    private static List allFiles(IContainer folder) {
        final ArrayList contents = new ArrayList();
        try {
            folder.accept(new IResourceVisitor(){

                public boolean visit(IResource res) {
                    if (res.getType() == 1 && JavaCore.isJavaLikeFileName((String)res.getName())) {
                        contents.add(res);
                    }
                    return true;
                }
            });
        }
        catch (CoreException coreException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$1$31280822(coreException, ajc$tjp_2, ajc$tjp_3);
        }
        return contents;
    }
}

