/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.core.model;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.aspectj.asm.IProgramElement;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AJLog;
import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.core.model.AJProjectModel;
import org.eclipse.ajdt.core.model.AJRelationshipType;
import org.eclipse.ajdt.internal.core.ras.CoreFFDC;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;

public class AJModel {
    private static AJModel instance;
    private Map projectModelMap = new HashMap();
    private Map priorModelMap = new HashMap();
    private Map priorFullBuildModelMap = new HashMap();
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    private AJModel() {
    }

    public static AJModel getInstance() {
        if (instance == null) {
            instance = new AJModel();
        }
        return instance;
    }

    public void saveAllModels() {
        Iterator iter = this.projectModelMap.keySet().iterator();
        while (iter.hasNext()) {
            IProject project = (IProject)iter.next();
            AJProjectModel pm = (AJProjectModel)this.projectModelMap.get(project);
            pm.saveModel();
        }
    }

    public void saveModel(IProject project) {
        AJProjectModel pm = this.getModelForProject(project);
        if (pm != null) {
            pm.saveModel();
        }
    }

    public AJProjectModel getModelForProject(IProject project) {
        if (project == null || !project.isAccessible() || !AspectJPlugin.isAJProject(project)) {
            return null;
        }
        AJProjectModel pm = (AJProjectModel)this.projectModelMap.get(project);
        if (pm != null) {
            return pm;
        }
        AJProjectModel projectModel = new AJProjectModel(project);
        this.projectModelMap.put(project, projectModel);
        projectModel.loadModel();
        return projectModel;
    }

    public AJProjectModel getPreviousModel(IProject project) {
        return (AJProjectModel)this.priorModelMap.get(project);
    }

    public AJProjectModel getPreviousFullBuildModel(IProject project) {
        return (AJProjectModel)this.priorFullBuildModelMap.get(project);
    }

    public List getRelatedElements(AJRelationshipType rel, IJavaElement je) {
        if (je == null) {
            return null;
        }
        IJavaProject jp = je.getJavaProject();
        if (jp == null) {
            return null;
        }
        AJProjectModel pm = this.getModelForProject(jp.getProject());
        if (pm == null) {
            return null;
        }
        return pm.getRelatedElements(rel, je);
    }

    public boolean isAdvised(IJavaElement je) {
        if (je == null) {
            return false;
        }
        IJavaProject jp = je.getJavaProject();
        if (jp == null) {
            return false;
        }
        AJProjectModel pm = this.getModelForProject(jp.getProject());
        if (pm == null) {
            return false;
        }
        return pm.isAdvised(je);
    }

    public boolean hasRuntimeTest(IJavaElement je) {
        if (je == null) {
            return false;
        }
        IJavaProject jp = je.getJavaProject();
        if (jp == null) {
            return false;
        }
        AJProjectModel pm = this.getModelForProject(jp.getProject());
        if (pm == null) {
            return false;
        }
        return pm.hasRuntimeTest(je);
    }

    public List getExtraChildren(IJavaElement je) {
        if (je == null) {
            return null;
        }
        IJavaProject jp = je.getJavaProject();
        if (jp == null) {
            return null;
        }
        AJProjectModel pm = this.getModelForProject(jp.getProject());
        if (pm == null) {
            return null;
        }
        return pm.getExtraChildren(je);
    }

    public void createMap(IProject project) {
        this.createMap(project, false, false);
    }

    public void createMap(IProject project, boolean updatePrior, final boolean wasIncremental) {
        AJProjectModel prev;
        if (updatePrior && (prev = (AJProjectModel)this.projectModelMap.get(project)) != null) {
            this.priorModelMap.put(project, prev);
            if (!prev.wasIncremental()) {
                this.priorFullBuildModelMap.put(project, prev);
            }
        }
        final AJProjectModel projectModel = new AJProjectModel(project);
        this.projectModelMap.put(project, projectModel);
        try {
            AspectJPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) {
                    projectModel.createProjectMap(wasIncremental);
                }
            }, null);
        }
        catch (CoreException coreException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, this, ajc$tjp_0, ajc$tjp_1);
        }
    }

    public void clearMap(IProject project, boolean delete) {
        AJProjectModel pm = (AJProjectModel)this.projectModelMap.get(project);
        if (pm != null && delete) {
            pm.deleteModelFile();
        }
        this.projectModelMap.remove(project);
        AJLog.log("Cleared AJDT relationship map for project " + project.getName());
    }

    public List getAllRelationships(IProject project, AJRelationshipType[] rels) {
        AJProjectModel pm = this.getModelForProject(project);
        if (pm == null) {
            return null;
        }
        return pm.getAllRelationships(rels);
    }

    public int getJavaElementLineNumber(IJavaElement je) {
        if (je == null) {
            return -1;
        }
        IJavaProject jp = je.getJavaProject();
        if (jp == null) {
            return -1;
        }
        AJProjectModel pm = this.getModelForProject(jp.getProject());
        if (pm == null) {
            return -1;
        }
        return pm.getJavaElementLineNumber(je);
    }

    public String getJavaElementLinkName(IJavaElement je) {
        if (je == null) {
            return "";
        }
        IJavaProject jp = je.getJavaProject();
        if (jp == null) {
            return je.getElementName();
        }
        AJProjectModel pm = this.getModelForProject(jp.getProject());
        if (pm == null) {
            return je.getElementName();
        }
        return pm.getJavaElementLinkName(je);
    }

    public IJavaElement getCorrespondingJavaElement(IProgramElement ipe) {
        IResource res = this.programElementToResource(ipe);
        if (res != null && res instanceof IFile) {
            IFile file = (IFile)res;
            AJProjectModel pm = this.getModelForProject(file.getProject());
            if (pm == null) {
                return null;
            }
            return pm.getCorrespondingJavaElement(ipe);
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private IResource programElementToResource(IProgramElement ipe) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static {
        Factory factory = new Factory("AJModel.java", Class.forName("org.eclipse.ajdt.core.model.AJModel"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.core.model.AJModel-org.eclipse.core.runtime.CoreException-<missing>-"), 198);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-createMap-org.eclipse.ajdt.core.model.AJModel-org.eclipse.core.resources.IProject:boolean:boolean:-project:updatePrior:wasIncremental:--void-"), 178);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.core.model.AJModel-java.io.IOException-<missing>-"), 303);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-programElementToResource-org.eclipse.ajdt.core.model.AJModel-org.aspectj.asm.IProgramElement:-ipe:--org.eclipse.core.resources.IResource-"), 284);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.core.model.AJModel-java.io.IOException-<missing>-"), 303);
    }
}

