/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.diff;

import com.ibm.icu.text.DateFormat;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.model.AJProjectModel;
import org.eclipse.ajdt.core.model.AJRelationshipManager;
import org.eclipse.ajdt.core.model.AJRelationshipType;
import org.eclipse.ajdt.internal.ui.text.UIMessages;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;

public class AJMapEditor
extends EditorPart
implements IPropertyChangeListener {
    private ScrolledComposite fScrolledComposite;
    private Color fBackgroundColor;
    private Color fForegroundColor;
    private Color fSeparatorColor;
    private List fBannerLabels = new ArrayList();
    private List fHeaderLabels = new ArrayList();
    private Font fFont;
    private static final int HORIZONTAL_SCROLL_INCREMENT = 10;
    private static final int VERTICAL_SCROLL_INCREMENT = 10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.setPartName(input.getName());
        this.setContentDescription(input.getName());
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        Display display = parent.getDisplay();
        this.fBackgroundColor = display.getSystemColor(25);
        this.fForegroundColor = display.getSystemColor(24);
        this.fSeparatorColor = new Color((Device)display, 152, 170, 203);
        JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this);
        this.fScrolledComposite = new ScrolledComposite(parent, 768);
        this.fScrolledComposite.setAlwaysShowScrollBars(false);
        this.fScrolledComposite.setExpandHorizontal(true);
        this.fScrolledComposite.setExpandVertical(true);
        this.fScrolledComposite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)AJMapEditor.this);
                AJMapEditor.this.fScrolledComposite = null;
                AJMapEditor.this.fSeparatorColor.dispose();
                AJMapEditor.this.fSeparatorColor = null;
                AJMapEditor.this.fBannerLabels.clear();
                AJMapEditor.this.fHeaderLabels.clear();
                if (AJMapEditor.this.fFont != null) {
                    AJMapEditor.this.fFont.dispose();
                    AJMapEditor.this.fFont = null;
                }
            }
        });
        this.fScrolledComposite.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                Rectangle clientArea = AJMapEditor.this.fScrolledComposite.getClientArea();
                ScrollBar verticalBar = AJMapEditor.this.fScrolledComposite.getVerticalBar();
                verticalBar.setIncrement(10);
                verticalBar.setPageIncrement(clientArea.height - verticalBar.getIncrement());
                ScrollBar horizontalBar = AJMapEditor.this.fScrolledComposite.getHorizontalBar();
                horizontalBar.setIncrement(10);
                horizontalBar.setPageIncrement(clientArea.width - horizontalBar.getIncrement());
            }
        });
        Composite composite = this.createComposite((Composite)this.fScrolledComposite);
        composite.setLayout((Layout)new GridLayout());
        this.createTitleLabel(composite, UIMessages.ajmapEditor_title);
        this.createLabel(composite, null);
        this.createLabel(composite, null);
        this.createHeadingLabel(composite, UIMessages.ajmapEditor_heading);
        this.createSeparator(composite);
        this.createText(composite, UIMessages.ajmapEditor_description);
        this.createSeparator(composite);
        this.createLabel(composite, null);
        this.createLabel(composite, null);
        this.createHeadingLabel(composite, UIMessages.ajmapEditor_info_heading);
        this.createSeparator(composite);
        String info = this.getMapInfo();
        if (info != null) {
            this.createText(composite, info);
            this.createSeparator(composite);
        }
        this.fScrolledComposite.setContent((Control)composite);
        this.fScrolledComposite.setMinSize(composite.computeSize(-1, -1));
    }

    private void createSeparator(Composite parent) {
        Composite separator = this.createCompositeSeparator(parent);
        GridData data = new GridData(768);
        data.heightHint = 2;
        separator.setLayoutData((Object)data);
    }

    private String getMapInfo() {
        IEditorInput input = this.getEditorInput();
        if (input != null && input instanceof FileEditorInput) {
            IFile file = ((FileEditorInput)input).getFile();
            return this.getInfoForModelFile(file.getProject(), file.getLocation());
        }
        return null;
    }

    private String getInfoForModelFile(IProject project, IPath path) {
        AJProjectModel model = new AJProjectModel(project);
        boolean worked = model.loadModel(path);
        if (!worked) {
            return null;
        }
        if (!path.toFile().exists()) {
            return null;
        }
        StringBuffer info = new StringBuffer();
        long lastMod = path.toFile().lastModified();
        if (lastMod > 0L) {
            String lastModStr = DateFormat.getDateTimeInstance().format(new Date(lastMod));
            info.append(NLS.bind((String)UIMessages.ajmapEditor_last_mod_date, (Object)lastModStr));
            info.append("\n");
        }
        try {
            FileInputStream fis = new FileInputStream(path.toFile());
            ObjectInputStream ois = new ObjectInputStream(fis);
            int version = ois.readInt();
            ois.close();
            fis.close();
            info.append(NLS.bind((String)UIMessages.ajmapEditor_file_version, (Object)("" + version)));
            info.append("\n");
        }
        catch (IOException iOException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(iOException, (Object)this, ajc$tjp_0, ajc$tjp_1);
        }
        info.append("\n");
        info.append(UIMessages.ajmapEditor_rel_heading);
        info.append("\n");
        AJRelationshipType[] relTypes = AJRelationshipManager.getAllRelationshipTypes();
        int total = 0;
        int i = 0;
        while (i < relTypes.length) {
            int n = model.getAllRelationships(new AJRelationshipType[]{relTypes[i]}).size();
            if (n > 0) {
                info.append(String.valueOf(n) + " " + relTypes[i].getDisplayName() + "\n");
                total += n;
            }
            ++i;
        }
        info.append(NLS.bind((String)UIMessages.ajmapEditor_rel_total, (Object)("" + total)));
        return info.toString();
    }

    private Composite createComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(this.fBackgroundColor);
        return composite;
    }

    private Composite createCompositeSeparator(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(this.fSeparatorColor);
        return composite;
    }

    private Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        if (text != null) {
            label.setText(text);
        }
        label.setBackground(this.fBackgroundColor);
        label.setForeground(this.fForegroundColor);
        return label;
    }

    private Text createText(Composite parent, String text) {
        Text label = new Text(parent, 10);
        if (text != null) {
            label.setText(text);
        }
        label.setBackground(this.fBackgroundColor);
        label.setForeground(this.fForegroundColor);
        return label;
    }

    private Label createTitleLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        if (text != null) {
            label.setText(text);
        }
        label.setBackground(this.fBackgroundColor);
        label.setForeground(this.fForegroundColor);
        label.setFont(JFaceResources.getHeaderFont());
        this.fHeaderLabels.add(label);
        return label;
    }

    private Label createHeadingLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        if (text != null) {
            label.setText(text);
        }
        label.setBackground(this.fBackgroundColor);
        label.setForeground(this.fForegroundColor);
        label.setFont(JFaceResources.getBannerFont());
        this.fBannerLabels.add(label);
        return label;
    }

    public void setFocus() {
        this.fScrolledComposite.setFocus();
    }

    public void propertyChange(PropertyChangeEvent event) {
        Label label;
        Iterator iterator = this.fBannerLabels.iterator();
        while (iterator.hasNext()) {
            label = (Label)iterator.next();
            label.setFont(JFaceResources.getBannerFont());
        }
        iterator = this.fHeaderLabels.iterator();
        while (iterator.hasNext()) {
            label = (Label)iterator.next();
            label.setFont(JFaceResources.getHeaderFont());
        }
        Control control = this.fScrolledComposite.getContent();
        this.fScrolledComposite.setMinSize(control.computeSize(-1, -1));
        this.fScrolledComposite.setContent(control);
        this.fScrolledComposite.layout(true);
        this.fScrolledComposite.redraw();
    }

    static {
        Factory factory = new Factory("AJMapEditor.java", Class.forName("org.eclipse.ajdt.internal.ui.diff.AJMapEditor"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.diff.AJMapEditor-java.io.IOException-<missing>-"), 239);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-getInfoForModelFile-org.eclipse.ajdt.internal.ui.diff.AJMapEditor-org.eclipse.core.resources.IProject:org.eclipse.core.runtime.IPath:-project:path:--java.lang.String-"), 212);
    }
}

