/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.lazystart;

import java.util.ArrayList;
import org.aspectj.asm.IProgramElement;
import org.eclipse.ajdt.core.AspectJCorePreferences;
import org.eclipse.ajdt.core.BuildConfig;
import org.eclipse.ajdt.core.javaelements.AJCodeElement;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnit;
import org.eclipse.ajdt.core.javaelements.AdviceElement;
import org.eclipse.ajdt.core.javaelements.DeclareElement;
import org.eclipse.ajdt.core.javaelements.IAspectJElement;
import org.eclipse.ajdt.core.javaelements.IntertypeElement;
import org.eclipse.ajdt.core.model.AJModel;
import org.eclipse.ajdt.internal.ui.lazystart.Utils;
import org.eclipse.ajdt.internal.ui.resources.AJDTIcon;
import org.eclipse.ajdt.internal.ui.resources.AspectJImages;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.jdt.internal.ui.viewsupport.TreeHierarchyLayoutProblemsDecorator;
import org.eclipse.jdt.ui.JavaElementImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.decorators.DecoratorManager;

public class ImageDecorator
implements ILabelDecorator {
    private ArrayList listeners = new ArrayList(2);
    private ImageDescriptorRegistry fRegistry;
    private boolean preventRecursion = false;
    private TreeHierarchyLayoutProblemsDecorator problemsDecorator = new TreeHierarchyLayoutProblemsDecorator();
    private DecoratorManager decman = WorkbenchPlugin.getDefault().getDecoratorManager();

    public void addListener(ILabelProviderListener listener) {
        this.listeners.add(listener);
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
        this.listeners.remove(listener);
    }

    public Image decorateImage(Image image, Object element) {
        Image img;
        block30: {
            if (this.preventRecursion) {
                return null;
            }
            if (!Utils.isBundleActive()) {
                return null;
            }
            img = null;
            if (element instanceof ICompilationUnit) {
                ICompilationUnit comp = (ICompilationUnit)element;
                IFile file = null;
                try {
                    file = (IFile)comp.getCorrespondingResource();
                }
                catch (JavaModelException javaModelException) {}
                if (file != null && comp instanceof AJCompilationUnit) {
                    if (BuildConfig.isIncluded((IResource)file)) {
                        Rectangle rect = image.getBounds();
                        img = this.getImageLabel(ImageDecorator.getJavaImageDescriptor(AspectJImages.ASPECTJ_FILE.getImageDescriptor(), rect, 0));
                    } else {
                        Rectangle rect = image.getBounds();
                        img = this.getImageLabel(ImageDecorator.getJavaImageDescriptor(AspectJImages.EXCLUDED_ASPECTJ_FILE.getImageDescriptor(), rect, 0));
                    }
                }
            } else if (element instanceof IFile) {
                IFile file = (IFile)element;
                if (file.getFileExtension() != null) {
                    if (file.getFileExtension().equals("ajproperties")) {
                        img = this.getImageLabel(AspectJImages.BC_FILE.getImageDescriptor());
                    } else if (!file.getFileExtension().equals("jar")) {
                        file.getFileExtension().equals("zip");
                    }
                }
            } else if (element instanceof JarPackageFragmentRoot) {
                try {
                    IClasspathEntry entry = ((JarPackageFragmentRoot)element).getRawClasspathEntry();
                    if (entry == null) break block30;
                    if (AspectJCorePreferences.isOnAspectpath((IClasspathEntry)entry)) {
                        img = this.getImageLabel(AspectJImages.JAR_ON_ASPECTPATH.getImageDescriptor());
                    } else if (AspectJCorePreferences.isOnInpath((IClasspathEntry)entry)) {
                        img = this.getImageLabel(AspectJImages.JAR_ON_INPATH.getImageDescriptor());
                    }
                }
                catch (JavaModelException javaModelException) {}
            } else if (element instanceof AJCodeElement) {
                img = this.getImageLabel(AspectJImages.AJ_CODE.getImageDescriptor());
            } else if (element instanceof IAspectJElement) {
                try {
                    IAspectJElement ajElem = (IAspectJElement)element;
                    if (ajElem.getJavaProject().getProject().exists()) {
                        IProgramElement.Accessibility acceb = ajElem.getAJAccessibility();
                        AJDTIcon icon = null;
                        icon = acceb == null ? (ajElem instanceof AdviceElement ? AspectJImages.instance().getAdviceIcon(ajElem.getAJExtraInformation(), AJModel.getInstance().hasRuntimeTest((IJavaElement)ajElem)) : (ajElem instanceof IntertypeElement ? AspectJImages.instance().getStructureIcon(ajElem.getAJKind(), ajElem.getAJAccessibility()) : (ajElem instanceof DeclareElement ? AspectJImages.instance().getStructureIcon(ajElem.getAJKind(), ajElem.getAJAccessibility()) : AspectJImages.instance().getIcon(ajElem.getAJKind())))) : AspectJImages.instance().getStructureIcon(ajElem.getAJKind(), ajElem.getAJAccessibility());
                        if (icon != null) {
                            img = this.getImageLabel(ImageDecorator.getJavaImageDescriptor(icon.getImageDescriptor(), image.getBounds(), this.computeJavaAdornmentFlags((IJavaElement)ajElem)));
                        }
                    }
                }
                catch (JavaModelException javaModelException) {}
            }
        }
        if (img != null) {
            this.preventRecursion = true;
            img = this.problemsDecorator.decorateImage(img, element);
            img = this.decman.decorateImage(img, element);
            this.preventRecursion = false;
            return img;
        }
        return null;
    }

    private Image getImageLabel(ImageDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        return this.getRegistry().get(descriptor);
    }

    private ImageDescriptorRegistry getRegistry() {
        if (this.fRegistry == null) {
            this.fRegistry = JavaPlugin.getImageDescriptorRegistry();
        }
        return this.fRegistry;
    }

    public static ImageDescriptor getJavaImageDescriptor(ImageDescriptor descriptor, Rectangle rect, int adorflags) {
        int flags = rect.width == 16 ? 2 : 0;
        Point size = ImageDecorator.useSmallSize(flags) ? JavaElementImageProvider.SMALL_SIZE : JavaElementImageProvider.BIG_SIZE;
        return new JavaElementImageDescriptor(descriptor, adorflags, size);
    }

    private static boolean useSmallSize(int flags) {
        return (flags & 2) != 0;
    }

    public String decorateText(String text, Object element) {
        IJavaProject jp;
        if (element instanceof IJavaProject && Utils.isAJProject((jp = (IJavaProject)element).getProject())) {
            AspectJUIPlugin.getDefault();
        }
        if (!Utils.isBundleActive()) {
            return null;
        }
        if (element instanceof DeclareElement) {
            if (text.endsWith("()")) {
                return text.substring(0, text.length() - 2);
            }
        } else if (element instanceof IntertypeElement) {
            IntertypeElement itd = (IntertypeElement)element;
            try {
                if (itd.getAJKind() == IProgramElement.Kind.INTER_TYPE_FIELD && text.endsWith("()")) {
                    return text.substring(0, text.length() - 2);
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return null;
    }

    private int computeJavaAdornmentFlags(IJavaElement element) {
        int flags = 0;
        if (element instanceof IMember) {
            try {
                int modifiers;
                IMember member = (IMember)element;
                if (element.getElementType() == 9 && ((IMethod)element).isConstructor()) {
                    flags |= 0x200;
                }
                if (Flags.isAbstract((int)(modifiers = member.getFlags())) && ImageDecorator.confirmAbstract(member)) {
                    flags |= 1;
                }
                if (Flags.isFinal((int)modifiers) || ImageDecorator.isInterfaceField(member)) {
                    flags |= 2;
                }
                if (Flags.isSynchronized((int)modifiers) && ImageDecorator.confirmSynchronized((IJavaElement)member)) {
                    flags |= 4;
                }
                if (Flags.isStatic((int)modifiers) || ImageDecorator.isInterfaceField(member)) {
                    flags |= 8;
                }
                if (Flags.isDeprecated((int)modifiers)) {
                    flags |= 0x400;
                }
                if (member.getElementType() == 7 && JavaModelUtil.hasMainMethod((IType)((IType)member))) {
                    flags |= 0x10;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return flags;
    }

    private static boolean confirmAbstract(IMember element) throws JavaModelException {
        if (element.getElementType() == 7) {
            return ((IType)element).isClass();
        }
        return element.getDeclaringType().isClass();
    }

    private static boolean isInterfaceField(IMember element) throws JavaModelException {
        if (element.getElementType() == 8) {
            return element.getDeclaringType().isInterface();
        }
        return false;
    }

    private static boolean confirmSynchronized(IJavaElement member) {
        return member.getElementType() != 7;
    }
}

