/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.wizards.exports;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.internal.ui.build.ProductExportJob;
import org.eclipse.ajdt.internal.ui.wizards.exports.BaseExportWizard;
import org.eclipse.ajdt.internal.ui.wizards.exports.ProductExportWizardPage;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.FeatureModelManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.exports.FeatureExportInfo;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.iproduct.IProductFeature;
import org.eclipse.pde.internal.core.iproduct.IProductModel;
import org.eclipse.pde.internal.core.iproduct.IProductPlugin;
import org.eclipse.pde.internal.core.product.WorkspaceProductModel;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.wizards.exports.CrossPlatformExportPage;
import org.eclipse.pde.internal.ui.wizards.product.SynchronizationOperation;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.IProgressConstants;

public class ProductExportWizard
extends BaseExportWizard {
    private static final String STORE_SECTION = "ProductExportWizard";
    private WorkspaceProductModel fProductModel;
    private CrossPlatformExportPage fPage2;
    private ProductExportWizardPage fPage;
    private IProject fProject;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    public ProductExportWizard() {
        this(null);
    }

    public ProductExportWizard(IProject project) {
        this.setDefaultPageImageDescriptor(PDEPluginImages.DESC_PRODUCT_EXPORT_WIZ);
        this.fProject = project;
    }

    public void addPages() {
        this.fPage = new ProductExportWizardPage(this.getSelection());
        this.addPage((IWizardPage)this.fPage);
        IFeatureModel model = PDECore.getDefault().getFeatureModelManager().getDeltaPackFeature();
        if (model != null) {
            this.fPage2 = new CrossPlatformExportPage("environment", model);
            this.addPage((IWizardPage)this.fPage2);
        }
    }

    protected String getSettingsSectionName() {
        return STORE_SECTION;
    }

    protected void scheduleExportJob() {
        FeatureExportInfo info = new FeatureExportInfo();
        info.toDirectory = this.fPage.doExportToDirectory();
        info.exportSource = this.fPage.doExportSource();
        info.destinationDirectory = this.fPage.getDestination();
        info.zipFileName = this.fPage.getFileName();
        if (this.fPage2 != null && this.fPage.doMultiPlatform()) {
            info.targets = this.fPage2.getTargets();
        }
        info.items = this.fProductModel.getProduct().useFeatures() ? this.getFeatureModels() : this.getPluginModels();
        String rootDirectory = this.fPage.getRootDirectory();
        if ("".equals(rootDirectory.trim())) {
            rootDirectory = ".";
        }
        ProductExportJob job = new ProductExportJob(info, (IProductModel)this.fProductModel, rootDirectory);
        job.setUser(true);
        job.schedule();
        job.setProperty(IProgressConstants.ICON_PROPERTY, PDEPluginImages.DESC_FEATURE_OBJ);
    }

    private IFeatureModel[] getFeatureModels() {
        ArrayList<IFeatureModel> list = new ArrayList<IFeatureModel>();
        FeatureModelManager manager = PDECore.getDefault().getFeatureModelManager();
        IProductFeature[] features = this.fProductModel.getProduct().getFeatures();
        int i = 0;
        while (i < features.length) {
            IFeatureModel model = manager.findFeatureModel(features[i].getId(), features[i].getVersion());
            if (model != null) {
                list.add(model);
            }
            ++i;
        }
        return list.toArray(new IFeatureModel[list.size()]);
    }

    private BundleDescription[] getPluginModels() {
        BundleDescription bundle;
        ArrayList<BundleDescription> list = new ArrayList<BundleDescription>();
        State state = TargetPlatformHelper.getState();
        IProductPlugin[] plugins = this.fProductModel.getProduct().getPlugins();
        int i = 0;
        while (i < plugins.length) {
            bundle = state.getBundle(plugins[i].getId(), null);
            if (bundle != null) {
                list.add(bundle);
            }
            ++i;
        }
        IPluginModelBase launcherPlugin = PluginRegistry.findModel((String)"org.eclipse.equinox.launcher");
        if (launcherPlugin != null && (bundle = launcherPlugin.getBundleDescription()) != null && !list.contains(bundle)) {
            list.add(bundle);
            BundleDescription[] fragments = bundle.getFragments();
            int i2 = 0;
            while (i2 < fragments.length) {
                if (!list.contains(fragments[i2])) {
                    list.add(fragments[i2]);
                }
                ++i2;
            }
        }
        return list.toArray(new BundleDescription[list.size()]);
    }

    protected boolean performPreliminaryChecks() {
        this.fProductModel = new WorkspaceProductModel(this.fPage.getProductFile(), false);
        try {
            this.fProductModel.load();
            if (!this.fProductModel.isLoaded()) {
                MessageDialog.openError((Shell)this.getContainer().getShell(), (String)PDEUIMessages.ProductExportWizard_error, (String)PDEUIMessages.ProductExportWizard_corrupt);
                return false;
            }
        }
        catch (CoreException coreException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_0, ajc$tjp_1);
            MessageDialog.openError((Shell)this.getContainer().getShell(), (String)PDEUIMessages.ProductExportWizard_error, (String)PDEUIMessages.ProductExportWizard_corrupt);
            return false;
        }
        if (this.fPage.doSync()) {
            try {
                this.getContainer().run(false, false, (IRunnableWithProgress)new SynchronizationOperation(this.fProductModel.getProduct(), this.getContainer().getShell(), this.fProject));
            }
            catch (InvocationTargetException invocationTargetException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(invocationTargetException, (Object)this, ajc$tjp_2, ajc$tjp_1);
                InvocationTargetException e = invocationTargetException;
                MessageDialog.openError((Shell)this.getContainer().getShell(), (String)PDEUIMessages.ProductExportWizard_syncTitle, (String)e.getTargetException().getMessage());
                return false;
            }
            catch (InterruptedException interruptedException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(interruptedException, (Object)this, ajc$tjp_3, ajc$tjp_1);
                return false;
            }
        }
        return true;
    }

    protected boolean confirmDelete() {
        File zipFile;
        if (!this.fPage.doExportToDirectory() && (zipFile = new File(this.fPage.getDestination(), this.fPage.getFileName())).exists()) {
            if (!MessageDialog.openQuestion((Shell)this.getContainer().getShell(), (String)PDEUIMessages.BaseExportWizard_confirmReplace_title, (String)NLS.bind((String)PDEUIMessages.BaseExportWizard_confirmReplace_desc, (Object)zipFile.getAbsolutePath()))) {
                return false;
            }
            zipFile.delete();
        }
        return true;
    }

    public boolean canFinish() {
        return this.fPage.getNextPage() != null ? super.canFinish() : this.fPage.isPageComplete();
    }

    static {
        Factory factory = new Factory("ProductExportWizard.java", Class.forName("org.eclipse.ajdt.internal.ui.wizards.exports.ProductExportWizard"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.wizards.exports.ProductExportWizard-org.eclipse.core.runtime.CoreException-<missing>-"), 144);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-performPreliminaryChecks-org.eclipse.ajdt.internal.ui.wizards.exports.ProductExportWizard----boolean-"), 136);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.wizards.exports.ProductExportWizard-java.lang.reflect.InvocationTargetException-e-"), 152);
        ajc$tjp_3 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.wizards.exports.ProductExportWizard-java.lang.InterruptedException-<missing>-"), 155);
    }
}

