/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.markers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.aspectj.asm.IProgramElement;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AJLog;
import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.core.javaelements.AJInjarElement;
import org.eclipse.ajdt.core.javaelements.AdviceElement;
import org.eclipse.ajdt.core.javaelements.AspectElement;
import org.eclipse.ajdt.core.model.AJModel;
import org.eclipse.ajdt.core.model.AJProjectModel;
import org.eclipse.ajdt.core.model.AJRelationship;
import org.eclipse.ajdt.core.model.AJRelationshipManager;
import org.eclipse.ajdt.core.model.AJRelationshipType;
import org.eclipse.ajdt.core.model.ModelComparison;
import org.eclipse.ajdt.internal.ui.diff.ChangesView;
import org.eclipse.ajdt.internal.ui.markers.AJMarkersDialog;
import org.eclipse.ajdt.internal.ui.preferences.AspectJPreferences;
import org.eclipse.ajdt.internal.ui.text.UIMessages;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.AnnotationPreferenceLookup;

public class MarkerUpdating {
    private static final String CHANGED_ADVICE_ANNOTATION_TYPE = "org.eclipse.ajdt.changedAdvice";
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;

    public static void deleteAllMarkers(final IProject project) {
        try {
            AspectJPlugin.getWorkspace().run(new IWorkspaceRunnable(){
                private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
                private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

                public void run(IProgressMonitor monitor) {
                    try {
                        project.deleteMarkers("org.eclipse.ajdt.ui.advicemarker", true, 2);
                        project.deleteMarkers("org.eclipse.ajdt.ui.sourceadvicemarker", true, 2);
                        project.deleteMarkers("org.eclipse.ajdt.ui.declarationmarker", true, 2);
                        project.deleteMarkers("org.eclipse.ajdt.ui.customadvicemarker", true, 2);
                        project.deleteMarkers("org.eclipse.ajdt.ui.changedadvicemarker", true, 2);
                    }
                    catch (CoreException coreException) {
                        UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, this, ajc$tjp_0, ajc$tjp_1);
                    }
                }

                static {
                    Factory factory = new Factory("MarkerUpdating.java", Class.forName("org.eclipse.ajdt.internal.ui.markers.MarkerUpdating$1"));
                    ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.markers.MarkerUpdating$1-org.eclipse.core.runtime.CoreException-<missing>-"), 83);
                    ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-run-org.eclipse.ajdt.internal.ui.markers.MarkerUpdating$1-org.eclipse.core.runtime.IProgressMonitor:-monitor:--void-"), 67);
                }
            }, null);
        }
        catch (CoreException coreException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$1$31280822(coreException, ajc$tjp_0, ajc$tjp_1);
        }
    }

    public static void addNewMarkers(IProject project) {
        List[] diff;
        AJLog.logStart((String)"Add markers");
        int numMarkers = 0;
        AJProjectModel ajProjectModel = AJModel.getInstance().getModelForProject(project);
        if (ajProjectModel == null) {
            AJLog.logEnd((int)2, (String)"Add markers", (String)"0 markers (null project model)");
            return;
        }
        List allRelationships = ajProjectModel.getAllRelationships(new AJRelationshipType[]{AJRelationshipManager.ADVISED_BY, AJRelationshipManager.ADVISES, AJRelationshipManager.ANNOTATED_BY, AJRelationshipManager.ANNOTATES, AJRelationshipManager.DECLARED_ON, AJRelationshipManager.ASPECT_DECLARATIONS, AJRelationshipManager.SOFTENS, AJRelationshipManager.SOFTENED_BY});
        List allOtherRels = ajProjectModel.getOtherProjectAllRelationships(new AJRelationshipType[]{AJRelationshipManager.ADVISED_BY, AJRelationshipManager.ADVISES, AJRelationshipManager.ANNOTATED_BY, AJRelationshipManager.ANNOTATES, AJRelationshipManager.DECLARED_ON, AJRelationshipManager.ASPECT_DECLARATIONS, AJRelationshipManager.SOFTENS, AJRelationshipManager.SOFTENED_BY});
        if (allOtherRels != null) {
            allRelationships.addAll(allOtherRels);
        }
        AJProjectModel prev = null;
        AJProjectModel curr = AJModel.getInstance().getModelForProject(project);
        if (MarkerUpdating.isChangedAdviceAnnotationActive()) {
            String ref = ChangesView.getReferencePoint(project);
            if (ref.equals("last full build")) {
                prev = AJModel.getInstance().getPreviousFullBuildModel(project);
            } else if (ref.equals("last build")) {
                prev = AJModel.getInstance().getPreviousModel(project);
            } else {
                prev = new AJProjectModel(project);
                IPath mapFile = project.getFile(ref).getLocation();
                boolean success = prev.loadModel(mapFile);
                if (!success) {
                    prev = null;
                }
            }
        }
        HashSet<IJavaElement> changedEls = new HashSet<IJavaElement>();
        if (prev != null && (diff = new ModelComparison(false).compareProjects(prev, curr)) != null) {
            AJRelationship rel;
            Iterator iterator = diff[0].iterator();
            while (iterator.hasNext()) {
                rel = (AJRelationship)iterator.next();
                changedEls.add(rel.getSource());
                changedEls.add(rel.getTarget());
            }
            iterator = diff[1].iterator();
            while (iterator.hasNext()) {
                rel = (AJRelationship)iterator.next();
                changedEls.add(rel.getSource());
                changedEls.add(rel.getTarget());
            }
        }
        HashMap cUsToListsOfRelationships = new HashMap();
        Iterator iter = allRelationships.iterator();
        while (iter.hasNext()) {
            AJRelationship relationship = (AJRelationship)iter.next();
            IJavaElement source = relationship.getSource();
            ICompilationUnit parentCU = (ICompilationUnit)source.getAncestor(5);
            if (parentCU == null) continue;
            if (cUsToListsOfRelationships.get(parentCU) instanceof List) {
                ((List)cUsToListsOfRelationships.get(parentCU)).add(relationship);
                continue;
            }
            ArrayList<AJRelationship> relationshipsForCU = new ArrayList<AJRelationship>();
            relationshipsForCU.add(relationship);
            cUsToListsOfRelationships.put(parentCU, relationshipsForCU);
        }
        Set affectedCompilationUnits = cUsToListsOfRelationships.keySet();
        Iterator iter2 = affectedCompilationUnits.iterator();
        while (iter2.hasNext()) {
            ICompilationUnit cu = (ICompilationUnit)iter2.next();
            if (cu.getResource() == null || !cu.getResource().exists()) continue;
            List relationships = (List)cUsToListsOfRelationships.get(cu);
            HashMap lineNumberToRelationships = new HashMap();
            Iterator iterator = relationships.iterator();
            while (iterator.hasNext()) {
                AJRelationship relationship = (AJRelationship)iterator.next();
                IJavaElement source = relationship.getSource();
                Integer lineNumber = new Integer(ajProjectModel.getJavaElementLineNumber(source));
                if (lineNumberToRelationships.get(lineNumber) instanceof List) {
                    ((List)lineNumberToRelationships.get(lineNumber)).add(relationship);
                    continue;
                }
                ArrayList<AJRelationship> relationshipsForLine = new ArrayList<AJRelationship>();
                relationshipsForLine.add(relationship);
                lineNumberToRelationships.put(lineNumber, relationshipsForLine);
            }
            Set lineNumbers = lineNumberToRelationships.keySet();
            Iterator iterator2 = lineNumbers.iterator();
            while (iterator2.hasNext()) {
                ++numMarkers;
                Integer lineNum = (Integer)iterator2.next();
                List relationshipsForLine = (List)lineNumberToRelationships.get(lineNum);
                MarkerUpdating.createMarker(lineNum, cu.getResource(), relationshipsForLine, changedEls);
            }
        }
        AJLog.logEnd((int)2, (String)"Add markers", (String)(String.valueOf(numMarkers) + " markers"));
    }

    public static boolean isChangedAdviceAnnotationActive() {
        AnnotationPreferenceLookup lookup = EditorsPlugin.getDefault().getAnnotationPreferenceLookup();
        AnnotationPreference preference = lookup.getAnnotationPreference(CHANGED_ADVICE_ANNOTATION_TYPE);
        IPreferenceStore store = EditorsPlugin.getDefault().getPreferenceStore();
        String key = preference.getVerticalRulerPreferenceKey();
        return key != null && store.getBoolean(key);
    }

    private static void createMarker(int lineNumber, IResource resource, List relationships, Set addedEls) {
        AJRelationship relationship;
        String markerType = null;
        boolean runtimeTest = false;
        boolean newlyadded = false;
        Iterator iter = relationships.iterator();
        while (iter.hasNext()) {
            relationship = (AJRelationship)iter.next();
            runtimeTest = runtimeTest || relationship.hasRuntimeTest();
            boolean bl = newlyadded = newlyadded || addedEls.contains(relationship.getSource());
        }
        iter = relationships.iterator();
        while (iter.hasNext()) {
            relationship = (AJRelationship)iter.next();
            String savedMarkerType = MarkerUpdating.getSavedMarkerType(relationship);
            if (savedMarkerType != null) {
                if (savedMarkerType.equals(AJMarkersDialog.NO_MARKERS)) continue;
                try {
                    IMarker marker = resource.createMarker("org.eclipse.ajdt.ui.customadvicemarker");
                    marker.setAttribute("lineNumber", lineNumber);
                    String label = MarkerUpdating.getMarkerLabel((AJRelationship)relationships.get(0));
                    marker.setAttribute("message", (Object)label);
                    marker.setAttribute("priority", 2);
                    marker.setAttribute("Image_Location", (Object)savedMarkerType);
                }
                catch (CoreException coreException) {
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$1$31280822(coreException, ajc$tjp_2, ajc$tjp_3);
                }
                continue;
            }
            String markerTypeForRelationship = MarkerUpdating.getMarkerTypeForRelationship(relationship, runtimeTest);
            if (markerType == null) {
                markerType = markerTypeForRelationship;
                continue;
            }
            if (markerType.equals(markerTypeForRelationship)) continue;
            markerType = MarkerUpdating.getCombinedMarkerType(markerType, markerTypeForRelationship, runtimeTest);
        }
        if (markerType != null) {
            try {
                IMarker marker = resource.createMarker(markerType);
                marker.setAttribute("lineNumber", lineNumber);
                String label = relationships.size() == 1 ? MarkerUpdating.getMarkerLabel((AJRelationship)relationships.get(0)) : MarkerUpdating.getMultipleMarkersLabel(relationships.size());
                marker.setAttribute("message", (Object)label);
                marker.setAttribute("priority", 2);
                if (newlyadded) {
                    IMarker marker2 = resource.createMarker("org.eclipse.ajdt.ui.changedadvicemarker");
                    marker2.setAttribute("lineNumber", lineNumber);
                    marker2.setAttribute("message", (Object)UIMessages.CrosscuttingChangedMarkerText);
                }
            }
            catch (CoreException coreException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$1$31280822(coreException, ajc$tjp_4, ajc$tjp_3);
            }
        }
    }

    private static String getMultipleMarkersLabel(int number) {
        return String.valueOf(number) + " " + UIMessages.AspectJMarkersAtLine;
    }

    private static String getMarkerLabel(AJRelationship relationship) {
        return String.valueOf(relationship.getRelationship().getDisplayName()) + " " + AJModel.getInstance().getJavaElementLinkName(relationship.getTarget()) + (relationship.hasRuntimeTest() ? " " + UIMessages.AspectJEditor_runtimetest : "");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getMarkerTypeForRelationship(AJRelationship relationship, boolean runtimeTest) {
        AJRelationshipType type;
        block34: {
            block28: {
                JavaModelException javaModelException1122222;
                block36: {
                    JavaModelException javaModelException2222222;
                    block35: {
                        block30: {
                            IProgramElement.ExtraInformation extraInfo;
                            block29: {
                                IJavaElement source;
                                block31: {
                                    block25: {
                                        JavaModelException javaModelException3222222;
                                        block33: {
                                            JavaModelException javaModelException4222222;
                                            block32: {
                                                block27: {
                                                    IProgramElement.ExtraInformation extraInfo2;
                                                    block26: {
                                                        source = relationship.getSource();
                                                        IJavaElement target = relationship.getTarget();
                                                        type = relationship.getRelationship();
                                                        if (!type.equals(AJRelationshipManager.ADVISED_BY)) break block31;
                                                        extraInfo2 = null;
                                                        if (target instanceof AdviceElement) {
                                                            extraInfo2 = ((AdviceElement)target).getAJExtraInformation();
                                                        } else if (target instanceof AJInjarElement) {
                                                            extraInfo2 = ((AJInjarElement)target).getAJExtraInformation();
                                                        }
                                                        if (extraInfo2 == null || extraInfo2.getExtraAdviceInformation() == null) break block25;
                                                        if (!extraInfo2.getExtraAdviceInformation().equals("before")) break block26;
                                                        if (runtimeTest) {
                                                            return "org.eclipse.ajdt.ui.dynamicbeforeadvicemarker";
                                                        }
                                                        return "org.eclipse.ajdt.ui.beforeadvicemarker";
                                                    }
                                                    if (!extraInfo2.getExtraAdviceInformation().equals("around")) break block27;
                                                    if (runtimeTest) {
                                                        return "org.eclipse.ajdt.ui.dynamicaroundadvicemarker";
                                                    }
                                                    return "org.eclipse.ajdt.ui.aroundadvicemarker";
                                                }
                                                if (runtimeTest) {
                                                    return "org.eclipse.ajdt.ui.dynamicafteradvicemarker";
                                                }
                                                return "org.eclipse.ajdt.ui.afteradvicemarker";
                                                catch (JavaModelException javaModelException5) {
                                                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$1$31280822(javaModelException5, ajc$tjp_5, ajc$tjp_6);
                                                    JavaModelException javaModelException6 = javaModelException5;
                                                }
                                                break block32;
                                                catch (JavaModelException javaModelException4222222) {
                                                    // empty catch block
                                                }
                                            }
                                            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$1$31280822(javaModelException4222222, ajc$tjp_7, ajc$tjp_6);
                                            JavaModelException javaModelException7 = javaModelException4222222;
                                            break block33;
                                            catch (JavaModelException javaModelException3222222) {
                                                // empty catch block
                                            }
                                        }
                                        UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$1$31280822(javaModelException3222222, ajc$tjp_8, ajc$tjp_6);
                                    }
                                    if (runtimeTest) {
                                        return "org.eclipse.ajdt.ui.dynamicadvicemarker";
                                    }
                                    return "org.eclipse.ajdt.ui.advicemarker";
                                }
                                if (!type.equals(AJRelationshipManager.ADVISES)) break block34;
                                if (!(source instanceof AdviceElement)) break block28;
                                extraInfo = ((AdviceElement)source).getAJExtraInformation();
                                if (extraInfo.getExtraAdviceInformation() == null) break block28;
                                if (!extraInfo.getExtraAdviceInformation().equals("before")) break block29;
                                if (runtimeTest) {
                                    return "org.eclipse.ajdt.ui.sourcedynamicbeforeadvicemarker";
                                }
                                return "org.eclipse.ajdt.ui.sourcebeforeadvicemarker";
                            }
                            if (!extraInfo.getExtraAdviceInformation().equals("around")) break block30;
                            if (runtimeTest) {
                                return "org.eclipse.ajdt.ui.sourcedynamicaroundadvicemarker";
                            }
                            return "org.eclipse.ajdt.ui.sourcearoundadvicemarker";
                        }
                        try {
                            if (runtimeTest) {
                                return "org.eclipse.ajdt.ui.sourcedynamicafteradvicemarker";
                            }
                            return "org.eclipse.ajdt.ui.sourceafteradvicemarker";
                        }
                        catch (JavaModelException javaModelException8) {
                            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$1$31280822(javaModelException8, ajc$tjp_9, ajc$tjp_6);
                            JavaModelException javaModelException9 = javaModelException8;
                        }
                        break block35;
                        catch (JavaModelException javaModelException2222222) {
                            // empty catch block
                        }
                    }
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$1$31280822(javaModelException2222222, ajc$tjp_10, ajc$tjp_6);
                    JavaModelException javaModelException10 = javaModelException2222222;
                    break block36;
                    catch (JavaModelException javaModelException1122222) {
                        // empty catch block
                    }
                }
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$1$31280822(javaModelException1122222, ajc$tjp_11, ajc$tjp_6);
            }
            if (runtimeTest) {
                return "org.eclipse.ajdt.ui.sourcedynamicadvicemarker";
            }
            return "org.eclipse.ajdt.ui.sourceadvicemarker";
        }
        if (type.equals(AJRelationshipManager.ASPECT_DECLARATIONS) || type.equals(AJRelationshipManager.ANNOTATED_BY) || type.equals(AJRelationshipManager.SOFTENED_BY)) {
            return "org.eclipse.ajdt.ui.itdmarker";
        }
        if (!(type.equals(AJRelationshipManager.DECLARED_ON) || type.equals(AJRelationshipManager.ANNOTATES) || type.equals(AJRelationshipManager.SOFTENS))) {
            return "org.eclipse.ajdt.ui.advicemarker";
        }
        return "org.eclipse.ajdt.ui.sourceitdmarker";
    }

    private static String getSavedMarkerType(AJRelationship relationship) {
        AJRelationshipType relationshipType = relationship.getRelationship();
        IJavaElement source = relationshipType.equals(AJRelationshipManager.ADVISES) || relationshipType.equals(AJRelationshipManager.ANNOTATES) || relationshipType.equals(AJRelationshipManager.DECLARED_ON) || relationshipType.equals(AJRelationshipManager.MATCHED_BY) || relationshipType.equals(AJRelationshipManager.SOFTENS) ? relationship.getSource() : relationship.getTarget();
        IType typeElement = (IType)source.getAncestor(7);
        if (typeElement instanceof AspectElement) {
            return AspectJPreferences.getSavedIcon(typeElement.getJavaProject().getProject(), AJMarkersDialog.getFullyQualifiedAspectName(typeElement));
        }
        return null;
    }

    private static String getCombinedMarkerType(String firstMarkerType, String secondMarkerType, boolean runtimeTest) {
        if (firstMarkerType.indexOf("source") != -1 && secondMarkerType.indexOf("source") != -1) {
            return runtimeTest ? "org.eclipse.ajdt.ui.sourcedynamicadvicemarker" : "org.eclipse.ajdt.ui.sourceadvicemarker";
        }
        if (firstMarkerType.indexOf("source") != -1 || secondMarkerType.indexOf("source") != -1) {
            return runtimeTest ? "org.eclipse.ajdt.ui.dynamicsourceandtargetmarker" : "org.eclipse.ajdt.ui.sourceandtargetmarker";
        }
        return runtimeTest ? "org.eclipse.ajdt.ui.dynamicadvicemarker" : "org.eclipse.ajdt.ui.advicemarker";
    }

    static {
        Factory factory = new Factory("MarkerUpdating.java", Class.forName("org.eclipse.ajdt.internal.ui.markers.MarkerUpdating"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.markers.MarkerUpdating-org.eclipse.core.runtime.CoreException-<missing>-"), 87);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-deleteAllMarkers-org.eclipse.ajdt.internal.ui.markers.MarkerUpdating-org.eclipse.core.resources.IProject:-project:--void-"), 64);
        ajc$tjp_10 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.markers.MarkerUpdating-org.eclipse.jdt.core.JavaModelException-<missing>-"), 429);
        ajc$tjp_11 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.markers.MarkerUpdating-org.eclipse.jdt.core.JavaModelException-<missing>-"), 429);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.markers.MarkerUpdating-org.eclipse.core.runtime.CoreException-<missing>-"), 283);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-createMarker-org.eclipse.ajdt.internal.ui.markers.MarkerUpdating-int:org.eclipse.core.resources.IResource:java.util.List:java.util.Set:-lineNumber:resource:relationships:addedEls:--void-"), 247);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.markers.MarkerUpdating-org.eclipse.core.runtime.CoreException-<missing>-"), 323);
        ajc$tjp_5 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.markers.MarkerUpdating-org.eclipse.jdt.core.JavaModelException-<missing>-"), 394);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-getMarkerTypeForRelationship-org.eclipse.ajdt.internal.ui.markers.MarkerUpdating-org.eclipse.ajdt.core.model.AJRelationship:boolean:-relationship:runtimeTest:--java.lang.String-"), 354);
        ajc$tjp_7 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.markers.MarkerUpdating-org.eclipse.jdt.core.JavaModelException-<missing>-"), 394);
        ajc$tjp_8 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.markers.MarkerUpdating-org.eclipse.jdt.core.JavaModelException-<missing>-"), 394);
        ajc$tjp_9 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.markers.MarkerUpdating-org.eclipse.jdt.core.JavaModelException-<missing>-"), 429);
    }
}

