/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.wizards;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AspectJCorePreferences;
import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.internal.ui.preferences.PreferencePageBuilder;
import org.eclipse.ajdt.internal.ui.text.UIMessages;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaModelStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.internal.ui.viewsupport.JavaUILabelProvider;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.BuildPathSupport;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElementAttribute;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListLabelProvider;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.ClasspathOrderingWorkbookPage;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jdt.ui.JavaElementComparator;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.wizards.BuildPathDialogAccess;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.dialogs.ListSelectionDialog;

public abstract class PathBlock
implements PreferencePageBuilder.AJDTPathBlockPage {
    protected static final int IDX_UP = 0;
    protected static final int IDX_DOWN = 1;
    protected static final int IDX_ADDJAR = 3;
    protected static final int IDX_ADDEXT = 4;
    protected static final int IDX_ADDVAR = 5;
    protected static final int IDX_ADDFOL = 6;
    protected static final int IDX_ADDCON = 7;
    protected static final int IDX_ADDPRJ = 8;
    protected static final int IDX_REMOVE = 9;
    private int fPageIndex;
    private IJavaProject fCurrJProject;
    private String fUserSettingsTimeStamp;
    protected final IWorkspaceRoot fWorkspaceRoot = AspectJPlugin.getWorkspace().getRoot();
    protected ListDialogField fPathList;
    protected IStatusChangeListener fContext;
    protected StatusInfo fPathStatus;
    protected StatusInfo fJavaBuildPathStatus;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;

    protected PathBlock(IStatusChangeListener context, int pageToShow) {
        this.fContext = context;
        this.fPageIndex = pageToShow;
        LibrariesAdapter adapter = new LibrariesAdapter();
        String[] stringArray = new String[10];
        stringArray[0] = UIMessages.PathBlock_order_up_button;
        stringArray[1] = UIMessages.PathBlock_order_down_button;
        stringArray[3] = UIMessages.PathLibrariesWorkbookPage_libraries_addjar_button;
        stringArray[4] = UIMessages.PathLibrariesWorkbookPage_libraries_addextjar_button;
        stringArray[5] = UIMessages.PathLibrariesWorkbookPage_libraries_addvariable_button;
        stringArray[6] = UIMessages.PathLibrariesWorkbookPage_libraries_addclassfolder_button;
        stringArray[7] = UIMessages.PathLibrariesWorkbookPage_libraries_addlibrary_button;
        stringArray[8] = UIMessages.PathLibrariesWorkbookPage_libraries_addproject_button;
        stringArray[9] = UIMessages.PathLibrariesWorkbookPage_libraries_remove_button;
        String[] buttonLabels = stringArray;
        this.fPathList = new ListDialogField((IListAdapter)adapter, buttonLabels, (ILabelProvider)new CPListLabelProvider());
        this.fPathList.setDialogFieldListener((IDialogFieldListener)adapter);
        this.fPathList.setUpButtonIndex(0);
        this.fPathList.setDownButtonIndex(1);
        this.fPathList.setRemoveButtonIndex(9);
        this.fPathList.enableButton(9, false);
        this.fCurrJProject = null;
        this.fJavaBuildPathStatus = new StatusInfo();
        this.fPathStatus = new StatusInfo();
    }

    public void init() {
        this.initializeTimeStamp();
        this.updatePathStatus();
    }

    private void libaryPageSelectionChanged(DialogField field) {
        List selElements = this.fPathList.getSelectedElements();
        this.fPathList.enableButton(9, this.canRemove(selElements));
    }

    private void libaryPageDialogFieldChanged(DialogField field) {
        if (this.fCurrJProject != null) {
            this.updatePathList();
            this.updatePathStatus();
            this.doStatusLineUpdate();
        }
    }

    private void updatePathList() {
        int nEntries;
        List projelements = this.fPathList.getElements();
        List cpelements = this.fPathList.getElements();
        int lastRemovePos = nEntries = cpelements.size();
        int i = nEntries - 1;
        while (i >= 0) {
            CPListElement cpe = (CPListElement)cpelements.get(i);
            if (!projelements.remove(cpe)) {
                cpelements.remove(i);
                lastRemovePos = i;
            }
            --i;
        }
        cpelements.addAll(lastRemovePos, projelements);
        if (lastRemovePos != nEntries || !projelements.isEmpty()) {
            List list = cpelements;
            ListDialogField listDialogField = this.fPathList;
            PreferencePageBuilder.aspectOf().ajc$before$org_eclipse_ajdt_internal_ui_preferences_PreferencePageBuilder$6$5dca5dc3(listDialogField, list, this);
            listDialogField.setElements((Collection)list);
        }
    }

    private void libaryPageCustomButtonPressed(DialogField field, int index) {
        Object[] libentries = null;
        switch (index) {
            case 3: {
                libentries = this.openJarFileDialog(null);
                break;
            }
            case 4: {
                libentries = this.openExtJarFileDialog(null);
                break;
            }
            case 5: {
                libentries = this.openVariableSelectionDialog(null);
                break;
            }
            case 6: {
                libentries = this.openClassFolderDialog(null);
                break;
            }
            case 7: {
                libentries = this.openContainerSelectionDialog(null);
                break;
            }
            case 8: {
                libentries = this.openProjectSelectionDialog(null);
                break;
            }
            case 9: {
                this.removeEntry();
                return;
            }
        }
        if (libentries != null) {
            int nElementsChosen = libentries.length;
            List cplist = this.fPathList.getElements();
            ArrayList<CPListElement> elementsToAdd = new ArrayList<CPListElement>(nElementsChosen);
            int i = 0;
            while (i < nElementsChosen) {
                CPListElement curr = libentries[i];
                if (!cplist.contains(curr) && !elementsToAdd.contains(curr)) {
                    elementsToAdd.add(curr);
                    curr.setAttribute("sourcepath", (Object)BuildPathSupport.guessSourceAttachment((CPListElement)curr));
                    curr.setAttribute("javadoc_location", (Object)JavaUI.getLibraryJavadocLocation((IPath)curr.getPath()));
                }
                ++i;
            }
            if (!elementsToAdd.isEmpty() && index == 6) {
                this.askForAddingExclusionPatternsDialog(elementsToAdd);
            }
            this.fPathList.addElements(elementsToAdd);
            this.fPathList.postSetSelection((ISelection)new StructuredSelection(libentries));
            this.updatePathStatus();
            this.doStatusLineUpdate();
        }
    }

    protected void doStatusLineUpdate() {
        IStatus res = this.findMostSevereStatus();
        this.fContext.statusChanged(res);
    }

    private void updatePathStatus() {
        this.fPathStatus.setOK();
        List elements = this.fPathList.getElements();
        CPListElement entryMissing = null;
        int nEntriesMissing = 0;
        IClasspathEntry[] entries = new IClasspathEntry[elements.size()];
        int i = elements.size() - 1;
        while (i >= 0) {
            CPListElement currElement = (CPListElement)elements.get(i);
            entries[i] = currElement.getClasspathEntry();
            if (currElement.isMissing()) {
                ++nEntriesMissing;
                if (entryMissing == null) {
                    entryMissing = currElement;
                }
            }
            --i;
        }
        if (nEntriesMissing > 0) {
            if (nEntriesMissing == 1) {
                this.fPathStatus.setWarning(UIMessages.InPathBlock_warning_EntryMissing);
            } else {
                this.fPathStatus.setWarning(UIMessages.InPathBlock_warning_EntriesMissing);
            }
        }
        this.updateJavaBuildPathStatus();
    }

    protected void updateJavaBuildPathStatus() {
        IPath outPath;
        List elements = this.fPathList.getElements();
        IClasspathEntry[] entries = new IClasspathEntry[elements.size()];
        int i = elements.size() - 1;
        while (i >= 0) {
            CPListElement currElement = (CPListElement)elements.get(i);
            entries[i] = currElement.getClasspathEntry();
            --i;
        }
        try {
            outPath = this.fCurrJProject.getOutputLocation();
        }
        catch (JavaModelException javaModelException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, this, ajc$tjp_0, ajc$tjp_1);
            outPath = this.fCurrJProject.getPath();
        }
        IJavaModelStatus status = JavaConventions.validateClasspath((IJavaProject)this.fCurrJProject, (IClasspathEntry[])entries, (IPath)outPath);
        if (!status.isOK()) {
            this.fJavaBuildPathStatus.setError(status.getMessage());
            return;
        }
        IJavaModelStatus dupStatus = this.checkForDuplicates(this.fCurrJProject, entries);
        if (!dupStatus.isOK()) {
            this.fJavaBuildPathStatus.setError(dupStatus.getMessage());
            return;
        }
        this.fJavaBuildPathStatus.setOK();
    }

    /*
     * Exception decompiling
     */
    private IJavaModelStatus checkForDuplicates(IJavaProject currJProject, IClasspathEntry[] entries) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void removeEntry() {
        List selElements = this.fPathList.getSelectedElements();
        int i = selElements.size() - 1;
        while (i >= 0) {
            Object elem = selElements.get(i);
            if (elem instanceof CPListElementAttribute) {
                CPListElementAttribute attrib = (CPListElementAttribute)elem;
                attrib.getParent().setAttribute(attrib.getKey(), null);
                selElements.remove(i);
            }
            --i;
        }
        if (selElements.isEmpty()) {
            this.fPathList.refresh();
            this.fPathList.dialogFieldChanged();
        } else {
            this.fPathList.removeElements(selElements);
        }
    }

    private boolean canRemove(List selElements) {
        if (selElements.size() == 0) {
            return false;
        }
        int i = 0;
        while (i < selElements.size()) {
            CPListElement curr;
            Object elem = selElements.get(i);
            if (elem instanceof CPListElementAttribute ? ((CPListElementAttribute)elem).getValue() == null : elem instanceof CPListElement && (curr = (CPListElement)elem).getParentContainer() != null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void askForAddingExclusionPatternsDialog(List newEntries) {
        HashSet modified = new HashSet();
        if (!modified.isEmpty()) {
            String title = UIMessages.InPathLibrariesWorkbookPage_exclusion_added_title;
            String message = UIMessages.InPathLibrariesWorkbookPage_exclusion_added_message;
            MessageDialog.openInformation((Shell)AspectJUIPlugin.getDefault().getActiveWorkbenchWindow().getShell(), (String)title, (String)message);
        }
    }

    private CPListElement[] openClassFolderDialog(CPListElement existing) {
        IPath[] selected;
        if (existing == null && (selected = BuildPathDialogAccess.chooseClassFolderEntries((Shell)this.getShell(), (IPath)this.fCurrJProject.getPath(), (IPath[])this.getUsedContainers(existing))) != null) {
            ArrayList<CPListElement> res = new ArrayList<CPListElement>();
            int i = 0;
            while (i < selected.length) {
                IPath curr = selected[i];
                IResource resource = this.fWorkspaceRoot.findMember(curr);
                if (resource instanceof IContainer) {
                    res.add(this.newCPLibraryElement(resource));
                }
                ++i;
            }
            return res.toArray(new CPListElement[res.size()]);
        }
        return null;
    }

    private CPListElement[] openJarFileDialog(CPListElement existing) {
        if (existing == null) {
            IPath[] selected = BuildPathDialogAccess.chooseJAREntries((Shell)this.getShell(), (IPath)this.fCurrJProject.getPath(), (IPath[])this.getUsedContainers(existing));
            if (selected != null) {
                ArrayList<CPListElement> res = new ArrayList<CPListElement>();
                int i = 0;
                while (i < selected.length) {
                    IPath curr = selected[i];
                    IResource resource = this.fWorkspaceRoot.findMember(curr);
                    String outJar = AspectJCorePreferences.getProjectOutJar((IProject)this.fCurrJProject.getProject());
                    StringBuffer projectOutJar = new StringBuffer();
                    projectOutJar.append(this.fCurrJProject.getPath().toString());
                    projectOutJar.append("/" + outJar);
                    if (resource.getFullPath().toString().equals(projectOutJar.toString())) {
                        MessageDialog.openInformation((Shell)this.getShell(), (String)UIMessages.buildpathwarning_title, (String)UIMessages.addtoinpathwarning);
                    } else if (resource instanceof IFile) {
                        res.add(this.newCPLibraryElement(resource));
                    }
                    ++i;
                }
                return res.toArray(new CPListElement[res.size()]);
            }
        } else {
            IResource resource;
            IPath configured = BuildPathDialogAccess.configureJAREntry((Shell)this.getShell(), (IPath)existing.getPath(), (IPath[])this.getUsedJARFiles(existing));
            if (configured != null && (resource = this.fWorkspaceRoot.findMember(configured)) instanceof IFile) {
                return new CPListElement[]{this.newCPLibraryElement(resource)};
            }
        }
        return null;
    }

    private CPListElement[] openExtJarFileDialog(CPListElement existing) {
        if (existing == null) {
            IPath[] selected = BuildPathDialogAccess.chooseExternalJAREntries((Shell)this.getShell());
            if (selected != null) {
                ArrayList<CPListElement> res = new ArrayList<CPListElement>();
                int i = 0;
                while (i < selected.length) {
                    res.add(new CPListElement(this.fCurrJProject, 1, selected[i], null));
                    ++i;
                }
                return res.toArray(new CPListElement[res.size()]);
            }
        } else {
            IPath configured = BuildPathDialogAccess.configureExternalJAREntry((Shell)this.getShell(), (IPath)existing.getPath());
            if (configured != null) {
                return new CPListElement[]{new CPListElement(this.fCurrJProject, 1, configured, null)};
            }
        }
        return null;
    }

    private CPListElement[] openVariableSelectionDialog(CPListElement existing) {
        List existingElements = this.fPathList.getElements();
        ArrayList<IPath> existingPaths = new ArrayList<IPath>(existingElements.size());
        int i = 0;
        while (i < existingElements.size()) {
            CPListElement elem = (CPListElement)existingElements.get(i);
            if (elem.getEntryKind() == 4) {
                existingPaths.add(elem.getPath());
            }
            ++i;
        }
        IPath[] existingPathsArray = existingPaths.toArray(new IPath[existingPaths.size()]);
        if (existing == null) {
            IPath[] paths = BuildPathDialogAccess.chooseVariableEntries((Shell)this.getShell(), (IPath[])existingPathsArray);
            if (paths != null) {
                ArrayList<CPListElement> result = new ArrayList<CPListElement>();
                int i2 = 0;
                while (i2 < paths.length) {
                    CPListElement elem = new CPListElement(this.fCurrJProject, 4, paths[i2], null);
                    IPath resolvedPath = JavaCore.getResolvedVariablePath((IPath)paths[i2]);
                    elem.setIsMissing(resolvedPath == null || !resolvedPath.toFile().exists());
                    if (!existingElements.contains(elem)) {
                        result.add(elem);
                    }
                    ++i2;
                }
                return result.toArray(new CPListElement[result.size()]);
            }
        } else {
            IPath path = BuildPathDialogAccess.configureVariableEntry((Shell)this.getShell(), (IPath)existing.getPath(), (IPath[])existingPathsArray);
            if (path != null) {
                CPListElement elem = new CPListElement(this.fCurrJProject, 4, path, null);
                return new CPListElement[]{elem};
            }
        }
        return null;
    }

    private CPListElement[] openContainerSelectionDialog(CPListElement existing) {
        if (existing == null) {
            IClasspathEntry[] created = BuildPathDialogAccess.chooseContainerEntries((Shell)this.getShell(), (IJavaProject)this.fCurrJProject, (IClasspathEntry[])this.getRawClasspath());
            if (created != null) {
                CPListElement[] res = new CPListElement[created.length];
                int i = 0;
                while (i < res.length) {
                    res[i] = new CPListElement(this.fCurrJProject, 5, created[i].getPath(), null);
                    ++i;
                }
                return res;
            }
        } else {
            IClasspathEntry created = BuildPathDialogAccess.configureContainerEntry((Shell)this.getShell(), (IClasspathEntry)existing.getClasspathEntry(), (IJavaProject)this.fCurrJProject, (IClasspathEntry[])this.getRawClasspath());
            if (created != null) {
                CPListElement elem = new CPListElement(this.fCurrJProject, 5, created.getPath(), null);
                return new CPListElement[]{elem};
            }
        }
        return null;
    }

    private CPListElement[] openProjectSelectionDialog(CPListElement elem) {
        try {
            ArrayList<IJavaProject> selectable = new ArrayList<IJavaProject>();
            selectable.addAll(Arrays.asList(this.fCurrJProject.getJavaModel().getJavaProjects()));
            selectable.remove(this.fCurrJProject);
            List elements = this.fPathList.getElements();
            int i = 0;
            while (i < elements.size()) {
                CPListElement curr = (CPListElement)elements.get(0);
                if (curr.getEntryKind() == 2) {
                    IJavaProject proj = (IJavaProject)JavaCore.create((IResource)curr.getResource());
                    selectable.remove(proj);
                }
                ++i;
            }
            Object[] selectArr = selectable.toArray();
            new JavaElementComparator().sort(null, selectArr);
            ListSelectionDialog dialog = new ListSelectionDialog(this.getShell(), Arrays.asList(selectArr), (IStructuredContentProvider)new ArrayContentProvider(), (ILabelProvider)new JavaUILabelProvider(), NewWizardMessages.ProjectsWorkbookPage_chooseProjects_message);
            dialog.setTitle(NewWizardMessages.ProjectsWorkbookPage_chooseProjects_title);
            dialog.setHelpAvailable(false);
            if (dialog.open() == 0) {
                Object[] result = dialog.getResult();
                CPListElement[] cpElements = new CPListElement[result.length];
                int i2 = 0;
                while (i2 < result.length) {
                    IJavaProject curr = (IJavaProject)result[i2];
                    cpElements[i2] = new CPListElement(this.fCurrJProject, 2, curr.getPath(), curr.getResource());
                    ++i2;
                }
                return cpElements;
            }
        }
        catch (JavaModelException javaModelException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, this, ajc$tjp_5, ajc$tjp_6);
            return null;
        }
        return null;
    }

    private IClasspathEntry[] getRawClasspath() {
        IClasspathEntry[] currEntries = new IClasspathEntry[this.fPathList.getSize()];
        int i = 0;
        while (i < currEntries.length) {
            CPListElement curr = (CPListElement)this.fPathList.getElement(i);
            currEntries[i] = curr.getClasspathEntry();
            ++i;
        }
        return currEntries;
    }

    private CPListElement newCPLibraryElement(IResource res) {
        return new CPListElement(this.fCurrJProject, 1, res.getFullPath(), res);
    }

    private IPath[] getUsedContainers(CPListElement existing) {
        ArrayList<IPath> res = new ArrayList<IPath>();
        if (this.fCurrJProject.exists()) {
            try {
                IPath outputLocation = this.fCurrJProject.getOutputLocation();
                if (outputLocation != null && outputLocation.segmentCount() > 1) {
                    res.add(outputLocation);
                }
            }
            catch (JavaModelException javaModelException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, this, ajc$tjp_7, ajc$tjp_8);
            }
        }
        List cplist = this.fPathList.getElements();
        int i = 0;
        while (i < cplist.size()) {
            IResource resource;
            CPListElement elem = (CPListElement)cplist.get(i);
            if (elem.getEntryKind() == 1 && elem != existing && (resource = elem.getResource()) instanceof IContainer && !resource.equals((Object)existing)) {
                res.add(resource.getFullPath());
            }
            ++i;
        }
        return res.toArray(new IPath[res.size()]);
    }

    private IPath[] getUsedJARFiles(CPListElement existing) {
        ArrayList<IPath> res = new ArrayList<IPath>();
        List cplist = this.fPathList.getElements();
        int i = 0;
        while (i < cplist.size()) {
            IResource resource;
            CPListElement elem = (CPListElement)cplist.get(i);
            if (elem.getEntryKind() == 1 && elem != existing && (resource = elem.getResource()) instanceof IFile) {
                res.add(resource.getFullPath());
            }
            ++i;
        }
        return res.toArray(new IPath[res.size()]);
    }

    public TabItem tabContent(TabFolder folder) {
        ImageRegistry imageRegistry = JavaPlugin.getDefault().getImageRegistry();
        ClasspathOrderingWorkbookPage ordpage = new ClasspathOrderingWorkbookPage(this.fPathList);
        TabItem item = new TabItem(folder, 0);
        item.setText(this.getBlockTitle());
        item.setImage(imageRegistry.get("org.eclipse.jdt.ui.library_obj.gif"));
        item.setData((Object)ordpage);
        item.setControl(ordpage.getControl((Composite)folder));
        Control control = item.getControl();
        if (control instanceof Composite) {
            Label label = new Label((Composite)control, 16448);
            label.setText(this.getBlockNote());
        }
        return item;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void configureJavaProject(IProgressMonitor monitor) throws CoreException, InterruptedException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.setTaskName(NLS.bind((String)UIMessages.PathBlock_operationdesc_java, (Object)this.getBlockTitle()));
        monitor.beginTask("", 10);
        try {
            this.internalConfigureJavaProject(this.fPathList.getElements(), monitor);
            this.initializeTimeStamp();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        monitor.done();
    }

    protected StringBuffer removeFinalPathSeparatorChar(StringBuffer buffer) {
        if (buffer.length() > 0 && buffer.charAt(buffer.length() - 1) == File.pathSeparatorChar) {
            buffer = buffer.deleteCharAt(buffer.length() - 1);
        }
        return buffer;
    }

    protected void internalConfigureJavaProject(List pathEntries, IProgressMonitor monitor) throws CoreException, InterruptedException {
        int nEntries = pathEntries.size();
        IClasspathEntry[] aspectpath = new IClasspathEntry[nEntries];
        int i = 0;
        while (i < nEntries) {
            CPListElement entry = (CPListElement)pathEntries.get(i);
            aspectpath[i] = entry.getClasspathEntry();
            ++i;
        }
        monitor.worked(2);
        StringBuffer pathBuffer = new StringBuffer();
        StringBuffer contentKindBuffer = new StringBuffer();
        StringBuffer entryKindBuffer = new StringBuffer();
        int i2 = 0;
        while (i2 < aspectpath.length) {
            pathBuffer.append(aspectpath[i2].getPath());
            pathBuffer.append(File.pathSeparator);
            contentKindBuffer.append(aspectpath[i2].getContentKind());
            contentKindBuffer.append(File.pathSeparator);
            entryKindBuffer.append(aspectpath[i2].getEntryKind());
            entryKindBuffer.append(File.pathSeparator);
            ++i2;
        }
        pathBuffer = this.removeFinalPathSeparatorChar(pathBuffer);
        contentKindBuffer = this.removeFinalPathSeparatorChar(contentKindBuffer);
        entryKindBuffer = this.removeFinalPathSeparatorChar(entryKindBuffer);
        this.internalSetProjectPath(pathEntries, pathBuffer, contentKindBuffer, entryKindBuffer);
    }

    protected abstract void internalSetProjectPath(List var1, StringBuffer var2, StringBuffer var3, StringBuffer var4);

    protected abstract String getBlockNote();

    protected abstract String getBlockTitle();

    protected ArrayList getExistingEntries(IClasspathEntry[] pathEntries) {
        ArrayList<CPListElement> newAspectPath = new ArrayList<CPListElement>();
        int i = 0;
        while (i < pathEntries.length) {
            IClasspathEntry curr = pathEntries[i];
            newAspectPath.add(CPListElement.createFromExisting((IClasspathEntry)curr, (IJavaProject)this.fCurrJProject));
            ++i;
        }
        return newAspectPath;
    }

    protected Shell getShell() {
        return AspectJUIPlugin.getDefault().getActiveWorkbenchWindow().getShell();
    }

    protected IJavaProject getJavaProject() {
        return this.fCurrJProject;
    }

    protected void setJavaProject(IJavaProject project) {
        this.fCurrJProject = project;
    }

    protected IStatus findMostSevereStatus() {
        return StatusUtil.getMostSevere((IStatus[])new IStatus[]{this.fPathStatus, this.fJavaBuildPathStatus});
    }

    public int getPageIndex() {
        return this.fPageIndex;
    }

    protected String getEncodedSettings() {
        StringBuffer buf = new StringBuffer();
        int nElements = this.fPathList.getSize();
        buf.append('[').append(nElements).append(']');
        int i = 0;
        while (i < nElements) {
            CPListElement elem = (CPListElement)this.fPathList.getElement(i);
            elem.appendEncodedSettings(buf);
            ++i;
        }
        return buf.toString();
    }

    public boolean hasChangesInDialog() {
        String currSettings = this.getEncodedSettings();
        return !currSettings.equals(this.fUserSettingsTimeStamp);
    }

    public void initializeTimeStamp() {
        this.fUserSettingsTimeStamp = this.getEncodedSettings();
    }

    static {
        Factory factory = new Factory("PathBlock.java", Class.forName("org.eclipse.ajdt.internal.ui.wizards.PathBlock"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.wizards.PathBlock-org.eclipse.jdt.core.JavaModelException-<missing>-"), 318);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-updateJavaBuildPathStatus-org.eclipse.ajdt.internal.ui.wizards.PathBlock----void-"), 306);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.wizards.PathBlock-org.eclipse.jdt.core.JavaModelException-e-"), 430);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-checkForDuplicates-org.eclipse.ajdt.internal.ui.wizards.PathBlock-org.eclipse.jdt.core.IJavaProject:[Lorg.eclipse.jdt.core.IClasspathEntry;:-currJProject:entries:--org.eclipse.jdt.core.IJavaModelStatus-"), 353);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.wizards.PathBlock-org.eclipse.jdt.core.JavaModelException-e-"), 430);
        ajc$tjp_5 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.wizards.PathBlock-org.eclipse.jdt.core.JavaModelException-<missing>-"), 680);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-openProjectSelectionDialog-org.eclipse.ajdt.internal.ui.wizards.PathBlock-org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement:-elem:--[Lorg.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;-"), 650);
        ajc$tjp_7 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.wizards.PathBlock-org.eclipse.jdt.core.JavaModelException-<missing>-"), 712);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-getUsedContainers-org.eclipse.ajdt.internal.ui.wizards.PathBlock-org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement:-existing:--[Lorg.eclipse.core.runtime.IPath;-"), 703);
    }

    protected class LibrariesAdapter
    implements IDialogFieldListener,
    IListAdapter {
        protected LibrariesAdapter() {
        }

        public void customButtonPressed(ListDialogField field, int index) {
            PathBlock.this.libaryPageCustomButtonPressed((DialogField)field, index);
        }

        public void selectionChanged(ListDialogField field) {
            PathBlock.this.libaryPageSelectionChanged((DialogField)field);
        }

        public void doubleClicked(ListDialogField field) {
        }

        public void dialogFieldChanged(DialogField field) {
            PathBlock.this.libaryPageDialogFieldChanged(field);
        }
    }
}

