/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.ajdt.core.AJMementoTokenizer;
import org.eclipse.ajdt.core.CoreUtils;
import org.eclipse.ajdt.core.javaelements.AJCodeElement;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnit;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnitManager;
import org.eclipse.ajdt.core.javaelements.AJInjarElement;
import org.eclipse.ajdt.core.javaelements.AspectElement;
import org.eclipse.ajdt.internal.core.AJWorkingCopyOwner;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.internal.core.util.MementoTokenizer;

public class AspectJCore {
    public static IJavaElement create(IFile file) {
        if ("aj".equals(file.getFileExtension())) {
            return AJCompilationUnitManager.INSTANCE.getAJCompilationUnit(file);
        }
        return JavaModelManager.create((IFile)file, null);
    }

    public static IJavaElement create(String handleIdentifier) {
        return AspectJCore.create(handleIdentifier, AJWorkingCopyOwner.INSTANCE);
    }

    private static int indexOfIgnoringEscapes(String str, char ch) {
        boolean prevEscape = false;
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (c == '\\') {
                prevEscape = true;
            } else {
                if (c == ch && !prevEscape) {
                    return i;
                }
                prevEscape = false;
            }
            ++i;
        }
        return -1;
    }

    private static IJavaElement getCodeElement(String codeElementHandle, JavaElement parent) {
        int li = AspectJCore.indexOfIgnoringEscapes(codeElementHandle, '!');
        if (li != -1) {
            int occurrenceIndex = codeElementHandle.lastIndexOf(33);
            if (Character.isDigit(codeElementHandle.charAt(occurrenceIndex + 1))) {
                int occurrence = Integer.parseInt(codeElementHandle.substring(occurrenceIndex + 1));
                String cname = codeElementHandle.substring(0, li);
                codeElementHandle = codeElementHandle.substring(0, li);
                return new AJCodeElement(parent, cname, occurrence);
            }
            codeElementHandle = codeElementHandle.substring(0, li);
        }
        return new AJCodeElement(parent, codeElementHandle);
    }

    public static IJavaElement create(String handleIdentifier, WorkingCopyOwner owner) {
        if (handleIdentifier == null) {
            return null;
        }
        HashMap<IClassFile, List<AspectElement>> aspectsInJavaFiles = new HashMap<IClassFile, List<AspectElement>>();
        boolean isCodeElement = false;
        String codeElementHandle = "";
        int codeElementDelimPos = AspectJCore.indexOfIgnoringEscapes(handleIdentifier, '?');
        if (codeElementDelimPos != -1) {
            isCodeElement = true;
            codeElementHandle = handleIdentifier.substring(codeElementDelimPos + 1);
            handleIdentifier = handleIdentifier.substring(0, codeElementDelimPos);
        }
        AJMementoTokenizer memento = new AJMementoTokenizer(handleIdentifier);
        while (memento.hasMoreTokens()) {
            List<AspectElement> l;
            Object openable;
            int ind14;
            int ind13;
            int ind12;
            int ind11;
            int ind10;
            int ind9;
            int ind8;
            int ind6;
            int ind5;
            int ind4;
            int ind3;
            int ind2;
            IJavaElement je;
            int index;
            String token = memento.nextToken();
            if (token.charAt(0) != '*' && token.charAt(0) != '{' && token.charAt(0) != '(' || (index = token.charAt(0) == '*' ? handleIdentifier.indexOf(42) : (token.charAt(0) == '{' ? handleIdentifier.indexOf(123) : handleIdentifier.indexOf(40))) == -1 || !((je = JavaCore.create((String)handleIdentifier.substring(0, index))) instanceof PackageFragment)) continue;
            PackageFragment pf = (PackageFragment)je;
            String cuName = handleIdentifier.substring(index + 1);
            int ind1 = cuName.indexOf(91);
            if (ind1 != -1) {
                cuName = cuName.substring(0, ind1);
            }
            if ((ind2 = cuName.indexOf(125)) != -1) {
                cuName = cuName.substring(0, ind2);
            }
            if ((ind3 = cuName.indexOf(41)) != -1) {
                cuName = cuName.substring(0, ind3);
            }
            if ((ind4 = cuName.indexOf(96)) != -1) {
                cuName = cuName.substring(0, ind4);
            }
            if ((ind5 = cuName.indexOf(35)) != -1) {
                cuName = cuName.substring(0, ind5);
            }
            if ((ind6 = cuName.indexOf(37)) != -1) {
                cuName = cuName.substring(0, ind6);
            }
            if (CoreUtils.ASPECTJ_SOURCE_ONLY_FILTER.accept(cuName)) {
                IJavaElement codeEl;
                AJCompilationUnit cu = new AJCompilationUnit(pf, cuName, owner);
                token = memento.nextToken();
                if (!memento.hasMoreTokens()) {
                    return cu;
                }
                IJavaElement restEl = cu.getHandleFromMemento(memento.nextToken(), memento, owner);
                if (restEl == null) continue;
                if (isCodeElement && (codeEl = AspectJCore.getCodeElement(codeElementHandle, (JavaElement)restEl)) != null) {
                    return codeEl;
                }
                return restEl;
            }
            IJavaElement restEl = pf.getHandleFromMemento(token, (MementoTokenizer)memento, (WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY);
            if (restEl != null) {
                IJavaElement codeEl;
                if (isCodeElement && (codeEl = AspectJCore.getCodeElement(codeElementHandle, (JavaElement)restEl)) != null) {
                    return codeEl;
                }
                return restEl;
            }
            if (ind2 == -1) continue;
            int index3 = handleIdentifier.indexOf(125);
            String aspectName = handleIdentifier.substring(index3 + 1);
            boolean identifierIsAspect = true;
            int ind7 = aspectName.indexOf(96);
            if (ind7 != -1) {
                aspectName = aspectName.substring(0, ind7);
                identifierIsAspect = false;
            }
            if ((ind8 = aspectName.indexOf(38)) != -1) {
                aspectName = aspectName.substring(0, ind8);
                identifierIsAspect = false;
            }
            if ((ind9 = aspectName.indexOf(41)) != -1) {
                aspectName = aspectName.substring(0, ind9);
                identifierIsAspect = false;
            }
            if ((ind10 = aspectName.indexOf(125)) != -1) {
                aspectName = aspectName.substring(0, ind10);
                identifierIsAspect = false;
            }
            if ((ind11 = aspectName.indexOf(91)) != -1) {
                aspectName = aspectName.substring(0, ind11);
                identifierIsAspect = false;
            }
            if ((ind12 = aspectName.indexOf(94)) != -1) {
                aspectName = aspectName.substring(0, ind12);
                identifierIsAspect = false;
            }
            if ((ind13 = aspectName.indexOf(126)) != -1) {
                aspectName = aspectName.substring(0, ind13);
                identifierIsAspect = false;
            }
            if ((ind14 = aspectName.indexOf(43)) != -1) {
                aspectName = aspectName.substring(0, ind14);
                identifierIsAspect = false;
            }
            if (aspectsInJavaFiles.get(openable = cuName.endsWith(".class") ? pf.getClassFile(cuName) : pf.getCompilationUnit(cuName)) instanceof List) {
                l = (List)aspectsInJavaFiles.get(openable);
            } else {
                l = new ArrayList();
                aspectsInJavaFiles.put((IClassFile)openable, l);
            }
            AspectElement aspectEl = null;
            for (AspectElement element : l) {
                if (!element.getElementName().equals(aspectName)) continue;
                aspectEl = element;
            }
            if (aspectEl == null) {
                aspectEl = new AspectElement((JavaElement)openable, aspectName);
                l.add(aspectEl);
            }
            int afterAspectIndex = index3 + aspectName.length() + 1;
            if (identifierIsAspect) {
                return aspectEl;
            }
            memento.setIndexTo(afterAspectIndex);
            return aspectEl.getHandleFromMemento(memento.nextToken(), memento, owner);
        }
        if (isCodeElement) {
            return new AJInjarElement(codeElementHandle);
        }
        return JavaCore.create((String)handleIdentifier);
    }

    public static String convertToAspectHandle(String classHandle, IJavaElement elt) {
        String aspectHandle = classHandle.replaceFirst("\\" + Character.toString('['), Character.toString('}'));
        if (CoreUtils.ASPECTJ_SOURCE_ONLY_FILTER.accept(elt.getResource().getName())) {
            aspectHandle = aspectHandle.replace('{', '*');
        }
        return aspectHandle;
    }

    public static String convertToJavaCUHandle(String aspectHandle, IJavaElement elt) {
        String javaHandle = aspectHandle;
        if (CoreUtils.ASPECTJ_SOURCE_ONLY_FILTER.accept(elt.getResource().getName())) {
            javaHandle = javaHandle.replace('*', '{');
        }
        return javaHandle;
    }
}

