/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.core.exports;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.exports.AJModelBuildScriptGenerator;
import org.eclipse.ajdt.internal.core.ras.CoreFFDC;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.internal.build.AssemblyInformation;
import org.eclipse.pde.internal.build.SourceFeatureInformation;
import org.eclipse.pde.internal.build.Utils;
import org.eclipse.pde.internal.build.builder.BuildDirector;
import org.eclipse.pde.internal.build.builder.FeatureBuildScriptGenerator;
import org.eclipse.pde.internal.build.site.BuildTimeFeature;
import org.eclipse.pde.internal.build.site.BuildTimeSiteFactory;
import org.eclipse.pde.internal.build.site.compatibility.FeatureEntry;
import org.eclipse.pde.internal.build.site.compatibility.IPlatformEntry;
import org.osgi.framework.Version;

public class AJBuildDirector
extends BuildDirector {
    private boolean scriptGeneration = true;
    private static Method generateFeatureVersionSuffixMethod;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;

    public AJBuildDirector() {
    }

    public AJBuildDirector(AssemblyInformation assemblageInformation) {
        super(assemblageInformation);
    }

    public AJBuildDirector(String featureId, String versionId, AssemblyInformation informationGathering) throws CoreException {
        super(featureId, versionId, informationGathering);
    }

    protected void generate(BuildTimeFeature feature, boolean generateProductFiles) throws CoreException {
        if (this.analyseIncludedFeatures) {
            this.generateIncludedFeatureBuildFile(feature);
        }
        if (this.analysePlugins) {
            this.generateChildrenScripts(feature);
        }
        this.collectElementToAssemble(feature);
        if (this.scriptGeneration) {
            FeatureBuildScriptGenerator featureScriptGenerator = new FeatureBuildScriptGenerator(feature);
            featureScriptGenerator.setDirector((BuildDirector)this);
            featureScriptGenerator.setBuildSiteFactory(this.siteFactory);
            featureScriptGenerator.setGenerateProductFiles(generateProductFiles);
            featureScriptGenerator.generate();
        }
    }

    BuildTimeSiteFactory getSiteFactory() {
        return this.siteFactory;
    }

    private void generateModels(List models) throws CoreException {
        if (!this.scriptGeneration) {
            return;
        }
        if (!this.binaryFeature || models.isEmpty()) {
            return;
        }
        HashSet<BundleDescription> generatedScripts = new HashSet<BundleDescription>(models.size());
        for (BundleDescription model : models) {
            if (generatedScripts.contains(model)) continue;
            generatedScripts.add(model);
            Set matchingEntries = (Set)((Properties)model.getUserObject()).get("pluginEntry");
            if (matchingEntries.isEmpty()) {
                return;
            }
            Iterator entryIter = matchingEntries.iterator();
            FeatureEntry correspondingEntry = (FeatureEntry)entryIter.next();
            List list = this.selectConfigs((IPlatformEntry)correspondingEntry);
            if (list.size() == 0) continue;
            AJModelBuildScriptGenerator generator = new AJModelBuildScriptGenerator();
            generator.setBuildSiteFactory(this.siteFactory);
            generator.setCompiledElements(this.getCompiledElements());
            generator.setIgnoreMissingPropertiesFile(this.isIgnoreMissingPropertiesFile());
            generator.setModel(model);
            generator.setFeatureGenerator(this);
            generator.setPluginPath(this.getPluginPath());
            generator.setBuildingOSGi(AJBuildDirector.isBuildingOSGi());
            generator.setDevEntries(this.devEntries);
            generator.includePlatformIndependent(this.isPlatformIndependentIncluded());
            generator.setSignJars(this.signJars);
            generator.setAssociatedEntry(correspondingEntry);
            generator.generate();
        }
    }

    private void generateChildrenScripts(BuildTimeFeature feature) throws CoreException {
        List plugins = this.computeElements(feature);
        String suffix = this.generateFeatureVersionSuffix(feature);
        if (suffix != null) {
            Version versionId = new Version(feature.getVersion());
            String qualifier = versionId.getQualifier();
            qualifier = qualifier.substring(0, feature.getContextQualifierLength());
            qualifier = String.valueOf(qualifier) + '-' + suffix;
            versionId = new Version(versionId.getMajor(), versionId.getMinor(), versionId.getMicro(), qualifier);
            String newVersion = versionId.toString();
            feature.setVersion(newVersion);
        }
        this.generateModels(Utils.extractPlugins((List)this.getSite(false).getRegistry().getSortedBundles(), (List)plugins));
    }

    private String generateFeatureVersionSuffix(BuildTimeFeature buildFeature) throws CoreException {
        try {
            if (generateFeatureVersionSuffixMethod == null) {
                generateFeatureVersionSuffixMethod = BuildDirector.class.getDeclaredMethod("generateFeatureVersionSuffix", BuildTimeFeature.class);
                generateFeatureVersionSuffixMethod.setAccessible(true);
            }
            return (String)generateFeatureVersionSuffixMethod.invoke((Object)this, buildFeature);
        }
        catch (Exception exception) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(exception, (Object)this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
            return null;
        }
    }

    public void setScriptGeneration(boolean scriptGeneration) {
        super.setScriptGeneration(scriptGeneration);
        this.scriptGeneration = scriptGeneration;
    }

    SourceFeatureInformation getSourceToGather() {
        return this.sourceToGather;
    }

    static {
        Factory factory = new Factory("AJBuildDirector.java", Class.forName("org.eclipse.ajdt.core.exports.AJBuildDirector"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.exports.AJBuildDirector", "java.lang.Exception:", "<missing>:"), 140);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "generateFeatureVersionSuffix", "org.eclipse.ajdt.core.exports.AJBuildDirector", "org.eclipse.pde.internal.build.site.BuildTimeFeature:", "buildFeature:", "org.eclipse.core.runtime.CoreException:", "java.lang.String"), 132);
    }
}

