/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.launching;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.core.BuildConfig;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnit;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnitManager;
import org.eclipse.ajdt.internal.ui.ras.UIFFDC;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.jdt.internal.debug.ui.launcher.MainMethodSearchEngine;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class AJMainMethodSearchEngine
extends MainMethodSearchEngine {
    private List includedFiles;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_7;

    public IType[] searchMainMethodsIncludingAspects(IProgressMonitor pm, IJavaSearchScope scope, boolean includeSubtypes) throws JavaModelException {
        pm.beginTask(LauncherMessages.MainMethodSearchEngine_1, 100);
        SubProgressMonitor javaSearchMonitor = new SubProgressMonitor(pm, 100);
        IType[] mainTypes = super.searchMainMethods((IProgressMonitor)javaSearchMonitor, scope, includeSubtypes);
        IProject[] projects = AspectJPlugin.getWorkspace().getRoot().getProjects();
        ArrayList mainList = new ArrayList(Arrays.asList(mainTypes));
        SubProgressMonitor ajSearchMonitor = new SubProgressMonitor(pm, 100);
        ajSearchMonitor.beginTask(LauncherMessages.MainMethodSearchEngine_1, 100);
        double ticksPerProject = Math.floor(100.0f / (float)projects.length);
        if (ticksPerProject < 1.0) {
            ticksPerProject = 1.0;
        }
        int i = 0;
        while (i < projects.length) {
            try {
                if (projects[i].hasNature("org.eclipse.ajdt.ui.ajnature")) {
                    this.includedFiles = BuildConfig.getIncludedSourceFiles((IProject)projects[i]);
                    IJavaProject jp = JavaCore.create((IProject)projects[i]);
                    if (jp != null) {
                        if (scope.encloses((IJavaElement)jp)) {
                            Set aspects = this.getAllAspects(jp);
                            mainList.addAll(aspects);
                        } else {
                            IPath[] enclosingPaths = scope.enclosingProjectsAndJars();
                            int j = 0;
                            while (j < enclosingPaths.length) {
                                IPath path = enclosingPaths[j];
                                if (path.equals((Object)jp.getPath())) {
                                    IJavaElement[] children = jp.getChildren();
                                    mainList.addAll(this.searchJavaElements(scope, children));
                                }
                                ++j;
                            }
                        }
                    }
                }
            }
            catch (Exception exception) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(exception, (Object)this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
            }
            ajSearchMonitor.internalWorked(ticksPerProject);
            ++i;
        }
        ajSearchMonitor.done();
        pm.done();
        Object[] objects = mainList.toArray();
        IType[] types = new IType[objects.length];
        System.arraycopy(objects, 0, types, 0, types.length);
        return types;
    }

    public IType[] searchMainMethodsIncludingAspects(IRunnableContext context, final IJavaSearchScope scope, final boolean includeSubtypes) throws InvocationTargetException, InterruptedException {
        final IType[][] res = new IType[1][];
        IRunnableWithProgress runnable = new IRunnableWithProgress(){
            private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
            private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;

            public void run(IProgressMonitor pm) throws InvocationTargetException {
                try {
                    res[0] = AJMainMethodSearchEngine.this.searchMainMethodsIncludingAspects(pm, scope, includeSubtypes);
                }
                catch (JavaModelException javaModelException) {
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
                    JavaModelException e = javaModelException;
                    throw new InvocationTargetException(e);
                }
            }

            static {
                Factory factory = new Factory("AJMainMethodSearchEngine.java", Class.forName("org.eclipse.ajdt.internal.launching.AJMainMethodSearchEngine$1"));
                ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.launching.AJMainMethodSearchEngine$1", "org.eclipse.jdt.core.JavaModelException:", "e:"), 125);
                ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "run", "org.eclipse.ajdt.internal.launching.AJMainMethodSearchEngine$1", "org.eclipse.core.runtime.IProgressMonitor:", "pm:", "java.lang.reflect.InvocationTargetException:", "void"), 120);
            }
        };
        context.run(true, true, runnable);
        return res[0];
    }

    private List searchJavaElements(IJavaSearchScope scope, IJavaElement[] children) throws JavaModelException {
        ArrayList aspectsFound = new ArrayList();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof IPackageFragment) {
                aspectsFound.addAll(this.searchPackage(scope, (IPackageFragment)children[i]));
            } else if (children[i] instanceof IPackageFragmentRoot) {
                IJavaElement[] grandchildren = ((IPackageFragmentRoot)children[i]).getChildren();
                aspectsFound.addAll(this.searchJavaElements(scope, grandchildren));
            }
            ++i;
        }
        return aspectsFound;
    }

    private List searchPackage(IJavaSearchScope scope, IPackageFragment packageFragment) throws JavaModelException {
        ArrayList aspectsFound = new ArrayList();
        if (scope.encloses((IJavaElement)packageFragment)) {
            Set aspects = this.getAllAspects(packageFragment);
            aspectsFound.addAll(aspects);
        } else {
            aspectsFound.addAll(this.searchUnitsInPackage(scope, packageFragment));
        }
        return aspectsFound;
    }

    private List searchUnitsInPackage(IJavaSearchScope scope, IPackageFragment packageFragment) throws JavaModelException {
        ArrayList<IType> units = new ArrayList<IType>();
        Set allAspects = this.getAllAspects(packageFragment);
        for (IType type : allAspects) {
            if (!scope.encloses((IJavaElement)type)) continue;
            units.add(type);
        }
        return units;
    }

    private Set getAllAspects(IJavaProject jp) {
        try {
            return new HashSet(this.getActiveMainTypesFromAJCompilationUnits(AJCompilationUnitManager.INSTANCE.getAJCompilationUnits(jp)));
        }
        catch (CoreException coreException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_3);
            return new HashSet();
        }
    }

    private Set getAllAspects(IPackageFragment packageElement) {
        List aspects = new ArrayList();
        try {
            aspects = AJCompilationUnitManager.INSTANCE.getAJCompilationUnitsForPackage(packageElement);
        }
        catch (Exception exception) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(exception, (Object)this, ajc$tjp_4, (JoinPoint.StaticPart)ajc$tjp_5);
        }
        return new HashSet(this.getActiveMainTypesFromAJCompilationUnits(aspects));
    }

    private List getActiveMainTypesFromAJCompilationUnits(List aspects) {
        ArrayList<IType> mainTypes = new ArrayList<IType>();
        try {
            for (AJCompilationUnit element : aspects) {
                if (!this.includedFiles.contains(element.getResource())) continue;
                IType[] types = element.getAllTypes();
                int i = 0;
                while (i < types.length) {
                    IType type = types[i];
                    IMethod[] methods = type.getMethods();
                    int j = 0;
                    while (j < methods.length) {
                        if (methods[j].isMainMethod()) {
                            mainTypes.add(type);
                            break;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        catch (Exception exception) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(exception, (Object)this, ajc$tjp_6, (JoinPoint.StaticPart)ajc$tjp_7);
        }
        return mainTypes;
    }

    static {
        Factory factory = new Factory("AJMainMethodSearchEngine.java", Class.forName("org.eclipse.ajdt.internal.launching.AJMainMethodSearchEngine"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.launching.AJMainMethodSearchEngine", "java.lang.Exception:", "<missing>:"), 95);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "searchMainMethodsIncludingAspects", "org.eclipse.ajdt.internal.launching.AJMainMethodSearchEngine", "org.eclipse.core.runtime.IProgressMonitor:org.eclipse.jdt.core.search.IJavaSearchScope:boolean:", "pm:scope:includeSubtypes:", "org.eclipse.jdt.core.JavaModelException:", "[Lorg.eclipse.jdt.core.IType;"), 56);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.launching.AJMainMethodSearchEngine", "org.eclipse.core.runtime.CoreException:", "<missing>:"), 217);
        ajc$tjp_3 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "getAllAspects", "org.eclipse.ajdt.internal.launching.AJMainMethodSearchEngine", "org.eclipse.jdt.core.IJavaProject:", "jp:", "", "java.util.Set"), 214);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.launching.AJMainMethodSearchEngine", "java.lang.Exception:", "<missing>:"), 233);
        ajc$tjp_5 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "getAllAspects", "org.eclipse.ajdt.internal.launching.AJMainMethodSearchEngine", "org.eclipse.jdt.core.IPackageFragment:", "packageElement:", "", "java.util.Set"), 229);
        ajc$tjp_6 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.launching.AJMainMethodSearchEngine", "java.lang.Exception:", "<missing>:"), 265);
        ajc$tjp_7 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "getActiveMainTypesFromAJCompilationUnits", "org.eclipse.ajdt.internal.launching.AJMainMethodSearchEngine", "java.util.List:", "aspects:", "", "java.util.List"), 246);
    }
}

