/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.internal.ui.editor.BracketWordRule;
import org.eclipse.ajdt.internal.ui.editor.DotWordRule;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.internal.ui.text.AbstractJavaScanner;
import org.eclipse.jdt.internal.ui.text.CombinedWordRule;
import org.eclipse.jdt.internal.ui.text.ISourceVersionDependent;
import org.eclipse.jdt.internal.ui.text.JavaWhitespaceDetector;
import org.eclipse.jdt.internal.ui.text.JavaWordDetector;
import org.eclipse.jdt.ui.text.IColorManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.util.PropertyChangeEvent;

public final class AspectJCodeScanner
extends AbstractJavaScanner {
    private static final String SOURCE_VERSION = "org.eclipse.jdt.core.compiler.source";
    static String[] fgKeywords = new String[]{"abstract", "break", "case", "catch", "class", "const", "continue", "default", "do", "else", "extends", "final", "finally", "for", "goto", "if", "implements", "import", "instanceof", "interface", "native", "new", "package", "private", "protected", "public", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "volatile", "while"};
    private static final String RETURN = "return";
    private static String[] fgJava14Keywords = new String[]{"assert"};
    private static String[] fgJava15Keywords = new String[]{"enum"};
    private static String[] fgTypes = new String[]{"void", "boolean", "char", "byte", "short", "strictfp", "int", "long", "float", "double"};
    private static String[] fgConstants = new String[]{"false", "null", "true"};
    private static String[] fgTokenProperties = new String[]{"java_keyword", "java_string", "java_default", "java_keyword_return", "java_operator", "java_annotation"};
    private List fVersionDependentRules = new ArrayList(3);

    public AspectJCodeScanner(IColorManager manager, IPreferenceStore store) {
        super(manager, store);
        this.initialize();
    }

    protected String[] getTokenProperties() {
        return fgTokenProperties;
    }

    protected List createRules() {
        ArrayList<Object> rules = new ArrayList<Object>();
        Token token = this.getToken("java_string");
        rules.add(new SingleLineRule("'", "'", (IToken)token, '\\'));
        rules.add(new WhitespaceRule((IWhitespaceDetector)new JavaWhitespaceDetector()));
        String version = this.getPreferenceStore().getString(SOURCE_VERSION);
        AnnotationRule atInterfaceRule = new AnnotationRule((IToken)this.getToken("java_keyword"), this.getToken("java_annotation"), "1.5", version);
        rules.add(atInterfaceRule);
        this.fVersionDependentRules.add(atInterfaceRule);
        JavaWordDetector wordDetector = new JavaWordDetector();
        token = this.getToken("java_default");
        CombinedWordRule combinedWordRule = new CombinedWordRule((IWordDetector)wordDetector, (IToken)token);
        token = this.getToken("java_default");
        VersionedWordMatcher j14Matcher = new VersionedWordMatcher((IToken)token, "1.4", version);
        token = this.getToken("java_keyword");
        int i = 0;
        while (i < fgJava14Keywords.length) {
            j14Matcher.addWord(fgJava14Keywords[i], (IToken)token);
            ++i;
        }
        combinedWordRule.addWordMatcher((CombinedWordRule.WordMatcher)j14Matcher);
        this.fVersionDependentRules.add(j14Matcher);
        token = this.getToken("java_default");
        VersionedWordMatcher j15Matcher = new VersionedWordMatcher((IToken)token, "1.5", version);
        token = this.getToken("java_keyword");
        int i2 = 0;
        while (i2 < fgJava15Keywords.length) {
            j15Matcher.addWord(fgJava15Keywords[i2], (IToken)token);
            ++i2;
        }
        combinedWordRule.addWordMatcher((CombinedWordRule.WordMatcher)j15Matcher);
        this.fVersionDependentRules.add(j15Matcher);
        token = this.getToken("java_operator");
        rules.add(new OperatorRule((IToken)token));
        CombinedWordRule.WordMatcher returnWordRule = new CombinedWordRule.WordMatcher();
        token = this.getToken("java_keyword_return");
        returnWordRule.addWord(RETURN, (IToken)token);
        combinedWordRule.addWordMatcher(returnWordRule);
        CombinedWordRule.WordMatcher wordRule = new CombinedWordRule.WordMatcher();
        token = this.getToken("java_keyword");
        int i3 = 0;
        while (i3 < fgKeywords.length) {
            wordRule.addWord(fgKeywords[i3], (IToken)token);
            ++i3;
        }
        i3 = 0;
        while (i3 < fgTypes.length) {
            wordRule.addWord(fgTypes[i3], (IToken)token);
            ++i3;
        }
        i3 = 0;
        while (i3 < fgConstants.length) {
            wordRule.addWord(fgConstants[i3], (IToken)token);
            ++i3;
        }
        DotWordRule ajDotWordRule = new DotWordRule((IWordDetector)new JavaWordDetector());
        BracketWordRule ajBracketRule = new BracketWordRule((IWordDetector)new JavaWordDetector());
        int i4 = 0;
        while (i4 < AspectJPlugin.ajKeywords.length) {
            if (i4 > 3 && i4 < 23 || i4 == 24 || i4 > 33 && i4 < 40) {
                ajBracketRule.addWord(AspectJPlugin.ajKeywords[i4], (IToken)token);
            } else {
                ajDotWordRule.addWord(AspectJPlugin.ajKeywords[i4], (IToken)token);
            }
            ++i4;
        }
        rules.add((Object)ajBracketRule);
        rules.add((Object)ajDotWordRule);
        combinedWordRule.addWordMatcher(wordRule);
        rules.add(combinedWordRule);
        this.setDefaultReturnToken((IToken)this.getToken("java_default"));
        return rules;
    }

    public boolean affectsBehavior(PropertyChangeEvent event) {
        return event.getProperty().equals(SOURCE_VERSION) || super.affectsBehavior(event);
    }

    public void adaptToPreferenceChange(PropertyChangeEvent event) {
        if (event.getProperty().equals(SOURCE_VERSION)) {
            Object value = event.getNewValue();
            if (value instanceof String) {
                String s = (String)value;
                for (ISourceVersionDependent dependent : this.fVersionDependentRules) {
                    dependent.setSourceVersion(s);
                }
            }
        } else if (super.affectsBehavior(event)) {
            super.adaptToPreferenceChange(event);
        }
    }

    private static class AnnotationRule
    implements IRule,
    ISourceVersionDependent {
        private final IWhitespaceDetector fWhitespaceDetector = new JavaWhitespaceDetector();
        private final IWordDetector fWordDetector = new JavaWordDetector();
        private final IToken fInterfaceToken;
        private final IToken fAnnotationToken;
        private final String fVersion;
        private boolean fIsVersionMatch;

        public AnnotationRule(IToken interfaceToken, Token annotationToken, String version, String currentVersion) {
            this.fInterfaceToken = interfaceToken;
            this.fAnnotationToken = annotationToken;
            this.fVersion = version;
            this.setSourceVersion(currentVersion);
        }

        public IToken evaluate(ICharacterScanner scanner) {
            if (!this.fIsVersionMatch) {
                return Token.UNDEFINED;
            }
            ResettableScanner resettable = new ResettableScanner(scanner);
            if (resettable.read() == 64 && this.skipWhitespace(resettable)) {
                return this.readAnnotation(resettable);
            }
            resettable.reset();
            return Token.UNDEFINED;
        }

        private IToken readAnnotation(ResettableScanner scanner) {
            StringBuffer buffer = new StringBuffer();
            if (!this.readIdentifier(scanner, buffer)) {
                scanner.reset();
                return Token.UNDEFINED;
            }
            if ("interface".equals(buffer.toString())) {
                return this.fInterfaceToken;
            }
            while (this.readSegment(new ResettableScanner(scanner))) {
            }
            return this.fAnnotationToken;
        }

        private boolean readSegment(ResettableScanner scanner) {
            scanner.mark();
            if (this.skipWhitespace(scanner) && this.skipDot(scanner) && this.skipWhitespace(scanner) && this.readIdentifier(scanner, null)) {
                return true;
            }
            scanner.reset();
            return false;
        }

        private boolean skipDot(ICharacterScanner scanner) {
            int ch = scanner.read();
            if (ch == 46) {
                return true;
            }
            scanner.unread();
            return false;
        }

        private boolean readIdentifier(ICharacterScanner scanner, StringBuffer buffer) {
            int ch = scanner.read();
            boolean read = false;
            while (this.fWordDetector.isWordPart((char)ch)) {
                if (buffer != null) {
                    buffer.append((char)ch);
                }
                ch = scanner.read();
                read = true;
            }
            if (ch != -1) {
                scanner.unread();
            }
            return read;
        }

        private boolean skipWhitespace(ICharacterScanner scanner) {
            while (this.fWhitespaceDetector.isWhitespace((char)scanner.read())) {
            }
            scanner.unread();
            return true;
        }

        public void setSourceVersion(String version) {
            this.fIsVersionMatch = this.fVersion.compareTo(version) <= 0;
        }

        private static final class ResettableScanner
        implements ICharacterScanner {
            private final ICharacterScanner fDelegate;
            private int fReadCount;

            public ResettableScanner(ICharacterScanner scanner) {
                Assert.isNotNull((Object)scanner);
                this.fDelegate = scanner;
                this.mark();
            }

            public int getColumn() {
                return this.fDelegate.getColumn();
            }

            public char[][] getLegalLineDelimiters() {
                return this.fDelegate.getLegalLineDelimiters();
            }

            public int read() {
                int ch = this.fDelegate.read();
                if (ch != -1) {
                    ++this.fReadCount;
                }
                return ch;
            }

            public void unread() {
                if (this.fReadCount > 0) {
                    --this.fReadCount;
                }
                this.fDelegate.unread();
            }

            public void mark() {
                this.fReadCount = 0;
            }

            public void reset() {
                while (this.fReadCount > 0) {
                    this.unread();
                }
                while (this.fReadCount < 0) {
                    this.read();
                }
            }
        }
    }

    protected class OperatorRule
    implements IRule {
        private final char[] JAVA_OPERATORS = new char[]{';', '(', ')', '{', '}', '.', '=', '/', '\\', '+', '-', '*', '[', ']', '<', '>', ':', '?', '!', ',', '|', '&', '^', '%', '~'};
        private final IToken fToken;

        public OperatorRule(IToken token) {
            this.fToken = token;
        }

        public boolean isOperator(char character) {
            int index = 0;
            while (index < this.JAVA_OPERATORS.length) {
                if (this.JAVA_OPERATORS[index] == character) {
                    return true;
                }
                ++index;
            }
            return false;
        }

        public IToken evaluate(ICharacterScanner scanner) {
            int character = scanner.read();
            if (this.isOperator((char)character)) {
                while (this.isOperator((char)(character = scanner.read()))) {
                }
                scanner.unread();
                return this.fToken;
            }
            scanner.unread();
            return Token.UNDEFINED;
        }
    }

    private static class VersionedWordMatcher
    extends CombinedWordRule.WordMatcher
    implements ISourceVersionDependent {
        private final IToken fDefaultToken;
        private final String fVersion;
        private boolean fIsVersionMatch;

        public VersionedWordMatcher(IToken defaultToken, String version, String currentVersion) {
            this.fDefaultToken = defaultToken;
            this.fVersion = version;
            this.setSourceVersion(currentVersion);
        }

        public void setSourceVersion(String version) {
            this.fIsVersionMatch = this.fVersion.compareTo(version) <= 0;
        }

        public IToken evaluate(ICharacterScanner scanner, CombinedWordRule.CharacterBuffer word) {
            IToken token = super.evaluate(scanner, word);
            if (this.fIsVersionMatch || token.isUndefined()) {
                return token;
            }
            return this.fDefaultToken;
        }
    }
}

