/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.mylyn.ui;

import org.eclipse.ajdt.core.AspectJCore;
import org.eclipse.ajdt.core.javaelements.IAJCodeElement;
import org.eclipse.ajdt.core.javaelements.IAspectJElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.java.ui.JavaStructureBridge;
import org.eclipse.ui.views.markers.internal.ConcreteMarker;

public class AspectJStructureBridge
extends JavaStructureBridge {
    public static final String CONTENT_TYPE = "aspectj";

    public String getContentType() {
        return CONTENT_TYPE;
    }

    public String getHandleForOffsetInObject(Object object, int offset) {
        ICompilationUnit compilationUnit;
        IMarker marker;
        int charStart;
        block14: {
            charStart = 0;
            if (object instanceof ConcreteMarker) {
                marker = ((ConcreteMarker)object).getMarker();
            } else if (object instanceof IMarker) {
                marker = (IMarker)object;
            } else {
                return null;
            }
            Integer attribute = marker.getAttribute("charStart", 0);
            if (attribute instanceof Integer) {
                charStart = attribute;
            }
            compilationUnit = null;
            IResource resource = marker.getResource();
            if (!(resource instanceof IFile)) break block14;
            IFile file = (IFile)resource;
            if (file.getFileExtension().equals("aj")) {
                compilationUnit = JavaCore.createCompilationUnitFrom((IFile)file);
                break block14;
            }
            return null;
        }
        try {
            if (compilationUnit != null) {
                IJavaElement javaElement = compilationUnit.getElementAt(charStart);
                if (javaElement != null) {
                    if (javaElement instanceof IImportDeclaration) {
                        javaElement = javaElement.getParent().getParent();
                    }
                    return javaElement.getHandleIdentifier();
                }
                return null;
            }
            return null;
        }
        catch (JavaModelException ex) {
            if (!ex.isDoesNotExist()) {
                ExceptionHandler.handle((CoreException)ex, (String)"error", (String)"could not find java element");
            }
            return null;
        }
        catch (Throwable t) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.ajdt.mylyn.ui", "Could not find element for: " + marker, t));
            return null;
        }
    }

    public Object getObjectForHandle(String handle) {
        try {
            return AspectJCore.create((String)handle);
        }
        catch (Throwable t) {
            StatusHandler.log((IStatus)new Status(2, "org.eclipse.ajdt.mylyn.ui", "Could not create java element for handle: " + handle, t));
            return null;
        }
    }

    public boolean acceptsObject(Object object) {
        return object instanceof IAJCodeElement || object instanceof IAspectJElement;
    }
}

