/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.weaving.aspectj;

import java.util.Dictionary;
import java.util.Properties;
import org.eclipse.equinox.service.weaving.IWeavingServiceFactory;
import org.eclipse.equinox.weaving.aspectj.WeavingServiceFactory;
import org.eclipse.equinox.weaving.aspectj.loadtime.AspectDefinitionRegistry;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceReference;

public class WeavingServicePlugin
implements BundleActivator {
    public static boolean DEBUG;
    public static boolean verbose;
    private static WeavingServicePlugin plugin;
    private AspectDefinitionRegistry aspectDefinitionRegistry;
    private BundleContext context;

    static {
        verbose = Boolean.getBoolean("org.aspectj.osgi.verbose");
    }

    public WeavingServicePlugin() {
        plugin = this;
    }

    public static WeavingServicePlugin getDefault() {
        return plugin;
    }

    public AspectDefinitionRegistry getAspectDefinitionRegistry() {
        return this.aspectDefinitionRegistry;
    }

    public BundleContext getContext() {
        return this.context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        this.context = bundleContext;
        this.aspectDefinitionRegistry = new AspectDefinitionRegistry();
        bundleContext.addBundleListener((BundleListener)this.aspectDefinitionRegistry);
        this.aspectDefinitionRegistry.initialize(bundleContext.getBundles());
        this.loadOptions(bundleContext);
        if (verbose) {
            System.err.println("[org.eclipse.equinox.weaving.aspectj] info Starting AspectJ weaving service ...");
        }
        String string = IWeavingServiceFactory.class.getName();
        WeavingServiceFactory weavingServiceFactory = new WeavingServiceFactory();
        Properties properties = new Properties();
        bundleContext.registerService(string, (Object)weavingServiceFactory, (Dictionary)properties);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.context = null;
        plugin = null;
    }

    private void loadOptions(BundleContext bundleContext) {
        DebugOptions debugOptions = null;
        ServiceReference serviceReference = bundleContext.getServiceReference(DebugOptions.class.getName());
        if (serviceReference != null) {
            debugOptions = (DebugOptions)bundleContext.getService(serviceReference);
        }
        if (debugOptions == null) {
            return;
        }
        try {
            DEBUG = debugOptions.getBooleanOption("org.aspectj.osgi.service.weaving/debug", false);
        }
        finally {
            bundleContext.ungetService(serviceReference);
        }
    }
}

