/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.weaving.aspectj.loadtime;

import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aspectj.weaver.loadtime.definition.Definition;
import org.aspectj.weaver.loadtime.definition.DocumentParser;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.SynchronousBundleListener;

public class AspectDefinitionRegistry
implements SynchronousBundleListener {
    private static final String AOP_CONTEXT_LOCATION_HEADER = "Eclipse-AspectContext";
    private static final String DEFAULT_AOP_CONTEXT_LOCATION = "META-INF/aop.xml";
    private final Map<Bundle, Definition> aspectDefinitions = new ConcurrentHashMap<Bundle, Definition>();

    public void bundleChanged(BundleEvent bundleEvent) {
        if (bundleEvent.getType() == 32) {
            this.bundleResolved(bundleEvent.getBundle());
        } else if (bundleEvent.getType() == 64) {
            this.bundleUnresolved(bundleEvent.getBundle());
        }
    }

    public void bundleResolved(Bundle bundle) {
        Definition definition;
        if (!this.aspectDefinitions.containsKey(bundle) && (definition = this.parseDefinitionFromRequiredBundle(bundle)) != null) {
            this.aspectDefinitions.put(bundle, definition);
        }
    }

    public void bundleUnresolved(Bundle bundle) {
        this.aspectDefinitions.remove(bundle);
    }

    public Definition getAspectDefinition(Bundle bundle) {
        return this.aspectDefinitions.get(bundle);
    }

    public String getDefinitionLocation(Bundle bundle) {
        String string = (String)bundle.getHeaders().get(AOP_CONTEXT_LOCATION_HEADER);
        if (string != null) {
            string = string.trim();
            return string;
        }
        return DEFAULT_AOP_CONTEXT_LOCATION;
    }

    public void initialize(Bundle[] bundleArray) {
        Bundle[] bundleArray2 = bundleArray;
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Definition definition;
            Bundle bundle = bundleArray2[n2];
            int n3 = bundle.getState();
            if (n3 != 2 && n3 != 1 && (definition = this.parseDefinitionFromRequiredBundle(bundle)) != null) {
                this.aspectDefinitions.put(bundle, definition);
            }
            ++n2;
        }
    }

    public Definition parseDefinitionFromRequiredBundle(Bundle bundle) {
        try {
            URL uRL = bundle.getEntry(this.getDefinitionLocation(bundle));
            if (uRL != null) {
                return DocumentParser.parse((URL)uRL);
            }
        }
        catch (Exception exception) {}
        return null;
    }
}

