/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.builder;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AJLog;
import org.eclipse.ajdt.core.AspectJCorePreferences;
import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.core.CoreUtils;
import org.eclipse.ajdt.core.builder.IAJBuildListener;
import org.eclipse.ajdt.core.builder.IAJCompilerMonitor;
import org.eclipse.ajdt.core.lazystart.IAdviceChangedListener;
import org.eclipse.ajdt.core.model.AJModelChecker;
import org.eclipse.ajdt.core.model.AJProjectModelFacade;
import org.eclipse.ajdt.core.model.AJProjectModelFactory;
import org.eclipse.ajdt.internal.core.ajde.CoreCompilerConfiguration;
import org.eclipse.ajdt.internal.ui.ajde.UIMessageHandler;
import org.eclipse.ajdt.internal.ui.markers.DeleteAndUpdateAJMarkersJob;
import org.eclipse.ajdt.internal.ui.ras.UIFFDC;
import org.eclipse.ajdt.internal.ui.text.UIMessages;
import org.eclipse.ajdt.internal.ui.visualiser.AJDTContentProvider;
import org.eclipse.ajdt.internal.utils.AJDTUtils;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.contribution.visualiser.VisualiserPlugin;
import org.eclipse.contribution.visualiser.core.ProviderManager;
import org.eclipse.contribution.xref.ui.XReferenceUIPlugin;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public class UIBuildListener
implements IAJBuildListener {
    private HashMap outjars = null;
    private ListenerList fListeners = new ListenerList();
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;

    public void preAJBuild(int kind, IProject project, IProject[] requiredProjects) {
        boolean haveClearedMarkers = false;
        int i = 0;
        while (i < requiredProjects.length) {
            String referencedMessage = NLS.bind((String)UIMessages.buildPrereqsMessage, (Object)requiredProjects[i].getName());
            if (this.projectAlreadyMarked(project, referencedMessage)) {
                if (kind == 6) {
                    AJDTUtils.clearProjectMarkers(project, true);
                    UIMessageHandler.clearOtherProjectMarkers(project);
                } else {
                    AJDTUtils.clearProjectMarkers(project, false);
                }
                this.markProject(project, referencedMessage);
                haveClearedMarkers = true;
            }
            ++i;
        }
        if (!haveClearedMarkers) {
            if (kind == 6) {
                AJDTUtils.clearProjectMarkers(project, true);
            } else {
                AJDTUtils.clearProjectMarkers(project, false);
            }
            UIMessageHandler.clearOtherProjectMarkers(project);
        }
    }

    private void checkInpathOutFolder(IProject project) {
        String outFolder = AspectJCorePreferences.getProjectInpathOutFolder((IProject)project);
        if (outFolder == null || outFolder.equals("")) {
            return;
        }
        if (!this.pathExists(outFolder)) {
            try {
                IMarker errorMarker = project.createMarker("org.eclipse.jdt.core.problem");
                errorMarker.setAttribute("message", (Object)(String.valueOf(UIMessages.UIBuildListener_InvalidInpathOutFolderText) + outFolder));
                errorMarker.setAttribute("severity", 2);
                errorMarker.setAttribute("location", (Object)"Inpath");
            }
            catch (CoreException coreException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
                CoreException e = coreException;
                AJLog.log((int)2, (String)("build: Problem occured creating the error marker for project " + project.getName() + ": " + (Object)((Object)e)));
            }
        }
    }

    /*
     * Exception decompiling
     */
    private boolean projectAlreadyMarked(IProject project, String errorMessage) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void markProject(IProject project, String errorMessage) {
        try {
            IMarker errorMarker = project.createMarker("org.eclipse.jdt.core.problem");
            errorMarker.setAttribute("message", (Object)errorMessage);
            errorMarker.setAttribute("severity", 2);
        }
        catch (CoreException coreException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, this, ajc$tjp_5, (JoinPoint.StaticPart)ajc$tjp_6);
            CoreException e = coreException;
            AJLog.log((int)2, (String)("build: Problem occured creating the error marker for project " + project.getName() + ": " + (Object)((Object)e)));
        }
    }

    public void postAJBuild(int kind, IProject project, boolean noSourceChanges) {
        if (noSourceChanges) {
            return;
        }
        String buildPrereqsMessage = NLS.bind((String)UIMessages.buildPrereqsMessage, (Object)project.getName());
        boolean buildCancelled = ((IAJCompilerMonitor)AspectJPlugin.getDefault().getCompilerFactory().getCompilerForProject(project).getBuildProgressMonitor()).buildWasCancelled();
        if (buildCancelled) {
            this.markReferencingProjects(project, buildPrereqsMessage);
        } else {
            this.removeMarkerOnReferencingProjects(project, buildPrereqsMessage);
        }
        ((UIMessageHandler)AspectJPlugin.getDefault().getCompilerFactory().getCompilerForProject(project).getMessageHandler()).showOutstandingProblems(project);
        this.checkOutJarEntry(project);
        this.checkInpathOutFolder(project);
        CoreCompilerConfiguration compilerConfig = this.getCompilerConfiguration(project);
        switch (kind) {
            case 15: {
                DeleteAndUpdateAJMarkersJob deleteUpdateMarkers = new DeleteAndUpdateAJMarkersJob(project);
                deleteUpdateMarkers.doDeleteOnly(true);
                deleteUpdateMarkers.schedule();
                break;
            }
            case 6: {
                DeleteAndUpdateAJMarkersJob deleteUpdateMarkers = new DeleteAndUpdateAJMarkersJob(project);
                deleteUpdateMarkers.schedule();
                break;
            }
            case 9: 
            case 10: {
                File[] touchedFiles = compilerConfig.getChangedFiles();
                if (touchedFiles != null && touchedFiles.length <= 0) break;
                DeleteAndUpdateAJMarkersJob deleteUpdateMarkers = new DeleteAndUpdateAJMarkersJob(project, touchedFiles);
                deleteUpdateMarkers.schedule();
            }
        }
        AJModelChecker.doModelCheckIfRequired((AJProjectModelFacade)AJProjectModelFactory.getInstance().getModelForProject(project));
        if (AspectJUIPlugin.getDefault().getDisplay().isDisposed()) {
            AJLog.log((String)"Not updating vis, xref, or changes views as display is disposed!");
        } else {
            AspectJUIPlugin.getDefault().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    Bundle vis;
                    AJLog.logStart((String)"Post compile");
                    Object[] listeners = UIBuildListener.this.fListeners.getListeners();
                    int i = 0;
                    while (i < listeners.length) {
                        ((IAdviceChangedListener)listeners[i]).adviceChanged();
                        ++i;
                    }
                    if (AspectJUIPlugin.usingXref) {
                        XReferenceUIPlugin.refresh();
                    }
                    if (AspectJUIPlugin.usingVisualiser && (vis = Platform.getBundle((String)"org.eclipse.contribution.visualiser")) != null && vis.getState() == 32 && ProviderManager.getContentProvider() instanceof AJDTContentProvider) {
                        AJDTContentProvider provider = (AJDTContentProvider)ProviderManager.getContentProvider();
                        provider.reset();
                        VisualiserPlugin.refresh();
                    }
                    AJLog.logEnd((int)2, (String)"Post compile");
                }
            });
        }
    }

    public void postAJClean(IProject project) {
        DeleteAndUpdateAJMarkersJob job = new DeleteAndUpdateAJMarkersJob(project);
        job.doDeleteOnly(true);
        job.schedule();
    }

    private CoreCompilerConfiguration getCompilerConfiguration(IProject project) {
        return (CoreCompilerConfiguration)AspectJPlugin.getDefault().getCompilerFactory().getCompilerForProject(project).getCompilerConfiguration();
    }

    public void addAdviceListener(IAdviceChangedListener adviceListener) {
        this.fListeners.add((Object)adviceListener);
    }

    public void removeAdviceListener(IAdviceChangedListener adviceListener) {
        this.fListeners.remove((Object)adviceListener);
    }

    private void markReferencingProjects(IProject project, String errorMessage) {
        IProject[] referencingProjects = this.getDependingProjects(project);
        int i = 0;
        while (i < referencingProjects.length) {
            IProject referencingProject = referencingProjects[i];
            if (!this.projectAlreadyMarked(referencingProject, errorMessage)) {
                this.markProject(referencingProject, errorMessage);
            }
            ++i;
        }
    }

    private void removeMarkerOnReferencingProjects(IProject project, String errorMessage) {
        try {
            IProject[] referencingProjects = this.getDependingProjects(project);
            int i = 0;
            while (i < referencingProjects.length) {
                IProject referencingProject = referencingProjects[i];
                IMarker[] problemMarkers = referencingProject.findMarkers("org.eclipse.jdt.core.problem", false, 2);
                if (problemMarkers.length > 0) {
                    int j = 0;
                    while (j < problemMarkers.length) {
                        IMarker marker = problemMarkers[j];
                        int markerSeverity = marker.getAttribute("severity", -1);
                        String markerMessage = marker.getAttribute("message", "no message");
                        if (markerSeverity == 2 && markerMessage.equals(errorMessage)) {
                            marker.delete();
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, this, ajc$tjp_7, (JoinPoint.StaticPart)ajc$tjp_8);
            CoreException e = coreException;
            AJLog.log((int)2, (String)("build: Problem occured either finding the markers for project " + project.getName() + ", or deleting the error marker: " + (Object)((Object)e)));
        }
    }

    private void checkOutJarEntry(IProject project) {
        String outJar = AspectJUIPlugin.getDefault().getCompilerFactory().getCompilerForProject(project).getCompilerConfiguration().getOutJar();
        if (outJar != null && !outJar.equals("")) {
            if (this.outjars == null) {
                this.outjars = new HashMap();
            }
            IPath newPath = this.getRelativePath(project, outJar);
            IClasspathEntry newEntry = JavaCore.newLibraryEntry((IPath)newPath.makeAbsolute(), null, null);
            if (this.outjars.containsKey(project)) {
                if (!this.outjars.get(project).equals(newEntry)) {
                    IClasspathEntry oldEntry = (IClasspathEntry)this.outjars.get(project);
                    this.outjars.remove(project);
                    this.removeOutjarFromDependingProjects(project, oldEntry);
                    this.outjars.put(project, newEntry);
                    this.updateDependingProjectsWithJar(project, newEntry);
                }
            } else {
                this.outjars.put(project, newEntry);
                this.updateDependingProjectsWithJar(project, newEntry);
            }
        } else if (this.outjars != null && this.outjars.containsKey(project)) {
            IClasspathEntry oldEntry = (IClasspathEntry)this.outjars.get(project);
            this.outjars.remove(project);
            if (this.outjars.size() == 0) {
                this.outjars = null;
            }
            this.removeOutjarFromDependingProjects(project, oldEntry);
        }
    }

    private void removeOutjarFromDependingProjects(IProject project, IClasspathEntry unwantedEntry) {
        IProject[] dependingProjects = this.getDependingProjects(project);
        int i = 0;
        while (i < dependingProjects.length) {
            IJavaProject javaProject = JavaCore.create((IProject)dependingProjects[i]);
            if (javaProject != null) {
                try {
                    IClasspathEntry[] cpEntry = javaProject.getRawClasspath();
                    ArrayList<IClasspathEntry> newEntries = new ArrayList<IClasspathEntry>();
                    int j = 0;
                    while (j < cpEntry.length) {
                        if (!cpEntry[j].equals(unwantedEntry)) {
                            newEntries.add(cpEntry[j]);
                        }
                        ++j;
                    }
                    IClasspathEntry[] newCP = newEntries.toArray(new IClasspathEntry[newEntries.size()]);
                    javaProject.setRawClasspath(newCP, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException coreException) {
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, this, ajc$tjp_9, (JoinPoint.StaticPart)ajc$tjp_10);
                }
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateDependingProjectsWithJar(IProject project, IClasspathEntry newEntry) {
        dependingProjects = this.getDependingProjects(project);
        i = 0;
        while (i < dependingProjects.length) {
            block6: {
                javaProject = JavaCore.create((IProject)dependingProjects[i]);
                if (javaProject == null) break block6;
                try {
                    cpEntry = javaProject.getRawClasspath();
                    newEntries = new ArrayList<IClasspathEntry>();
                    j = 0;
                    ** GOTO lbl19
                }
                catch (CoreException var10_11) {
                    // empty catch block
                    ** GOTO lbl29
                }
                while (!cpEntry[j].equals(newEntry)) {
                    try {
                        newEntries.add(cpEntry[j]);
                        ++j;
lbl19:
                        // 2 sources

                        if (j < cpEntry.length) continue;
                        newEntries.add(newEntry);
                        newCP = newEntries.toArray(new IClasspathEntry[newEntries.size()]);
                        javaProject.setRawClasspath(newCP, (IProgressMonitor)new NullProgressMonitor());
                        break;
                    }
                    catch (CoreException var9_10) {
                        UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(var9_10, this, UIBuildListener.ajc$tjp_11, (JoinPoint.StaticPart)UIBuildListener.ajc$tjp_12);
                        v0 = var9_10;
                    }
lbl29:
                    // 2 sources

                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(var10_11, this, UIBuildListener.ajc$tjp_13, (JoinPoint.StaticPart)UIBuildListener.ajc$tjp_12);
                    break;
                }
            }
            ++i;
        }
    }

    private IProject[] getDependingProjects(IProject project) {
        IProject[] referencingProjects = project.getReferencingProjects();
        IProject[] classFolderReferences = (IProject[])CoreUtils.getDependingProjects((IProject)project).get(0);
        IProject[] dependingProjects = new IProject[referencingProjects.length + classFolderReferences.length];
        int i = 0;
        while (i < referencingProjects.length) {
            dependingProjects[i] = referencingProjects[i];
            ++i;
        }
        i = 0;
        while (i < classFolderReferences.length) {
            dependingProjects[i + referencingProjects.length] = classFolderReferences[i];
            ++i;
        }
        return dependingProjects;
    }

    private IPath getRelativePath(IProject project, String outJar) {
        StringBuffer sb = new StringBuffer(outJar);
        int index = sb.lastIndexOf(project.getName());
        Path path = index > 0 ? new Path(sb.substring(sb.lastIndexOf(project.getName()))) : new Path(outJar);
        return path.makeAbsolute();
    }

    private boolean pathExists(String pathStr) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        Path path = new Path(pathStr);
        if (path.segmentCount() == 1) {
            return root.findMember((IPath)path).exists();
        }
        return root.getFolder((IPath)path).exists();
    }

    static {
        Factory factory = new Factory("UIBuildListener.java", Class.forName("org.eclipse.ajdt.internal.builder.UIBuildListener"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.builder.UIBuildListener", "org.eclipse.core.runtime.CoreException:", "e:"), 123);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "checkInpathOutFolder", "org.eclipse.ajdt.internal.builder.UIBuildListener", "org.eclipse.core.resources.IProject:", "project:", "", "void"), 110);
        ajc$tjp_10 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "removeOutjarFromDependingProjects", "org.eclipse.ajdt.internal.builder.UIBuildListener", "org.eclipse.core.resources.IProject:org.eclipse.jdt.core.IClasspathEntry:", "project:unwantedEntry:", "", "void"), 387);
        ajc$tjp_11 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.builder.UIBuildListener", "org.eclipse.core.runtime.CoreException:", "<missing>:"), 432);
        ajc$tjp_12 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "updateDependingProjectsWithJar", "org.eclipse.ajdt.internal.builder.UIBuildListener", "org.eclipse.core.resources.IProject:org.eclipse.jdt.core.IClasspathEntry:", "project:newEntry:", "", "void"), 411);
        ajc$tjp_13 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.builder.UIBuildListener", "org.eclipse.core.runtime.CoreException:", "<missing>:"), 432);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.builder.UIBuildListener", "org.eclipse.core.runtime.CoreException:", "e:"), 152);
        ajc$tjp_3 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "projectAlreadyMarked", "org.eclipse.ajdt.internal.builder.UIBuildListener", "org.eclipse.core.resources.IProject:java.lang.String:", "project:errorMessage:", "", "boolean"), 135);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.builder.UIBuildListener", "org.eclipse.core.runtime.CoreException:", "e:"), 152);
        ajc$tjp_5 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.builder.UIBuildListener", "org.eclipse.core.runtime.CoreException:", "e:"), 164);
        ajc$tjp_6 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "markProject", "org.eclipse.ajdt.internal.builder.UIBuildListener", "org.eclipse.core.resources.IProject:java.lang.String:", "project:errorMessage:", "", "void"), 159);
        ajc$tjp_7 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.builder.UIBuildListener", "org.eclipse.core.runtime.CoreException:", "e:"), 339);
        ajc$tjp_8 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "removeMarkerOnReferencingProjects", "org.eclipse.ajdt.internal.builder.UIBuildListener", "org.eclipse.core.resources.IProject:java.lang.String:", "project:errorMessage:", "", "void"), 315);
        ajc$tjp_9 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.builder.UIBuildListener", "org.eclipse.core.runtime.CoreException:", "<missing>:"), 406);
    }
}

