/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.wizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ajdt.core.AspectJCorePreferences;
import org.eclipse.ajdt.internal.ui.preferences.PreferencePageBuilder;
import org.eclipse.ajdt.internal.ui.text.UIMessages;
import org.eclipse.ajdt.internal.ui.wizards.PathBlock;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.jdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.jdt.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.FolderSelectionDialog;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.TreeListDialogField;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class InPathBlock
extends PathBlock {
    private StatusInfo fOutputFolderStatus;
    private IPath fOutputLocationPath;
    private StringButtonDialogField fInpathOutputField;
    private ModifyListener FOutputPathModifyListener;
    private Text fOutputPathTextBox;

    public InPathBlock(IStatusChangeListener context, int pageToShow) {
        super(context, pageToShow);
        this.fPathList.setLabelText(UIMessages.InPathBlock_inpath_label);
        this.fOutputFolderStatus = new StatusInfo();
    }

    public void init(IJavaProject jproject, IClasspathEntry[] inpathEntries) {
        IProject project;
        String outFolderStr;
        this.setJavaProject(jproject);
        ArrayList newInPath = null;
        if (inpathEntries != null) {
            newInPath = this.getExistingEntries(inpathEntries);
        }
        if (newInPath == null) {
            newInPath = new ArrayList();
        }
        Path outputPath = (outFolderStr = AspectJCorePreferences.getProjectInpathOutFolder((IProject)(project = jproject.getProject()))) == null || outFolderStr.equals("") ? null : new Path(outFolderStr);
        this.changeInpathOutputText((IPath)outputPath);
        ArrayList arrayList = newInPath;
        TreeListDialogField treeListDialogField = this.fPathList;
        PreferencePageBuilder.aspectOf().ajc$before$org_eclipse_ajdt_internal_ui_preferences_PreferencePageBuilder$6$5dca5dc3(treeListDialogField, arrayList, this);
        treeListDialogField.setElements(arrayList);
        super.init();
    }

    protected void updateJavaBuildPathStatus() {
        super.updateJavaBuildPathStatus();
        this.updateOutputFolderStatus();
    }

    private void updateOutputFolderStatus() {
        if (this.fOutputLocationPath == null) {
            this.fOutputFolderStatus.setOK();
            return;
        }
        if (this.fOutputLocationPath.segmentCount() < 2 || this.fOutputLocationPath.matchingFirstSegments(this.getJavaProject().getPath()) == 0) {
            this.fOutputFolderStatus.setError(String.valueOf(UIMessages.InPathBlock_outFolder_1) + this.fOutputLocationPath.toPortableString() + UIMessages.InPathBlock_outFolder_2);
            return;
        }
        IFolder outFolder = this.fWorkspaceRoot.getFolder(this.fOutputLocationPath);
        if (outFolder.exists()) {
            this.fOutputFolderStatus.setOK();
        } else {
            this.fOutputFolderStatus.setError(String.valueOf(UIMessages.InPathBlock_outFolder_3) + this.fOutputLocationPath.toPortableString() + UIMessages.InPathBlock_outFolder_4);
        }
    }

    protected void internalSetProjectPath(List pathEntries, StringBuffer pathBuffer, StringBuffer contentKindBuffer, StringBuffer entryKindBuffer) {
        AspectJCorePreferences.setProjectInPath((IProject)this.getJavaProject().getProject(), (String)pathBuffer.toString(), (String)contentKindBuffer.toString(), (String)entryKindBuffer.toString());
    }

    public TabItem tabContent(TabFolder folder) {
        TabItem item = super.tabContent(folder);
        Control control = item.getControl();
        if (control instanceof Composite) {
            Composite parent = (Composite)control;
            new Label(parent, 16448);
            Label label = new Label(parent, 16448);
            label.setText(UIMessages.InPathBlock_6);
            this.fInpathOutputField = new StringButtonDialogField(new IStringButtonAdapter(){

                public void changeControlPressed(DialogField field) {
                    IContainer container = InPathBlock.this.chooseContainer(InPathBlock.this.fOutputLocationPath);
                    if (container != null) {
                        InPathBlock.this.changeInpathOutputText(container.getFullPath());
                    }
                }
            });
            if (this.fOutputLocationPath != null) {
                this.fInpathOutputField.setTextWithoutUpdate(this.fOutputLocationPath.toPortableString());
            }
            this.fInpathOutputField.setButtonLabel(UIMessages.InPathBlock_Browse);
            this.fInpathOutputField.doFillIntoGrid(parent, 3);
            this.FOutputPathModifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    InPathBlock.this.changeInpathOutputFolder();
                }
            };
            this.fOutputPathTextBox = this.fInpathOutputField.getTextControl(parent);
            this.fOutputPathTextBox.addModifyListener(this.FOutputPathModifyListener);
        }
        return item;
    }

    private void changeInpathOutputFolder() {
        String newText = this.fInpathOutputField.getText();
        this.fOutputLocationPath = newText.equals("") ? null : new Path(newText);
        this.updateOutputFolderStatus();
        this.updateJavaBuildPathStatus();
        this.doStatusLineUpdate();
    }

    private void changeInpathOutputText(IPath newPath) {
        String newText;
        if (newPath == null) {
            this.fOutputLocationPath = null;
            newText = "";
        } else {
            this.fOutputLocationPath = newPath.makeRelative();
            newText = this.fOutputLocationPath.toPortableString();
        }
        this.fOutputPathTextBox.removeModifyListener(this.FOutputPathModifyListener);
        this.fOutputPathTextBox.setText(newText);
        this.fOutputPathTextBox.addModifyListener(this.FOutputPathModifyListener);
        this.updateOutputFolderStatus();
        this.updateJavaBuildPathStatus();
        this.doStatusLineUpdate();
    }

    private IContainer chooseContainer(IPath initPath) {
        Class[] acceptedClasses = new Class[]{IProject.class, IFolder.class};
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, false);
        IProject[] allProjects = this.fWorkspaceRoot.getProjects();
        ArrayList<IProject> rejectedElements = new ArrayList<IProject>(allProjects.length);
        IProject currProject = this.getJavaProject().getProject();
        int i = 0;
        while (i < allProjects.length) {
            if (!allProjects[i].equals((Object)currProject)) {
                rejectedElements.add(allProjects[i]);
            }
            ++i;
        }
        TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses, rejectedElements.toArray());
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        WorkbenchContentProvider cp = new WorkbenchContentProvider();
        IResource initSelection = null;
        if (initPath != null) {
            initSelection = this.fWorkspaceRoot.findMember(initPath);
        }
        FolderSelectionDialog dialog = new FolderSelectionDialog(this.getShell(), (ILabelProvider)lp, (ITreeContentProvider)cp);
        dialog.setTitle(UIMessages.BuildPathsBlock_ChooseOutputFolderDialog_title);
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setMessage(UIMessages.BuildPathsBlock_ChooseOutputFolderDialog_description);
        dialog.addFilter((ViewerFilter)filter);
        dialog.setInput((Object)this.fWorkspaceRoot);
        dialog.setInitialSelection((Object)initSelection);
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        if (dialog.open() == 0) {
            return (IContainer)dialog.getFirstResult();
        }
        return null;
    }

    protected String getBlockNote() {
        return UIMessages.InPathBlock_note;
    }

    public String getBlockTitle() {
        return UIMessages.InPathBlock_tab_inpath_order;
    }

    protected IStatus findMostSevereStatus() {
        return StatusUtil.getMostSevere((IStatus[])new IStatus[]{this.fPathStatus, this.fOutputFolderStatus, this.fJavaBuildPathStatus});
    }

    public String getOutputFolder() {
        return this.fOutputLocationPath == null ? null : this.fOutputLocationPath.toPortableString();
    }

    protected String getEncodedSettings() {
        StringBuffer settings = new StringBuffer(super.getEncodedSettings());
        CPListElement.appendEncodePath((IPath)this.fOutputLocationPath, (StringBuffer)settings).append(';');
        return settings.toString();
    }
}

