/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.ajdt.core.IAJLogger;

public class AJLog {
    public static final int DEFAULT = 0;
    public static final int COMPILER = 1;
    public static final int BUILDER = 2;
    public static final int BUILDER_CLASSPATH = 3;
    public static final int COMPILER_PROGRESS = 4;
    public static final int COMPILER_MESSAGES = 5;
    public static final int PARSER = 6;
    private static IAJLogger logger;
    private static Map timers;

    static {
        timers = new HashMap();
    }

    public static void log(String msg) {
        AJLog.log(0, msg);
    }

    public static void log(int category, String msg) {
        if (logger != null) {
            logger.log(category, msg);
        } else {
            System.out.println(msg);
        }
    }

    public static void logStart(String event) {
        Long now = new Long(System.currentTimeMillis());
        timers.put(event, now);
    }

    public static void logEnd(int category, String event) {
        AJLog.logEnd(category, event, null);
    }

    public static void logEnd(int category, String event, String optional_msg) {
        Long then = (Long)timers.get(event);
        if (then != null) {
            long now = System.currentTimeMillis();
            long elapsed = now - then;
            if (optional_msg != null && optional_msg.length() > 0) {
                AJLog.log(category, "Timer event: " + elapsed + "ms: " + event + " (" + optional_msg + ")");
            } else {
                AJLog.log(category, "Timer event: " + elapsed + "ms: " + event);
            }
            timers.remove(event);
        }
    }

    public static void setLogger(IAJLogger l) {
        logger = l;
    }
}

