/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.core.parserbridge;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.aspectj.asm.IProgramElement;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.model.AJProjectModelFacade;
import org.eclipse.ajdt.core.model.AJProjectModelFactory;
import org.eclipse.ajdt.core.model.AJRelationshipManager;
import org.eclipse.ajdt.core.model.AJWorldFacade;
import org.eclipse.ajdt.internal.core.ras.CoreFFDC;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.parser.TypeConverter;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;

public class ITDInserter
extends ASTVisitor {
    private final ICompilationUnit unit;
    private Map origMap = new HashMap();
    private final ITDTypeConverter typeConverter;
    private AJProjectModelFacade model;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;

    public ITDInserter(ICompilationUnit unit, ProblemReporter reporter) {
        this.unit = unit;
        this.typeConverter = new ITDTypeConverter(reporter);
        this.model = AJProjectModelFactory.getInstance().getModelForJavaElement((IJavaElement)unit);
    }

    public boolean visit(TypeDeclaration type, BlockScope blockScope) {
        this.augmentType(type);
        return false;
    }

    public boolean visit(TypeDeclaration type, CompilationUnitScope compilationUnitScope) {
        this.augmentType(type);
        return true;
    }

    public boolean visit(TypeDeclaration memberType, ClassScope classScope) {
        this.augmentType(memberType);
        return true;
    }

    private void augmentType(TypeDeclaration type) {
        OrigContents orig = new OrigContents();
        orig.methods = type.methods;
        orig.fields = type.fields;
        orig.superClass = type.superclass;
        orig.superInterfaces = type.superInterfaces;
        try {
            LinkedList<FieldDeclaration> itdFields = new LinkedList<FieldDeclaration>();
            LinkedList<Object> itdMethods = new LinkedList<Object>();
            IType handle = this.getHandle(type);
            List ipes = this.getITDs(handle);
            for (IProgramElement elt : ipes) {
                boolean isExtends;
                if (elt.getKind() == IProgramElement.Kind.INTER_TYPE_METHOD) {
                    if (TypeDeclaration.kind((int)type.modifiers) != 1) continue;
                    itdMethods.add(this.createMethod(elt, type, handle));
                    continue;
                }
                if (elt.getKind() == IProgramElement.Kind.INTER_TYPE_CONSTRUCTOR) {
                    itdMethods.add(this.createConstructor(elt, type));
                    continue;
                }
                if (elt.getKind() == IProgramElement.Kind.INTER_TYPE_FIELD) {
                    itdFields.add(this.createField(elt, type));
                    continue;
                }
                if (elt.getKind() != IProgramElement.Kind.DECLARE_PARENTS) continue;
                String details = elt.getDetails();
                boolean bl = isExtends = details != null && details.startsWith("extends");
                if (elt.getParentTypes() == null || elt.getParentTypes().size() <= 0) continue;
                if (isExtends && TypeDeclaration.kind((int)type.modifiers) == 1) {
                    this.addSuperClass(elt, type);
                    continue;
                }
                this.addSuperInterfaces(elt, type);
            }
            boolean interfaceImplInserted = false;
            if (ipes.size() > 0 || interfaceImplInserted) {
                int i;
                this.origMap.put(type, orig);
                if (itdFields.size() > 0) {
                    int numFields = type.fields == null ? 0 : type.fields.length;
                    FieldDeclaration[] fields = new FieldDeclaration[numFields + itdFields.size()];
                    if (numFields > 0) {
                        System.arraycopy(type.fields, 0, fields, 0, numFields);
                    }
                    i = 0;
                    while (i < itdFields.size()) {
                        fields[i + numFields] = (FieldDeclaration)itdFields.get(i);
                        ++i;
                    }
                    type.fields = fields;
                }
                if (itdMethods.size() > 0) {
                    int numMethods = type.methods == null ? 0 : type.methods.length;
                    AbstractMethodDeclaration[] methods = new AbstractMethodDeclaration[numMethods + itdMethods.size()];
                    if (numMethods > 0) {
                        System.arraycopy(type.methods, 0, methods, 0, numMethods);
                    }
                    i = 0;
                    while (i < itdMethods.size()) {
                        methods[i + numMethods] = (AbstractMethodDeclaration)itdMethods.get(i);
                        ++i;
                    }
                    type.methods = methods;
                }
            }
        }
        catch (Exception exception) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(exception, (Object)this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
            this.origMap.remove(type);
            this.revertType(type, orig);
        }
    }

    private FieldDeclaration createField(IProgramElement field, TypeDeclaration type) {
        FieldDeclaration decl = new FieldDeclaration();
        decl.name = field.getName().split("\\.")[1].toCharArray();
        decl.type = this.createTypeReference(field.getCorrespondingType(true));
        decl.modifiers = field.getRawModifiers();
        return decl;
    }

    /*
     * Unable to fully structure code
     */
    private MethodDeclaration createMethod(IProgramElement method, TypeDeclaration type, IType handle) {
        block6: {
            decl = new MethodDeclaration(type.compilationResult);
            decl.scope = new MethodScope(type.scope, (ReferenceContext)decl, true);
            decl.selector = method.getName().split("\\.")[1].toCharArray();
            decl.modifiers = method.getRawModifiers();
            decl.returnType = this.createTypeReference(method.getCorrespondingType(true));
            decl.modifiers = method.getRawModifiers();
            args = method.getParameterTypes() != null ? new Argument[method.getParameterTypes().size()] : new Argument[]{};
            try {
                world = new AJWorldFacade(handle.getJavaProject().getProject());
                sig = world.getTypeParameters(org.eclipse.jdt.core.Signature.createTypeSignature((String)handle.getFullyQualifiedName(), (boolean)true), method);
                if (sig == null) {
                    params = new String[method.getParameterTypes().size()];
                    i = 0;
                    while (i < params.length) {
                        params[i] = new String((char[])method.getParameterTypes().get(i));
                        ++i;
                    }
                    sig = new AJWorldFacade.ErasedTypeSignature(method.getCorrespondingType(true), params);
                }
                i = 0;
                while (i < args.length) {
                    args[i] = new Argument(((String)method.getParameterNames().get(i)).toCharArray(), 0L, this.createTypeReference(org.eclipse.jdt.core.Signature.getElementType((String)sig.paramTypes[i])), 0);
                    ++i;
                }
                break block6;
            }
            catch (Exception var10_12) {
                CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(var10_12, (Object)this, ITDInserter.ajc$tjp_2, (JoinPoint.StaticPart)ITDInserter.ajc$tjp_3);
                i = 0;
                ** while (i < args.length)
            }
lbl-1000:
            // 1 sources

            {
                args[i] = new Argument(((String)method.getParameterNames().get(i)).toCharArray(), 0L, this.createTypeReference(new String((char[])method.getParameterTypes().get(i))), 0);
                ++i;
                continue;
            }
        }
        decl.arguments = args;
        return decl;
    }

    private ConstructorDeclaration createConstructor(IProgramElement constructor, TypeDeclaration type) {
        ConstructorDeclaration decl = new ConstructorDeclaration(type.compilationResult);
        decl.scope = new MethodScope(type.scope, (ReferenceContext)decl, true);
        decl.selector = constructor.getName().split("\\.")[1].toCharArray();
        decl.modifiers = constructor.getRawModifiers();
        Argument[] args = constructor.getParameterTypes() != null ? new Argument[constructor.getParameterTypes().size()] : new Argument[]{};
        int i = 0;
        while (i < args.length) {
            args[i] = new Argument(((String)constructor.getParameterNames().get(i)).toCharArray(), 0L, this.createTypeReference(new String((char[])constructor.getParameterTypes().get(i))), 0);
            ++i;
        }
        decl.arguments = args;
        return decl;
    }

    private void addSuperClass(IProgramElement ipe, TypeDeclaration decl) {
        String typeName = (String)ipe.getParentTypes().get(0);
        typeName = typeName.replaceAll("\\$", "\\.");
        decl.superclass = this.createTypeReference(typeName);
    }

    private void addSuperInterfaces(IProgramElement ipe, TypeDeclaration decl) {
        List types = ipe.getParentTypes();
        if (types != null) {
            int index = 0;
            for (String type : types) {
                type = type.replaceAll("\\$", "\\.");
                types.set(index++, type);
            }
            int superInterfacesNum = decl.superInterfaces == null ? 0 : decl.superInterfaces.length;
            TypeReference[] refs = new TypeReference[superInterfacesNum + types.size()];
            if (superInterfacesNum > 0) {
                System.arraycopy(decl.superInterfaces, 0, refs, 0, decl.superInterfaces.length);
            }
            int i = 0;
            while (i < refs.length - superInterfacesNum) {
                refs[i + superInterfacesNum] = this.createTypeReference((String)types.get(i));
                ++i;
            }
            decl.superInterfaces = refs;
        }
    }

    private IType getHandle(TypeDeclaration decl) {
        String typeName = new String(decl.name);
        try {
            IJavaElement maybeType = this.unit.getElementAt(decl.sourceStart);
            if (maybeType != null && maybeType.getElementType() == 7) {
                return (IType)maybeType;
            }
        }
        catch (JavaModelException javaModelException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, (Object)this, ajc$tjp_4, (JoinPoint.StaticPart)ajc$tjp_5);
        }
        try {
            IType type = this.getHandleFromChild(typeName, (IParent)this.unit);
            if (type != null) {
                return type;
            }
        }
        catch (JavaModelException javaModelException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, (Object)this, ajc$tjp_6, (JoinPoint.StaticPart)ajc$tjp_5);
        }
        return this.unit.getType(typeName);
    }

    private IType getHandleFromChild(String typeName, IParent parent) throws JavaModelException {
        IJavaElement[] children = parent.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i].getElementType() == 7 && typeName.equals(children[i].getElementName())) {
                return (IType)children[i];
            }
            ++i;
        }
        i = 0;
        while (i < children.length) {
            IType type;
            if ((children[i].getElementType() == 7 || children[i].getElementType() == 9) && (type = this.getHandleFromChild(typeName, (IParent)children[i])) != null) {
                return type;
            }
            ++i;
        }
        return null;
    }

    private List getITDs(IType handle) {
        if (this.model.hasModel() && this.model.hasProgramElement((IJavaElement)handle)) {
            List rels = this.model.getRelationshipsForElement((IJavaElement)handle, AJRelationshipManager.ASPECT_DECLARATIONS);
            ArrayList<IProgramElement> elts = new ArrayList<IProgramElement>();
            for (IJavaElement je : rels) {
                IProgramElement declareElt = this.model.javaElementToProgramElement(je);
                elts.add(declareElt);
            }
            return elts;
        }
        return Collections.EMPTY_LIST;
    }

    private TypeReference createTypeReference(String origTypeName) {
        if (origTypeName.endsWith("#RAW")) {
            origTypeName = origTypeName.substring(0, origTypeName.length() - 4);
        }
        origTypeName = origTypeName.replace('$', '.');
        return this.typeConverter.createTypeReference(origTypeName.toCharArray());
    }

    public void revert() {
        for (Map.Entry entry : this.origMap.entrySet()) {
            TypeDeclaration type = (TypeDeclaration)entry.getKey();
            OrigContents orig = (OrigContents)entry.getValue();
            this.revertType(type, orig);
        }
    }

    private void revertType(TypeDeclaration type, OrigContents orig) {
        type.methods = orig.methods;
        type.fields = orig.fields;
        type.superclass = orig.superClass;
        type.superInterfaces = orig.superInterfaces;
    }

    static {
        Factory factory = new Factory("ITDInserter.java", Class.forName("org.eclipse.ajdt.core.parserbridge.ITDInserter"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.parserbridge.ITDInserter", "java.lang.Exception:", "<missing>:"), 208);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "augmentType", "org.eclipse.ajdt.core.parserbridge.ITDInserter", "org.eclipse.jdt.internal.compiler.ast.TypeDeclaration:", "type:", "", "void"), 117);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.parserbridge.ITDInserter", "java.lang.Exception:", "<missing>:"), 257);
        ajc$tjp_3 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "createMethod", "org.eclipse.ajdt.core.parserbridge.ITDInserter", "org.aspectj.asm.IProgramElement:org.eclipse.jdt.internal.compiler.ast.TypeDeclaration:org.eclipse.jdt.core.IType:", "method:type:handle:", "", "org.eclipse.jdt.internal.compiler.ast.MethodDeclaration"), 224);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.parserbridge.ITDInserter", "org.eclipse.jdt.core.JavaModelException:", "<missing>:"), 324);
        ajc$tjp_5 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "getHandle", "org.eclipse.ajdt.core.parserbridge.ITDInserter", "org.eclipse.jdt.internal.compiler.ast.TypeDeclaration:", "decl:", "", "org.eclipse.jdt.core.IType"), 317);
        ajc$tjp_6 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.core.parserbridge.ITDInserter", "org.eclipse.jdt.core.JavaModelException:", "<missing>:"), 332);
    }

    private static class ITDTypeConverter
    extends TypeConverter {
        public ITDTypeConverter(ProblemReporter reporter) {
            super(reporter, '.');
        }

        protected TypeReference createTypeReference(char[] typeName) {
            return super.createTypeReference(typeName, 0, typeName.length);
        }
    }

    private static class OrigContents {
        AbstractMethodDeclaration[] methods;
        FieldDeclaration[] fields;
        TypeReference superClass;
        TypeReference[] superInterfaces;

        private OrigContents() {
        }
    }
}

