/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.core.ajde;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aspectj.ajde.core.IOutputLocationManager;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AJLog;
import org.eclipse.ajdt.core.AspectJCorePreferences;
import org.eclipse.ajdt.core.CoreUtils;
import org.eclipse.ajdt.internal.core.ras.CoreFFDC;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class CoreOutputLocationManager
implements IOutputLocationManager {
    private String projectName;
    private final IProject project;
    private final IJavaProject jProject;
    private File defaultOutput;
    private Map srcFolderToOutput;
    private final Map fileSystemPathToIContainer;
    private List allOutputFolders;
    private List allSourceFolders;
    private Set touchedCUs;
    private boolean outputIsRoot;
    private File commonOutputDir;
    private IWorkspaceRoot workspaceRoot;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_12;

    public CoreOutputLocationManager(IProject project) {
        block6: {
            this.srcFolderToOutput = new HashMap();
            this.fileSystemPathToIContainer = new HashMap();
            this.allOutputFolders = new ArrayList();
            this.allSourceFolders = new ArrayList();
            this.touchedCUs = new HashSet();
            this.project = project;
            this.workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            this.jProject = JavaCore.create((IProject)project);
            this.initSourceFolders();
            if (!this.isUsingSeparateOutputFolders(this.jProject)) {
                this.setCommonOutputDir();
                this.allOutputFolders.add(this.commonOutputDir);
                if (this.commonOutputDir != null) {
                    try {
                        if (this.outputIsRoot) {
                            this.fileSystemPathToIContainer.put(this.commonOutputDir.getAbsolutePath(), project);
                            break block6;
                        }
                        this.fileSystemPathToIContainer.put(this.commonOutputDir.getAbsolutePath(), this.workspaceRoot.getFolder(this.jProject.getOutputLocation()));
                    }
                    catch (JavaModelException javaModelException) {
                        CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
                    }
                }
            } else {
                this.init();
            }
        }
    }

    private void initSourceFolders() {
        try {
            IClasspathEntry[] cpe = this.jProject.getRawClasspath();
            int i = 0;
            while (i < cpe.length) {
                if (cpe[i].getEntryKind() == 3) {
                    IPath path = cpe[i].getPath();
                    path = path.removeFirstSegments(1).makeRelative();
                    this.allSourceFolders.add(path);
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, this, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_3);
        }
    }

    private void init() {
        this.outputIsRoot = false;
        this.projectName = this.jProject.getProject().getName();
        String inpathOutFolder = this.getInpathOutputFolder();
        boolean isUsingNonDefaultInpathOutfolder = inpathOutFolder != null;
        try {
            IPath outputLocationPath = this.jProject.getOutputLocation();
            this.defaultOutput = this.workspacePathToFile(outputLocationPath);
            this.allOutputFolders.add(this.defaultOutput);
            this.fileSystemPathToIContainer.put(this.defaultOutput.getAbsolutePath(), this.project.getFullPath().equals((Object)outputLocationPath) ? this.project : this.workspaceRoot.getFolder(outputLocationPath));
            IClasspathEntry[] cpe = this.jProject.getRawClasspath();
            int i = 0;
            while (i < cpe.length) {
                block11: {
                    IPath output;
                    if (isUsingNonDefaultInpathOutfolder) {
                        IClasspathAttribute[] attributes = cpe[i].getExtraAttributes();
                        int j = 0;
                        while (j < attributes.length) {
                            if (AspectJCorePreferences.isInPathAttribute(attributes[j])) {
                                IPath path = cpe[i].getPath();
                                File f = this.workspacePathToFile(path);
                                if (f != null && f.exists()) {
                                    String srcFolder = new Path(f.getPath()).toPortableString();
                                    File out = this.workspacePathToFile((IPath)new Path(inpathOutFolder));
                                    this.srcFolderToOutput.put(srcFolder, out);
                                }
                                break block11;
                            }
                            ++j;
                        }
                    }
                    if (cpe[i].getEntryKind() == 3 && (output = cpe[i].getOutputLocation()) != null) {
                        IPath path = cpe[i].getPath();
                        String srcFolder = path.removeFirstSegments(1).toPortableString();
                        if (path.segmentCount() == 1) {
                            srcFolder = path.toPortableString();
                        }
                        File out = this.workspacePathToFile(output);
                        this.srcFolderToOutput.put(srcFolder, out);
                        if (!this.allOutputFolders.contains(out)) {
                            this.allOutputFolders.add(out);
                            this.fileSystemPathToIContainer.put(out.getAbsolutePath(), this.workspaceRoot.getFolder(output));
                        }
                        if (this.outputIsRoot) {
                            this.defaultOutput = out;
                        }
                    }
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, this, ajc$tjp_4, (JoinPoint.StaticPart)ajc$tjp_5);
        }
    }

    public File getOutputLocationForClass(File compilationUnit) {
        if (CoreUtils.ASPECTJ_SOURCE_FILTER.accept(compilationUnit.getName())) {
            this.touchedCUs.add(compilationUnit);
        }
        return this.getOutputLocationForResource(compilationUnit);
    }

    public File getOutputLocationForResource(File resource) {
        int ind;
        if (!this.isUsingSeparateOutputFolders(this.jProject)) {
            return this.commonOutputDir;
        }
        if (resource == null || resource.toString() == null) {
            return this.defaultOutput;
        }
        String fileName = resource.toString().replace('\\', '/');
        if (this.projectName == null) {
            this.projectName = this.jProject.getProject().getName();
            if (this.projectName == null) {
                AJLog.log(0, "CoreOutputLocationManager: cannot determine project name of this project: " + this.jProject);
                this.projectName = "/";
            }
        }
        if ((ind = fileName.indexOf(this.projectName)) != -1) {
            String rest = fileName.substring(ind + this.projectName.length() + 1);
            for (String src : this.srcFolderToOutput.keySet()) {
                if (!rest.startsWith(src)) continue;
                File out = (File)this.srcFolderToOutput.get(src);
                return out;
            }
        } else {
            for (String src : this.srcFolderToOutput.keySet()) {
                if (!fileName.startsWith(src)) continue;
                File out = (File)this.srcFolderToOutput.get(src);
                return out;
            }
        }
        return this.defaultOutput;
    }

    /*
     * Exception decompiling
     */
    private boolean isUsingSeparateOutputFolders(IJavaProject jp) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void setCommonOutputDir() {
        IPath workspaceRelativeOutputPath;
        IJavaProject jProject = JavaCore.create((IProject)this.project);
        try {
            workspaceRelativeOutputPath = jProject.getOutputLocation();
        }
        catch (JavaModelException javaModelException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, this, ajc$tjp_9, (JoinPoint.StaticPart)ajc$tjp_10);
            this.commonOutputDir = this.project.getLocation().toFile();
            this.outputIsRoot = true;
            return;
        }
        if (workspaceRelativeOutputPath.segmentCount() == 1) {
            this.commonOutputDir = jProject.getResource().getLocation().toFile();
            this.outputIsRoot = true;
            return;
        }
        IFolder out = ResourcesPlugin.getWorkspace().getRoot().getFolder(workspaceRelativeOutputPath);
        this.commonOutputDir = out.getLocation().toFile();
    }

    private File workspacePathToFile(IPath path) {
        if (path.segmentCount() == 1) {
            IResource res = this.workspaceRoot.findMember(path);
            this.outputIsRoot = true;
            return res.getLocation().toFile();
        }
        IFolder out = this.workspaceRoot.getFolder(path);
        IPath outPath = out.getLocation();
        if (outPath != null) {
            return outPath.toFile();
        }
        return null;
    }

    public List getAllOutputLocations() {
        return this.allOutputFolders;
    }

    public String getInpathOutputFolder() {
        String inpathOutFolder = AspectJCorePreferences.getProjectInpathOutFolder(this.project);
        return inpathOutFolder;
    }

    public File[] getTouchedClassFiles() {
        return this.touchedCUs.toArray(new File[this.touchedCUs.size()]);
    }

    public void resetTouchedClassFiles() {
        this.touchedCUs.clear();
    }

    public File getDefaultOutputLocation() {
        if (!this.isUsingSeparateOutputFolders(this.jProject)) {
            return this.commonOutputDir;
        }
        return this.defaultOutput;
    }

    public String getSourceFolderForFile(File sourceFile) {
        Path sourceFilePath = new Path(sourceFile.getAbsolutePath());
        IPath projLoc = this.project.getLocation();
        if (projLoc.isPrefixOf((IPath)sourceFilePath)) {
            sourceFilePath = sourceFilePath.setDevice(null).removeFirstSegments(projLoc.segmentCount()).makeRelative();
        }
        for (IPath sourceFolderPath : this.allSourceFolders) {
            if (!sourceFolderPath.isPrefixOf((IPath)sourceFilePath)) continue;
            return sourceFolderPath.toPortableString();
        }
        return null;
    }

    public void reportClassFileWrite(String outFileStr) {
        block6: {
            try {
                for (Map.Entry entry : this.fileSystemPathToIContainer.entrySet()) {
                    String outFolderStr = (String)entry.getKey();
                    if (!outFileStr.startsWith(outFolderStr)) continue;
                    IContainer outFolder = (IContainer)entry.getValue();
                    IFile outFile = outFolder.getFile((IPath)new Path(outFileStr.substring(outFolderStr.length())));
                    if (!outFile.exists()) {
                        outFile.refreshLocal(0, null);
                    }
                    if (!outFile.exists()) continue;
                    outFile.setDerived(true);
                    IPath projectPath = this.project.getLocation();
                    Path outFilePath = new Path(outFileStr);
                    String pathFromProject = projectPath.isPrefixOf((IPath)outFilePath) ? outFilePath.removeFirstSegments(projectPath.segmentCount()).makeRelative().toPortableString() : outFileStr;
                    if (this.outputIsRoot || !this.srcFolderToOutput.containsKey(pathFromProject)) break;
                    IContainer parent = outFile.getParent();
                    while (!parent.equals((Object)outFolder)) {
                        parent.setDerived(true);
                        parent = parent.getParent();
                        if (parent != null) {
                            continue;
                        }
                        break block6;
                    }
                    break;
                }
            }
            catch (CoreException coreException) {
                CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, this, ajc$tjp_11, (JoinPoint.StaticPart)ajc$tjp_12);
            }
        }
    }

    static {
        Factory factory = new Factory("CoreOutputLocationManager.java", Class.forName("org.eclipse.ajdt.internal.core.ajde.CoreOutputLocationManager"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.core.ajde.CoreOutputLocationManager", "org.eclipse.jdt.core.JavaModelException:", "<missing>:"), 104);
        ajc$tjp_1 = factory.makeESJP("constructor-execution", (Signature)factory.makeConstructorSig("1", "org.eclipse.ajdt.internal.core.ajde.CoreOutputLocationManager", "org.eclipse.core.resources.IProject:", "project:", ""), 85);
        ajc$tjp_10 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "setCommonOutputDir", "org.eclipse.ajdt.internal.core.ajde.CoreOutputLocationManager", "", "", "", "void"), 282);
        ajc$tjp_11 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.core.ajde.CoreOutputLocationManager", "org.eclipse.core.runtime.CoreException:", "<missing>:"), 414);
        ajc$tjp_12 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "reportClassFileWrite", "org.eclipse.ajdt.internal.core.ajde.CoreOutputLocationManager", "java.lang.String:", "outFileStr:", "", "void"), 369);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.core.ajde.CoreOutputLocationManager", "org.eclipse.jdt.core.JavaModelException:", "<missing>:"), 127);
        ajc$tjp_3 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "initSourceFolders", "org.eclipse.ajdt.internal.core.ajde.CoreOutputLocationManager", "", "", "", "void"), 117);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.core.ajde.CoreOutputLocationManager", "org.eclipse.jdt.core.JavaModelException:", "<missing>:"), 204);
        ajc$tjp_5 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "init", "org.eclipse.ajdt.internal.core.ajde.CoreOutputLocationManager", "", "", "", "void"), 134);
        ajc$tjp_6 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.core.ajde.CoreOutputLocationManager", "org.eclipse.jdt.core.JavaModelException:", "<missing>:"), 273);
        ajc$tjp_7 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "isUsingSeparateOutputFolders", "org.eclipse.ajdt.internal.core.ajde.CoreOutputLocationManager", "org.eclipse.jdt.core.IJavaProject:", "jp:", "", "boolean"), 260);
        ajc$tjp_8 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.core.ajde.CoreOutputLocationManager", "org.eclipse.jdt.core.JavaModelException:", "<missing>:"), 273);
        ajc$tjp_9 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.core.ajde.CoreOutputLocationManager", "org.eclipse.jdt.core.JavaModelException:", "<missing>:"), 287);
    }
}

