/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.core.contentassist;

import java.util.ArrayList;
import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.core.codeconversion.AspectsConvertingParser;
import org.eclipse.ajdt.core.codeconversion.ConversionOptions;
import org.eclipse.ajdt.core.codeconversion.ITDAwareNameEnvironment;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnit;
import org.eclipse.ajdt.internal.core.contentassist.ProposalRequestorWrapper;
import org.eclipse.contribution.jdt.itdawareness.IJavaContentAssistProvider;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IJavaModelStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.internal.codeassist.CompletionEngine;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.Openable;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.internal.core.SearchableEnvironment;

public class ContentAssistProvider
implements IJavaContentAssistProvider {
    public boolean doContentAssist(ICompilationUnit cu, ICompilationUnit unitToSkip, int position, CompletionRequestor requestor, WorkingCopyOwner owner, ITypeRoot typeRoot, Openable target) throws Exception {
        JavaProject project = (JavaProject)target.getJavaProject();
        if (!AspectJPlugin.isAJProject(project.getProject())) {
            return false;
        }
        if (target instanceof AJCompilationUnit) {
            return false;
        }
        if (!(target instanceof CompilationUnit)) {
            return false;
        }
        IBuffer buffer = target.getBuffer();
        if (buffer == null) {
            return false;
        }
        if (requestor == null) {
            throw new IllegalArgumentException("Completion requestor cannot be null");
        }
        MockCompilationUnit mcu = new MockCompilationUnit((CompilationUnit)target);
        requestor = new ProposalRequestorWrapper(requestor, mcu.insertionTable);
        int transformedPos = mcu.translatePositionToFake(position);
        if (transformedPos < -1 || transformedPos > mcu.getContents().length) {
            throw new JavaModelException((IJavaModelStatus)new JavaModelStatus(980));
        }
        ITDAwareNameEnvironment environment = new ITDAwareNameEnvironment(project, owner, null);
        environment.setUnitToSkip(unitToSkip);
        CompletionEngine engine = new CompletionEngine((SearchableEnvironment)environment, requestor, project.getOptions(true), (IJavaProject)project, owner);
        engine.complete((ICompilationUnit)mcu, transformedPos, 0, typeRoot);
        return true;
    }

    private static class MockCompilationUnit
    extends CompilationUnit {
        char[] transformedContents;
        CompilationUnit orig;
        ArrayList insertionTable;

        public MockCompilationUnit(CompilationUnit orig) {
            super((PackageFragment)orig.getParent(), orig.getElementName(), orig.owner);
            this.orig = orig;
            this.transformedContents = this.initContents();
        }

        private char[] initContents() {
            AspectsConvertingParser parser = new AspectsConvertingParser(this.orig.getContents());
            parser.setUnit((org.eclipse.jdt.core.ICompilationUnit)this.orig);
            this.insertionTable = parser.convert(ConversionOptions.CODE_COMPLETION);
            return parser.content;
        }

        public char[] getContents() {
            return this.transformedContents;
        }

        int translatePositionToReal(int pos) {
            return AspectsConvertingParser.translatePositionToBeforeChanges(pos, this.insertionTable);
        }

        int translatePositionToFake(int pos) {
            return AspectsConvertingParser.translatePositionToAfterChanges(pos, this.insertionTable);
        }
    }
}

