/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.editor.quickfix;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.internal.ui.editor.quickfix.AJSerialVersionSubProcessor;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jdt.ui.text.java.IQuickFixProcessor;

public class JavaQuickFixProcessor
implements IQuickFixProcessor {
    public IJavaCompletionProposal[] getCorrections(IInvocationContext context, IProblemLocation[] locations) throws CoreException {
        if (locations == null || locations.length == 0 || !this.isAJProject(context.getCompilationUnit())) {
            return null;
        }
        HashSet<Integer> handledProblems = new HashSet<Integer>(locations.length);
        ArrayList resultingCollections = new ArrayList();
        int i = 0;
        while (i < locations.length) {
            IProblemLocation curr = locations[i];
            Integer id = new Integer(curr.getProblemId());
            if (handledProblems.add(id)) {
                this.process(context, curr, resultingCollections);
            }
            ++i;
        }
        return resultingCollections.toArray(new IJavaCompletionProposal[resultingCollections.size()]);
    }

    private void process(IInvocationContext context, IProblemLocation problem, Collection proposals) throws CoreException {
        int id = problem.getProblemId();
        if (id == 0) {
            return;
        }
        switch (id) {
            case 0x20000060: {
                AJSerialVersionSubProcessor.getSerialVersionProposals(context, problem, proposals);
            }
        }
    }

    public boolean hasCorrections(ICompilationUnit unit, int problemId) {
        if (this.isAJProject(unit)) {
            switch (problemId) {
                case 0x20000060: {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isAJProject(ICompilationUnit unit) {
        return AspectJPlugin.isAJProject((IProject)unit.getJavaProject().getProject());
    }
}

