/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.markers;

import java.io.File;
import org.eclipse.ajdt.internal.ui.markers.DeleteAJMarkers;
import org.eclipse.ajdt.internal.ui.markers.UpdateAJMarkers;
import org.eclipse.core.internal.jobs.InternalJob;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

public class DeleteAndUpdateAJMarkersJob
extends Job {
    public static final Object UPDATE_DELETE_AJ_MARKERS_FAMILY = new Object();
    private DeleteAJMarkers delete;
    private UpdateAJMarkers update;
    private boolean deleteOnly = false;

    public DeleteAndUpdateAJMarkersJob(IProject project) {
        super("Delete and update AspectJ markers for " + project.getName());
        this.update = new UpdateAJMarkers(project);
        this.delete = new DeleteAJMarkers(project);
    }

    public DeleteAndUpdateAJMarkersJob(IProject project, File[] sourceFiles) {
        super("Delete and update AspectJ markers for " + project.getName());
        this.update = new UpdateAJMarkers(project, sourceFiles);
        this.delete = new DeleteAJMarkers(project, sourceFiles);
    }

    protected IStatus run(IProgressMonitor monitor) {
        MultiStatus multiStatus;
        try {
            InternalJob.manager.beginRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), monitor);
            IStatus deleteStatus = this.delete.run(monitor);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            IStatus updateStatus = !this.deleteOnly ? this.update.run(monitor) : Status.OK_STATUS;
            multiStatus = new MultiStatus("org.eclipse.ajdt.ui", Math.max(updateStatus.getCode(), deleteStatus.getCode()), new IStatus[]{deleteStatus, updateStatus}, "Finished deleting and updating markers", null);
        }
        catch (Throwable throwable) {
            try {
                InternalJob.manager.endRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
                throw throwable;
            }
            catch (OperationCanceledException operationCanceledException) {
                return Status.CANCEL_STATUS;
            }
        }
        InternalJob.manager.endRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        return multiStatus;
    }

    public void doDeleteOnly(boolean deleteOnly) {
        this.deleteOnly = deleteOnly;
    }

    public boolean belongsTo(Object family) {
        return family == UPDATE_DELETE_AJ_MARKERS_FAMILY;
    }
}

