/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.markers;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.aspectj.asm.IProgramElement;
import org.aspectj.asm.IRelationship;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.aspectj.weaver.AdviceKind;
import org.eclipse.ajdt.core.AJLog;
import org.eclipse.ajdt.core.model.AJProjectModelFacade;
import org.eclipse.ajdt.core.model.AJProjectModelFactory;
import org.eclipse.ajdt.internal.ui.markers.AJMarkersDialog;
import org.eclipse.ajdt.internal.ui.preferences.AspectJPreferences;
import org.eclipse.ajdt.internal.ui.ras.UIFFDC;
import org.eclipse.ajdt.internal.ui.text.UIMessages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class UpdateAJMarkers {
    private final AJProjectModelFacade model;
    private final IProject project;
    private final File[] sourceFiles;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_5;

    public UpdateAJMarkers(IProject project) {
        this.model = AJProjectModelFactory.getInstance().getModelForProject(project);
        this.project = project;
        this.sourceFiles = null;
    }

    public UpdateAJMarkers(IProject project, File[] sourceFiles) {
        this.model = AJProjectModelFactory.getInstance().getModelForProject(project);
        this.project = project;
        this.sourceFiles = sourceFiles;
    }

    protected IStatus run(IProgressMonitor monitor) {
        AJLog.logStart((String)("Create markers: " + this.project.getName()));
        if (this.sourceFiles != null) {
            this.addMarkersForFiles(monitor);
        } else {
            this.addMarkersForProject(monitor);
        }
        AJLog.logEnd((int)2, (String)("Create markers: " + this.project.getName()), (String)("Finished creating markers for " + this.project.getName()));
        return Status.OK_STATUS;
    }

    private void addMarkersForProject(IProgressMonitor monitor) {
        if (!this.model.hasModel()) {
            return;
        }
        try {
            IJavaProject jProject = JavaCore.create((IProject)this.project);
            IPackageFragmentRoot[] fragRoots = jProject.getPackageFragmentRoots();
            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, fragRoots.length);
            subMonitor.beginTask("Add markers for " + this.project.getName(), fragRoots.length);
            int i = 0;
            while (i < fragRoots.length) {
                if (fragRoots[i].getKind() == 1) {
                    IJavaElement[] frags = fragRoots[i].getChildren();
                    int j = 0;
                    while (j < frags.length) {
                        HashSet<String> completedCUNames = new HashSet<String>(frags.length, 1.0f);
                        IJavaElement[] cus = ((IPackageFragment)frags[j]).getChildren();
                        int k = 0;
                        while (k < cus.length) {
                            IResource resource;
                            if (cus[k].getElementType() == 5 && !completedCUNames.contains((resource = cus[k].getResource()).getName())) {
                                subMonitor.subTask("Add markers for " + cus[k].getElementName());
                                this.addMarkersForFile((ICompilationUnit)cus[k], ((ICompilationUnit)cus[k]).getResource());
                                completedCUNames.add(resource.getName());
                            }
                            ++k;
                        }
                        ++j;
                    }
                    if (subMonitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    subMonitor.worked(1);
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
        }
    }

    private void addMarkersForFiles(IProgressMonitor monitor) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, this.sourceFiles.length);
        int i = 0;
        while (i < this.sourceFiles.length) {
            IPath location = Path.fromOSString((String)this.sourceFiles[i].getAbsolutePath());
            IFile[] files = workspace.getRoot().findFilesForLocation(location);
            int j = 0;
            while (j < files.length) {
                IJavaElement unit = JavaCore.create((IFile)files[j]);
                if (unit != null && unit.exists() && unit instanceof ICompilationUnit) {
                    subMonitor.subTask("Add markers for " + unit.getElementName());
                    this.addMarkersForFile((ICompilationUnit)unit, (IResource)files[j]);
                }
                if (subMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                subMonitor.worked(1);
                ++j;
            }
            ++i;
        }
    }

    private void addMarkersForFile(ICompilationUnit cu, IResource resource) {
        Map annotationMap = this.model.getRelationshipsForFile(cu);
        for (Map.Entry entry : annotationMap.entrySet()) {
            this.createMarker(resource, (Integer)entry.getKey(), (List)entry.getValue());
        }
    }

    private void createMarker(IResource resource, int lineNumber, List relationships) {
        String markerType = null;
        boolean hasRuntime = false;
        for (IRelationship relationship : relationships) {
            hasRuntime |= relationship.hasRuntimeTest();
            String customMarkerType = this.getCustomMarker(relationship);
            if (customMarkerType != null) {
                this.createCustomMarker(resource, customMarkerType, lineNumber, relationship);
                continue;
            }
            List targets = relationship.getTargets();
            for (String target : targets) {
                String markerTypeForRelationship = this.getMarkerTypeForRelationship(relationship, target);
                if (markerType == null) {
                    markerType = markerTypeForRelationship;
                    continue;
                }
                if (markerType.equals(markerTypeForRelationship)) continue;
                markerType = this.getCombinedMarkerType(markerType, markerTypeForRelationship, hasRuntime);
            }
        }
        if (markerType != null) {
            try {
                IMarker marker = resource.createMarker(markerType);
                marker.setAttribute("lineNumber", lineNumber);
                int numTargets = this.getNumTargets(relationships);
                String label = numTargets == 1 ? this.getMarkerLabel(relationships) : this.getMultipleMarkersLabel(numTargets);
                marker.setAttribute("message", (Object)label);
                marker.setAttribute("priority", 2);
            }
            catch (CoreException coreException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, this, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_3);
            }
        }
    }

    private int getNumTargets(List relationships) {
        int numTargets = 0;
        for (IRelationship rel : relationships) {
            Iterator targetIter = rel.getTargets().iterator();
            while (targetIter.hasNext()) {
                targetIter.next();
                if (rel.getName().equals("matches declare")) continue;
                ++numTargets;
            }
        }
        return numTargets;
    }

    private void createCustomMarker(IResource resource, String customMarkerType, int lineNumber, IRelationship relationship) {
        if (!customMarkerType.equals(AJMarkersDialog.NO_MARKERS)) {
            try {
                IMarker marker = resource.createMarker("org.eclipse.ajdt.ui.customadvicemarker");
                marker.setAttribute("lineNumber", lineNumber);
                String label = this.getMarkerLabel(relationship);
                marker.setAttribute("message", (Object)label);
                marker.setAttribute("priority", 2);
                marker.setAttribute("Image_Location", (Object)customMarkerType);
            }
            catch (CoreException coreException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, this, ajc$tjp_4, (JoinPoint.StaticPart)ajc$tjp_5);
            }
        }
    }

    private String getMarkerTypeForRelationship(IRelationship relationship, String target) {
        String markerType;
        String name = relationship.getName();
        boolean runtimeTest = relationship.hasRuntimeTest();
        if (name.equals("advised by")) {
            IProgramElement advice = this.model.getProgramElement(target);
            AdviceKind ak = advice.getExtraInfo() != null ? AdviceKind.stringToKind((String)advice.getExtraInfo().getExtraAdviceInformation()) : null;
            markerType = runtimeTest ? (ak == null ? "org.eclipse.ajdt.ui.dynamicadvicemarker" : (ak == AdviceKind.Before ? "org.eclipse.ajdt.ui.dynamicbeforeadvicemarker" : (ak == AdviceKind.After || ak == AdviceKind.AfterReturning || ak == AdviceKind.AfterThrowing ? "org.eclipse.ajdt.ui.dynamicafteradvicemarker" : (ak == AdviceKind.Around ? "org.eclipse.ajdt.ui.dynamicaroundadvicemarker" : "org.eclipse.ajdt.ui.dynamicadvicemarker")))) : (ak == null ? "org.eclipse.ajdt.ui.advicemarker" : (ak == AdviceKind.Before ? "org.eclipse.ajdt.ui.beforeadvicemarker" : (ak == AdviceKind.After || ak == AdviceKind.AfterReturning || ak == AdviceKind.AfterThrowing ? "org.eclipse.ajdt.ui.afteradvicemarker" : (ak == AdviceKind.Around ? "org.eclipse.ajdt.ui.aroundadvicemarker" : "org.eclipse.ajdt.ui.advicemarker"))));
        } else if (name.equals("advises")) {
            AdviceKind ak;
            IProgramElement advice = this.model.getProgramElement(relationship.getSourceHandle());
            if (advice.getExtraInfo() != null) {
                ak = AdviceKind.stringToKind((String)advice.getExtraInfo().getExtraAdviceInformation());
            } else {
                ak = null;
                if (advice.getName().startsWith("before")) {
                    ak = AdviceKind.Before;
                } else if (advice.getName().startsWith("after")) {
                    ak = AdviceKind.After;
                } else if (advice.getName().startsWith("around")) {
                    ak = AdviceKind.Around;
                }
            }
            markerType = runtimeTest ? (ak == null ? "org.eclipse.ajdt.ui.sourcedynamicadvicemarker" : (ak == AdviceKind.Before ? "org.eclipse.ajdt.ui.sourcedynamicbeforeadvicemarker" : (ak == AdviceKind.After || ak == AdviceKind.AfterReturning || ak == AdviceKind.AfterThrowing ? "org.eclipse.ajdt.ui.sourcedynamicafteradvicemarker" : (ak == AdviceKind.Around ? "org.eclipse.ajdt.ui.sourcedynamicaroundadvicemarker" : "org.eclipse.ajdt.ui.sourcedynamicadvicemarker")))) : (ak == null ? "org.eclipse.ajdt.ui.sourceadvicemarker" : (ak == AdviceKind.Before ? "org.eclipse.ajdt.ui.sourcebeforeadvicemarker" : (ak == AdviceKind.After || ak == AdviceKind.AfterReturning || ak == AdviceKind.AfterThrowing ? "org.eclipse.ajdt.ui.sourceafteradvicemarker" : (ak == AdviceKind.Around ? "org.eclipse.ajdt.ui.sourcearoundadvicemarker" : "org.eclipse.ajdt.ui.sourceadvicemarker"))));
        } else {
            markerType = name.equals("annotated by") || name.equals("softened by") || name.equals("aspect declarations") ? "org.eclipse.ajdt.ui.itdmarker" : (name.equals("annotates") || name.equals("declared on") || name.equals("softens") || name.equals("matched by") ? "org.eclipse.ajdt.ui.sourceitdmarker" : null);
        }
        return markerType;
    }

    private String getMultipleMarkersLabel(int number) {
        return String.valueOf(number) + " " + UIMessages.AspectJMarkersAtLine;
    }

    private String getMarkerLabel(List relationships) {
        for (IRelationship rel : relationships) {
            if (rel.getName().equals("matches declare")) continue;
            return this.getMarkerLabel(rel);
        }
        return "<none>";
    }

    private String getMarkerLabel(IRelationship relationship) {
        IProgramElement target = this.model.getProgramElement((String)relationship.getTargets().get(0));
        return String.valueOf(relationship.getName()) + " " + (target != null ? target.toLinkLabelString(false) : "null") + (relationship.hasRuntimeTest() ? " " + UIMessages.AspectJEditor_runtimetest : "");
    }

    private String getCustomMarker(IRelationship relationship) {
        ArrayList<IJavaElement> aspectEntities = new ArrayList<IJavaElement>();
        if (relationship.isAffects()) {
            aspectEntities.add(this.model.programElementToJavaElement(relationship.getSourceHandle()));
        } else {
            for (String target : relationship.getTargets()) {
                aspectEntities.add(this.model.programElementToJavaElement(target));
            }
        }
        for (IJavaElement elt : aspectEntities) {
            String customImage;
            IType typeElement;
            if (elt == null || (typeElement = (IType)elt.getAncestor(7)) == null || (customImage = AspectJPreferences.getSavedIcon(typeElement.getJavaProject().getProject(), AJMarkersDialog.getFullyQualifiedAspectName(typeElement))) == null) continue;
            return customImage;
        }
        return null;
    }

    private String getCombinedMarkerType(String firstMarkerType, String secondMarkerType, boolean runtimeTest) {
        if (firstMarkerType.indexOf("source") != -1 && secondMarkerType.indexOf("source") != -1) {
            if (firstMarkerType.indexOf("around") != -1 || secondMarkerType.indexOf("around") != -1) {
                return runtimeTest ? "org.eclipse.ajdt.ui.sourcedynamicaroundadvicemarker" : "org.eclipse.ajdt.ui.sourcearoundadvicemarker";
            }
            return runtimeTest ? "org.eclipse.ajdt.ui.sourcedynamicadvicemarker" : "org.eclipse.ajdt.ui.sourceadvicemarker";
        }
        if (firstMarkerType.indexOf("source") != -1 || secondMarkerType.indexOf("source") != -1) {
            return runtimeTest ? "org.eclipse.ajdt.ui.dynamicsourceandtargetmarker" : "org.eclipse.ajdt.ui.sourceandtargetmarker";
        }
        if (firstMarkerType.indexOf("around") != -1 || secondMarkerType.indexOf("around") != -1) {
            return runtimeTest ? "org.eclipse.ajdt.ui.dynamicaroundadvicemarker" : "org.eclipse.ajdt.ui.aroundadvicemarker";
        }
        return runtimeTest ? "org.eclipse.ajdt.ui.dynamicadvicemarker" : "org.eclipse.ajdt.ui.advicemarker";
    }

    static {
        Factory factory = new Factory("UpdateAJMarkers.java", Class.forName("org.eclipse.ajdt.internal.ui.markers.UpdateAJMarkers"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.markers.UpdateAJMarkers", "org.eclipse.jdt.core.JavaModelException:", "<missing>:"), 139);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "addMarkersForProject", "org.eclipse.ajdt.internal.ui.markers.UpdateAJMarkers", "org.eclipse.core.runtime.IProgressMonitor:", "monitor:", "", "void"), 105);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.markers.UpdateAJMarkers", "org.eclipse.core.runtime.CoreException:", "<missing>:"), 221);
        ajc$tjp_3 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "createMarker", "org.eclipse.ajdt.internal.ui.markers.UpdateAJMarkers", "org.eclipse.core.resources.IResource:int:java.util.List:", "resource:lineNumber:relationships:", "", "void"), 177);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.markers.UpdateAJMarkers", "org.eclipse.core.runtime.CoreException:", "<missing>:"), 256);
        ajc$tjp_5 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "createCustomMarker", "org.eclipse.ajdt.internal.ui.markers.UpdateAJMarkers", "org.eclipse.core.resources.IResource:java.lang.String:int:org.aspectj.asm.IRelationship:", "resource:customMarkerType:lineNumber:relationship:", "", "void"), 241);
    }
}

