/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.wizards.exports;

import org.eclipse.ajdt.internal.ui.wizards.exports.AbstractExportWizardPage;
import org.eclipse.ajdt.internal.ui.wizards.exports.ProductConfigurationSection;
import org.eclipse.ajdt.internal.ui.wizards.exports.ProductDestinationGroup;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class ProductExportWizardPage
extends AbstractExportWizardPage {
    private static final String S_SYNC_PRODUCT = "syncProduct";
    private static final String S_EXPORT_SOURCE = "exportSource";
    private static final String S_MULTI_PLATFORM = "multiplatform";
    private static final String S_EXPORT_METADATA = "p2metadata";
    private Button fSyncButton;
    private IStructuredSelection fSelection;
    private ProductDestinationGroup fExportGroup;
    private ProductConfigurationSection fConfigurationGroup;
    private Button fExportSource;
    private Button fMultiPlatform;
    private Button fExportMetadata;

    public ProductExportWizardPage(IStructuredSelection selection) {
        super("productExport");
        this.fSelection = selection;
        this.setTitle(PDEUIMessages.ProductExportWizardPage_title);
        this.setDescription(PDEUIMessages.ProductExportWizardPage_desc);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 10;
        container.setLayout((Layout)layout);
        this.createConfigurationSection(container);
        this.createSynchronizationSection(container);
        this.createDestinationSection(container);
        this.createOptionsSection(container);
        this.initialize();
        this.pageChanged();
        if (this.getErrorMessage() != null) {
            this.setMessage(this.getErrorMessage());
            this.setErrorMessage(null);
        }
        this.setControl((Control)container);
        this.hookHelpContext((Control)container);
        Dialog.applyDialogFont((Control)container);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)container, "org.eclipse.pde.doc.user.product_export_wizard");
    }

    private void createConfigurationSection(Composite parent) {
        this.fConfigurationGroup = new ProductConfigurationSection(this);
        this.fConfigurationGroup.createControl(parent);
    }

    private void createSynchronizationSection(Composite parent) {
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 7;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        group.setText(PDEUIMessages.ProductExportWizardPage_sync);
        Label label = new Label((Composite)group, 64);
        label.setText(PDEUIMessages.ProductExportWizardPage_syncText);
        GridData gd = new GridData(768);
        gd.widthHint = 400;
        label.setLayoutData((Object)gd);
        this.fSyncButton = new Button((Composite)group, 32);
        this.fSyncButton.setText(PDEUIMessages.ProductExportWizardPage_syncButton);
        gd = new GridData();
        gd.horizontalIndent = 20;
        this.fSyncButton.setLayoutData((Object)gd);
    }

    private void createDestinationSection(Composite container) {
        this.fExportGroup = new ProductDestinationGroup(this);
        this.fExportGroup.createControl(container);
    }

    private void createOptionsSection(Composite container) {
        Group group = new Group(container, 0);
        group.setText(PDEUIMessages.ProductExportWizardPage_exportOptionsGroup);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(768));
        this.fExportSource = new Button((Composite)group, 32);
        this.fExportSource.setText(PDEUIMessages.ExportWizard_includeSource);
        this.fExportMetadata = new Button((Composite)group, 32);
        this.fExportMetadata.setText(PDEUIMessages.ExportWizard_includesMetadata);
        if (this.getWizard().getPages().length > 1) {
            this.fMultiPlatform = new Button((Composite)group, 32);
            this.fMultiPlatform.setText(PDEUIMessages.ExportWizard_multi_platform);
            this.fMultiPlatform.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ProductExportWizardPage.this.getContainer().updateButtons();
                }
            });
        }
    }

    protected void initialize() {
        IDialogSettings settings = this.getDialogSettings();
        this.fConfigurationGroup.initialize(this.fSelection, settings);
        String value = settings.get(S_SYNC_PRODUCT);
        this.fSyncButton.setSelection(value == null ? true : settings.getBoolean(S_SYNC_PRODUCT));
        this.fExportGroup.initialize(settings, this.fConfigurationGroup.getProductFile());
        this.fExportSource.setSelection(settings.getBoolean(S_EXPORT_SOURCE));
        this.fExportMetadata.setSelection(settings.getBoolean(S_EXPORT_METADATA));
        if (this.fMultiPlatform != null) {
            this.fMultiPlatform.setSelection(settings.getBoolean(S_MULTI_PLATFORM));
        }
    }

    protected void updateProductFields() {
        this.fExportGroup.updateDestination(this.fConfigurationGroup.getProductFile());
    }

    protected void pageChanged() {
        String error = this.fConfigurationGroup.validate();
        if (error == null) {
            error = this.fExportGroup.validate();
        }
        this.setErrorMessage(error);
        this.setPageComplete(error == null);
    }

    public IWizardPage getNextPage() {
        return this.doMultiPlatform() ? this.getWizard().getNextPage((IWizardPage)this) : null;
    }

    protected void hookHelpContext(Control control) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp(control, "org.eclipse.pde.doc.user.product_export_wizard");
    }

    protected void saveSettings(IDialogSettings settings) {
        this.fConfigurationGroup.saveSettings(settings);
        settings.put(S_SYNC_PRODUCT, this.fSyncButton.getSelection());
        this.fExportGroup.saveSettings(settings);
        settings.put(S_EXPORT_SOURCE, this.doExportSource());
        settings.put(S_EXPORT_METADATA, this.doExportMetadata());
        if (this.fMultiPlatform != null) {
            settings.put(S_MULTI_PLATFORM, this.fMultiPlatform.getSelection());
        }
    }

    protected boolean doSync() {
        return this.fSyncButton.getSelection();
    }

    protected boolean doMultiPlatform() {
        return this.fMultiPlatform != null && this.fMultiPlatform.getSelection();
    }

    protected boolean doExportSource() {
        return this.fExportSource.getSelection();
    }

    protected boolean doExportMetadata() {
        return this.fExportMetadata.getSelection();
    }

    protected boolean doExportToDirectory() {
        return this.fExportGroup.doExportToDirectory();
    }

    protected String getFileName() {
        return this.fExportGroup.getFileName();
    }

    protected String getDestination() {
        return this.fExportGroup.getDestination();
    }

    protected String getRootDirectory() {
        return this.fConfigurationGroup.getRootDirectory();
    }

    protected IFile getProductFile() {
        return this.fConfigurationGroup.getProductFile();
    }
}

