/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.jdt.preferences;

import org.eclipse.contribution.jdt.JDTWeavingPlugin;
import org.eclipse.contribution.jdt.preferences.JDTWeavingPreferencePage;
import org.eclipse.contribution.jdt.preferences.JDTWeavingPreferences;
import org.eclipse.contribution.jdt.preferences.WeavingStateConfigurer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;

public class WeavingStateConfigurerUI {
    private WeavingStateConfigurer configurer;
    private Shell shell;

    public WeavingStateConfigurerUI() {
        this(WeavingStateConfigurerUI.getShell());
    }

    public WeavingStateConfigurerUI(Shell shell) {
        this(shell, new WeavingStateConfigurer());
    }

    public WeavingStateConfigurerUI(Shell shell, WeavingStateConfigurer configurer) {
        this.configurer = configurer;
        this.shell = shell;
    }

    private void changeWeavingState() {
        JDTWeavingPreferences.setAskToEnableWeaving(true);
        IStatus changeResult = this.configurer.changeWeavingState(!this.configurer.isWeaving());
        if (changeResult.getSeverity() == 0) {
            try {
                if (this.configurer.currentConfigStateIsWeaving() != this.configurer.isWeaving()) {
                    JDTWeavingPlugin.getInstance().getLog().log(changeResult);
                    boolean doRestart = MessageDialog.openQuestion((Shell)this.shell, (String)"Restart", (String)("Weaving will be " + (this.configurer.isWeaving() ? "DISABLED" : "ENABLED") + " after restarting the workbench.\n\n" + "Do you want to restart now?"));
                    if (doRestart) {
                        PlatformUI.getWorkbench().restart();
                    }
                    return;
                }
                changeResult = new Status(4, JDTWeavingPlugin.ID, "Could not change weaving state");
            }
            catch (Exception e) {
                changeResult = new Status(4, JDTWeavingPlugin.ID, "Could not change weaving state", (Throwable)e);
            }
        }
        JDTWeavingPlugin.getInstance().getLog().log(changeResult);
        this.getFailureDialog(changeResult);
    }

    public boolean ask() {
        EnableWeavingDialog dialog = new EnableWeavingDialog();
        dialog.open();
        JDTWeavingPreferences.setAskToEnableWeaving(!dialog.getToggleState());
        if (2 == dialog.getReturnCode()) {
            this.changeWeavingState();
            return true;
        }
        return false;
    }

    public void askFromPreferences() {
        String areYouSure = "Are you sure that you want to " + (this.configurer.isWeaving() ? "DISABLE" : "ENABLE") + " JDT Weaving?";
        boolean result = MessageDialog.openQuestion((Shell)this.shell, (String)"Enable/disable JDT Weaving", (String)areYouSure);
        if (result) {
            this.changeWeavingState();
        }
    }

    private void getFailureDialog(IStatus changeResult) {
        String changeInstructions = "\n\nTo change manually:\n\t1. open up the file configuration/config.ini in your eclipse installation folder\n\t2. " + (this.configurer.isWeaving() ? "remove" : "add") + " the line osgi.framework.extensions=org.eclipse.equinox.weaving.hook\n\t" + (this.configurer.isWeaving() ? "3. if multiple extensions exist, only remove the org.eclipse.equinox.weaving.hook extension" : "3. if osgi.framework.extensions line already exists, then append ',org.eclipse.equinox.weaving.hook'");
        ErrorDialog.openError((Shell)this.shell, (String)"Error", (String)("Could not " + (this.configurer.isWeaving() ? "DISABLE" : "ENABLE") + " JDT Weaving" + changeInstructions), (IStatus)changeResult);
    }

    public static Shell getShell() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            if (windows.length > 0) {
                return windows[0].getShell();
            }
        } else {
            return window.getShell();
        }
        return null;
    }

    private class EnableWeavingDialog
    extends MessageDialogWithToggle {
        private static final String MESSAGE = "Should AJDT's weaving service be enabled?  (Requires restart)<br/><br/>The weaving service enables the more advanced AJDT and AspectJ, but may require more resources to run Eclipse.";
        private static final String EXPANDED_MESSAGE = "The weaving service enables advanced AJDT features such as content assist and searching.  <br/><br/>AspectJ projects will still have basic functionality even with weaving disabled.  If you encounter any sluggishness or memory problems, it is recommended that you increase your Xmx and PermGen sizes to at least 512 and 128 respectively.<br/><br/>Alternatively, the weaving service can be enabled or disabled from the JDT Weaving preferences page.<br/><br/>More information: http://wiki.eclipse.org/JDT_weaving_features";

        public EnableWeavingDialog() {
            super(WeavingStateConfigurerUI.getShell(), "Turn Weaving Service on?", null, "<form>Should AJDT's weaving service be enabled?  (Requires restart)<br/><br/>The weaving service enables the more advanced AJDT and AspectJ, but may require more resources to run Eclipse.\n\nThe weaving service enables advanced AJDT features such as content assist and searching.  <br/><br/>AspectJ projects will still have basic functionality even with weaving disabled.  If you encounter any sluggishness or memory problems, it is recommended that you increase your Xmx and PermGen sizes to at least 512 and 128 respectively.<br/><br/>Alternatively, the weaving service can be enabled or disabled from the JDT Weaving preferences page.<br/><br/>More information: http://wiki.eclipse.org/JDT_weaving_features</form>", 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0, "Don't ask again until next upgrade", false);
        }

        protected Control createMessageArea(Composite composite) {
            Image image = this.getImage();
            if (image != null) {
                this.imageLabel = new Label(composite, 0);
                image.setBackground(this.imageLabel.getBackground());
                this.imageLabel.setImage(image);
                GridDataFactory.fillDefaults().align(0x1000000, 1).applyTo((Control)this.imageLabel);
            }
            if (this.message != null) {
                FormText text = new FormText(composite, this.getMessageLabelStyle());
                text.setText(this.message, true, true);
                GridDataFactory.fillDefaults().align(4, 1).grab(true, false).hint(this.convertHorizontalDLUsToPixels(300), -1).applyTo((Control)text);
                text.addHyperlinkListener(new IHyperlinkListener(){

                    public void linkActivated(HyperlinkEvent e) {
                        if (e.data instanceof String) {
                            JDTWeavingPreferencePage.openUrl((String)e.data);
                        }
                    }

                    public void linkEntered(HyperlinkEvent e) {
                    }

                    public void linkExited(HyperlinkEvent e) {
                    }
                });
            }
            return composite;
        }
    }
}

