/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.weaving.aspectj;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.aspectj.weaver.loadtime.definition.Definition;
import org.eclipse.equinox.service.weaving.ISupplementerRegistry;
import org.eclipse.equinox.service.weaving.IWeavingService;
import org.eclipse.equinox.weaving.aspectj.WeavingServicePlugin;
import org.eclipse.equinox.weaving.aspectj.loadtime.OSGiWeavingAdaptor;
import org.eclipse.equinox.weaving.aspectj.loadtime.OSGiWeavingContext;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.State;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeavingService
implements IWeavingService {
    private List<Definition> aspectDefinitions;
    private Bundle bundle;
    private BundleDescription bundleDescription;
    private boolean enabled;
    private ClassLoader loader;
    private StringBuffer namespaceAddOn;
    private State resolverState;
    private ISupplementerRegistry supplementerRegistry;
    private OSGiWeavingAdaptor weavingAdaptor;
    private OSGiWeavingContext weavingContext;

    public WeavingService() {
        if (WeavingServicePlugin.DEBUG) {
            System.out.println("- WeavingService.<init>");
        }
    }

    public WeavingService(ClassLoader classLoader, Bundle bundle, State state, BundleDescription bundleDescription, ISupplementerRegistry iSupplementerRegistry) {
        this.bundle = bundle;
        this.resolverState = state;
        this.supplementerRegistry = iSupplementerRegistry;
        this.namespaceAddOn = new StringBuffer();
        this.loader = classLoader;
        this.bundleDescription = bundleDescription;
        this.aspectDefinitions = this.parseDefinitionsForBundle();
        boolean bl = this.enabled = this.aspectDefinitions.size() > 0;
        if (this.enabled) {
            this.weavingContext = new OSGiWeavingContext(classLoader, bundleDescription, this.aspectDefinitions);
            this.weavingAdaptor = new OSGiWeavingAdaptor(classLoader, this.weavingContext, this.namespaceAddOn.toString());
        } else if (WeavingServicePlugin.DEBUG) {
            System.err.println("[org.eclipse.equinox.weaving.aspectj] info not weaving bundle '" + bundle.getSymbolicName() + "'");
        }
    }

    public void flushGeneratedClasses(ClassLoader classLoader) {
        if (this.enabled) {
            this.ensureAdaptorInit();
            this.weavingAdaptor.flushGeneratedClasses();
        }
    }

    public boolean generatedClassesExistFor(ClassLoader classLoader, String string) {
        if (this.enabled) {
            this.ensureAdaptorInit();
            return this.weavingAdaptor.generatedClassesExistFor(string);
        }
        return false;
    }

    public String getBundleVersion(Bundle bundle) {
        return this.resolverState.getBundle(bundle.getBundleId()).getVersion().toString();
    }

    public String getKey() {
        if (WeavingServicePlugin.DEBUG) {
            System.out.println("> WeavingService.getKey() bundle=" + this.bundleDescription.getSymbolicName());
        }
        String string = this.namespaceAddOn.toString();
        if (WeavingServicePlugin.DEBUG) {
            System.out.println("< WeavingService.getKey() key='" + string + "'");
        }
        return string;
    }

    public byte[] preProcess(String string, byte[] byArray, ClassLoader classLoader) throws IOException {
        if (this.enabled) {
            if (WeavingServicePlugin.DEBUG) {
                System.out.println("> WeavingService.preProcess() bundle=" + this.bundleDescription.getSymbolicName() + ", name=" + string + ", bytes=" + byArray.length);
            }
            this.ensureAdaptorInit();
            byte[] byArray2 = this.weavingAdaptor.weaveClass(string, byArray, false);
            if (WeavingServicePlugin.DEBUG) {
                System.out.println("< WeavingService.preProcess() bytes=" + byArray2.length);
            }
            return byArray2;
        }
        return null;
    }

    protected Bundle[] getBundles() {
        BundleDescription[] bundleDescriptionArray;
        BundleContext bundleContext;
        HashSet<Bundle> hashSet = new HashSet<Bundle>();
        hashSet.add(this.bundle);
        BundleContext bundleContext2 = bundleContext = WeavingServicePlugin.getDefault() != null ? WeavingServicePlugin.getDefault().getContext() : null;
        if (bundleContext != null) {
            bundleDescriptionArray = this.bundleDescription.getResolvedRequires();
            int n = 0;
            while (n < bundleDescriptionArray.length) {
                Bundle bundle = bundleContext.getBundle(bundleDescriptionArray[n].getBundleId());
                if (bundle != null) {
                    hashSet.add(bundle);
                }
                ++n;
            }
            BundleDescription[] bundleDescriptionArray2 = this.bundleDescription.getFragments();
            int n2 = 0;
            while (n2 < bundleDescriptionArray2.length) {
                Bundle bundle = bundleContext.getBundle(bundleDescriptionArray2[n2].getBundleId());
                if (bundle != null) {
                    hashSet.add(bundle);
                }
                ++n2;
            }
        }
        bundleDescriptionArray = this.supplementerRegistry.getSupplementers(this.bundleDescription.getBundleId());
        hashSet.addAll((Collection)Arrays.asList(bundleDescriptionArray));
        return hashSet.toArray(new Bundle[hashSet.size()]);
    }

    private void addToNamespaceAddon(Bundle bundle) {
        this.namespaceAddOn.append(bundle.getSymbolicName());
        this.namespaceAddOn.append(":");
        this.namespaceAddOn.append(this.getBundleVersion(bundle));
        this.namespaceAddOn.append(";");
    }

    private void ensureAdaptorInit() {
        this.weavingAdaptor.initialize();
    }

    private void parseDefinitionFromRequiredBundle(Bundle bundle, List<Definition> list) {
        try {
            Definition definition = WeavingServicePlugin.getDefault().getAspectDefinitionRegistry().getAspectDefinition(bundle);
            if (definition != null) {
                list.add(definition);
                this.addToNamespaceAddon(bundle);
            }
        }
        catch (Exception exception) {}
    }

    private List<Definition> parseDefinitionsForBundle() {
        ArrayList<Definition> arrayList = new ArrayList<Definition>();
        try {
            this.parseDefinitionsFromRequiredBundles(arrayList);
        }
        catch (Exception exception) {
            arrayList.clear();
        }
        return arrayList;
    }

    private void parseDefinitionsFromRequiredBundles(List<Definition> list) {
        Bundle[] bundleArray = this.getBundles();
        Arrays.sort(bundleArray, new Comparator(){

            public int compare(Object object, Object object2) {
                long l = ((Bundle)object).getBundleId();
                long l2 = ((Bundle)object2).getBundleId();
                return (int)(l - l2);
            }
        });
        int n = 0;
        while (n < bundleArray.length) {
            this.parseDefinitionFromRequiredBundle(bundleArray[n], list);
            ++n;
        }
    }
}

