/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.weaving.hooks;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.equinox.weaving.adaptors.IAspectJAdaptor;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;

public class AspectJBundleEntry
extends BundleEntry {
    private final IAspectJAdaptor adaptor;
    private final URL bundleFileURL;
    private byte[] bytes;
    private final BundleEntry delegate;
    private final boolean dontWeave;
    private String name;

    public AspectJBundleEntry(IAspectJAdaptor iAspectJAdaptor, BundleEntry bundleEntry, String string, byte[] byArray, URL uRL) {
        this(iAspectJAdaptor, bundleEntry, uRL, true);
        this.name = string;
        this.bytes = byArray;
    }

    public AspectJBundleEntry(IAspectJAdaptor iAspectJAdaptor, BundleEntry bundleEntry, URL uRL, boolean bl) {
        this.adaptor = iAspectJAdaptor;
        this.bundleFileURL = uRL;
        this.delegate = bundleEntry;
        this.dontWeave = bl;
    }

    public boolean dontWeave() {
        return this.dontWeave;
    }

    public IAspectJAdaptor getAdaptor() {
        return this.adaptor;
    }

    public URL getBundleFileURL() {
        return this.bundleFileURL;
    }

    public byte[] getBytes() throws IOException {
        if (this.bytes == null) {
            return this.delegate.getBytes();
        }
        return this.bytes;
    }

    public URL getFileURL() {
        if (this.bytes == null) {
            return this.delegate.getFileURL();
        }
        return null;
    }

    public InputStream getInputStream() throws IOException {
        return this.delegate.getInputStream();
    }

    public URL getLocalURL() {
        if (this.bytes == null) {
            return this.delegate.getLocalURL();
        }
        return null;
    }

    public String getName() {
        if (this.bytes == null) {
            return this.delegate.getName();
        }
        return this.name;
    }

    public long getSize() {
        if (this.delegate != null) {
            return this.delegate.getSize();
        }
        return this.bytes.length;
    }

    public long getTime() {
        if (this.delegate != null) {
            return this.delegate.getTime();
        }
        return 0L;
    }
}

