/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.weaving.hooks;

import java.io.IOException;
import java.net.URL;
import org.eclipse.equinox.service.weaving.CacheEntry;
import org.eclipse.equinox.weaving.adaptors.Debug;
import org.eclipse.equinox.weaving.adaptors.IAspectJAdaptor;
import org.eclipse.equinox.weaving.hooks.AbstractAJBundleFile;
import org.eclipse.equinox.weaving.hooks.AspectJBundleEntry;
import org.eclipse.equinox.weaving.hooks.BundleAdaptorProvider;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;

public class AspectJBundleFile
extends AbstractAJBundleFile {
    private final URL url;

    public AspectJBundleFile(BundleAdaptorProvider bundleAdaptorProvider, BundleFile bundleFile) throws IOException {
        super(bundleAdaptorProvider, bundleFile);
        this.url = this.delegate.getBaseFile().toURL();
    }

    public BundleEntry getEntry(String string) {
        if (Debug.DEBUG_BUNDLE) {
            Debug.println("> AspectJBundleFile.getEntry() path=" + string + ", url=" + this.url);
        }
        BundleEntry bundleEntry = this.delegate.getEntry(string);
        if (string.endsWith(".class")) {
            int n = string.lastIndexOf(46);
            String string2 = string.substring(0, n).replace('/', '.');
            IAspectJAdaptor iAspectJAdaptor = this.getAdaptor();
            if (iAspectJAdaptor != null) {
                CacheEntry cacheEntry = iAspectJAdaptor.findClass(string2, this.url);
                if (cacheEntry == null) {
                    if (bundleEntry != null) {
                        bundleEntry = new AspectJBundleEntry(iAspectJAdaptor, bundleEntry, this.url, false);
                        if (Debug.DEBUG_BUNDLE) {
                            Debug.println("- AspectJBundleFile.getEntry() path=" + string + ", entry=" + bundleEntry);
                        }
                    }
                } else if (cacheEntry.getCachedBytes() != null) {
                    bundleEntry = new AspectJBundleEntry(iAspectJAdaptor, bundleEntry, string, cacheEntry.getCachedBytes(), this.url);
                } else if (bundleEntry != null) {
                    bundleEntry = new AspectJBundleEntry(iAspectJAdaptor, bundleEntry, this.url, cacheEntry.dontWeave());
                }
            }
        }
        if (Debug.DEBUG_BUNDLE) {
            Debug.println("< AspectJBundleFile.getEntry() entry=" + bundleEntry);
        }
        return bundleEntry;
    }

    public URL getURL() {
        return this.url;
    }
}

