/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.weaving.hooks;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.equinox.service.weaving.ISupplementerRegistry;
import org.eclipse.equinox.weaving.adaptors.AspectJAdaptor;
import org.eclipse.equinox.weaving.adaptors.AspectJAdaptorFactory;
import org.eclipse.equinox.weaving.adaptors.Debug;
import org.eclipse.equinox.weaving.adaptors.IAspectJAdaptor;
import org.eclipse.equinox.weaving.hooks.AbstractAspectJHook;
import org.eclipse.equinox.weaving.hooks.AspectJBundleEntry;
import org.eclipse.equinox.weaving.hooks.AspectJBundleFile;
import org.eclipse.equinox.weaving.hooks.BaseAjBundleFile;
import org.eclipse.equinox.weaving.hooks.BundleAdaptorProvider;
import org.eclipse.equinox.weaving.hooks.SupplementBundleListener;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.baseadaptor.loader.BaseClassLoader;
import org.eclipse.osgi.baseadaptor.loader.ClasspathEntry;
import org.eclipse.osgi.baseadaptor.loader.ClasspathManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

public class AspectJHook
extends AbstractAspectJHook {
    private final AspectJAdaptorFactory adaptorFactory;
    private final Map<Long, IAspectJAdaptor> adaptors;
    private BundleContext bundleContext;

    public AspectJHook() {
        if (Debug.DEBUG_GENERAL) {
            Debug.println("- AspectJHook.<init>()");
        }
        this.adaptorFactory = new AspectJAdaptorFactory();
        this.adaptors = new HashMap<Long, IAspectJAdaptor>();
    }

    public void frameworkStart(BundleContext bundleContext) throws BundleException {
        this.initialize(bundleContext);
    }

    public void frameworkStop(BundleContext bundleContext) throws BundleException {
        this.adaptorFactory.dispose(bundleContext);
    }

    public IAspectJAdaptor getAdaptor(long l) {
        return this.adaptors.get(l);
    }

    public IAspectJAdaptor getHostBundleAdaptor(long l) {
        Bundle bundle;
        Bundle bundle2 = this.bundleContext.getBundle(l);
        if (bundle2 != null && (bundle = this.adaptorFactory.getHost(bundle2)) != null) {
            long l2 = bundle.getBundleId();
            return this.adaptors.get(l2);
        }
        return null;
    }

    public void initializedClassLoader(BaseClassLoader baseClassLoader, BaseData baseData) {
        if (Debug.DEBUG_GENERAL) {
            Debug.println("> AspectJHook.initializedClassLoader() bundle=" + baseData.getSymbolicName() + ", loader=" + baseClassLoader + ", data=" + baseData + ", bundleFile=" + baseData.getBundleFile());
        }
        IAspectJAdaptor iAspectJAdaptor = this.createAspectJAdaptor(baseData);
        iAspectJAdaptor.setBaseClassLoader(baseClassLoader);
        iAspectJAdaptor.initialize();
        this.adaptors.put(baseData.getBundleID(), iAspectJAdaptor);
        if (Debug.DEBUG_GENERAL) {
            Debug.println("< AspectJHook.initializedClassLoader() adaptor=" + iAspectJAdaptor);
        }
    }

    public byte[] processClass(String string, byte[] byArray, ClasspathEntry classpathEntry, BundleEntry bundleEntry, ClasspathManager classpathManager) {
        AspectJBundleEntry aspectJBundleEntry;
        byte[] byArray2 = null;
        if (bundleEntry instanceof AspectJBundleEntry && !(aspectJBundleEntry = (AspectJBundleEntry)bundleEntry).dontWeave()) {
            IAspectJAdaptor iAspectJAdaptor = aspectJBundleEntry.getAdaptor();
            byArray2 = iAspectJAdaptor.weaveClass(string, byArray);
        }
        return byArray2;
    }

    public void recordClassDefine(String string, Class clazz, byte[] byArray, ClasspathEntry classpathEntry, BundleEntry bundleEntry, ClasspathManager classpathManager) {
        AspectJBundleEntry aspectJBundleEntry;
        if (bundleEntry instanceof AspectJBundleEntry && !(aspectJBundleEntry = (AspectJBundleEntry)bundleEntry).dontWeave()) {
            IAspectJAdaptor iAspectJAdaptor = aspectJBundleEntry.getAdaptor();
            URL uRL = aspectJBundleEntry.getBundleFileURL();
            iAspectJAdaptor.storeClass(string, uRL, clazz, byArray);
        }
    }

    public BundleFile wrapBundleFile(BundleFile bundleFile, Object object, BaseData baseData, boolean bl) throws IOException {
        AspectJBundleFile aspectJBundleFile = null;
        if (Debug.DEBUG_BUNDLE) {
            Debug.println("> AspectJBundleFileWrapperFactoryHook.wrapBundleFile() bundle=" + baseData.getSymbolicName() + " bundleFile=" + bundleFile + ", content=" + object + ", data=" + baseData + ", base=" + bl + ", baseFile=" + bundleFile.getBaseFile());
        }
        aspectJBundleFile = bl ? new BaseAjBundleFile(new BundleAdaptorProvider(baseData, this), bundleFile) : new AspectJBundleFile(new BundleAdaptorProvider(baseData, this), bundleFile);
        if (Debug.DEBUG_BUNDLE) {
            Debug.println("< AspectJBundleFileWrapperFactoryHook.wrapBundleFile() wrapped=" + (Object)((Object)aspectJBundleFile));
        }
        return aspectJBundleFile;
    }

    private IAspectJAdaptor createAspectJAdaptor(BaseData baseData) {
        if (Debug.DEBUG_GENERAL) {
            Debug.println("> AspectJHook.createAspectJAdaptor() location=" + baseData.getLocation());
        }
        AspectJAdaptor aspectJAdaptor = null;
        if (this.adaptorFactory != null) {
            aspectJAdaptor = new AspectJAdaptor(baseData, this.adaptorFactory, null, null, null);
        } else if (Debug.DEBUG_GENERAL) {
            Debug.println("- AspectJHook.createAspectJAdaptor() factory=" + this.adaptorFactory);
        }
        if (Debug.DEBUG_GENERAL) {
            Debug.println("< AspectJHook.createAspectJAdaptor() adaptor=" + aspectJAdaptor);
        }
        return aspectJAdaptor;
    }

    private IAspectJAdaptor getAspectJAdaptor(BaseData baseData) {
        return this.getAdaptor(baseData.getBundleID());
    }

    private void initialize(BundleContext bundleContext) {
        if (Debug.DEBUG_GENERAL) {
            Debug.println("> AspectJHook.initialize() context=" + bundleContext);
        }
        this.bundleContext = bundleContext;
        ISupplementerRegistry iSupplementerRegistry = this.getSupplementerRegistry();
        this.adaptorFactory.initialize(bundleContext, iSupplementerRegistry);
        ServiceReference serviceReference = bundleContext.getServiceReference(PackageAdmin.class.getName());
        PackageAdmin packageAdmin = (PackageAdmin)bundleContext.getService(serviceReference);
        iSupplementerRegistry.setBundleContext(bundleContext);
        iSupplementerRegistry.setPackageAdmin(packageAdmin);
        bundleContext.addBundleListener((BundleListener)new SupplementBundleListener(iSupplementerRegistry));
        Bundle[] bundleArray = bundleContext.getBundles();
        int n = 0;
        while (n < bundleArray.length) {
            iSupplementerRegistry.addSupplementer(bundleArray[n], false);
            ++n;
        }
        n = 0;
        while (n < bundleArray.length) {
            iSupplementerRegistry.addSupplementedBundle(bundleArray[n]);
            ++n;
        }
        if (Debug.DEBUG_GENERAL) {
            Debug.println("< AspectJHook.initialize() adaptorFactory=" + this.adaptorFactory);
        }
    }
}

