/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.tracing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.eclipse.ajdt.internal.ui.help.AspectJUIHelp;
import org.eclipse.ajdt.internal.ui.preferences.AspectJPreferences;
import org.eclipse.ajdt.internal.ui.text.UIMessages;
import org.eclipse.ajdt.internal.ui.tracing.ClearEventTraceAction;
import org.eclipse.ajdt.internal.ui.tracing.DebugTracing;
import org.eclipse.ajdt.internal.ui.tracing.EventTrace;
import org.eclipse.ajdt.internal.ui.tracing.FilterTraceAction;
import org.eclipse.ajdt.internal.ui.tracing.PrintCrossCuttingModelAction;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.help.IContextProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;

public class EventTraceView
extends ViewPart
implements EventTrace.EventListener {
    StyledText text;
    private ClearEventTraceAction clearEventTraceAction;
    private PrintCrossCuttingModelAction printModelAction;
    private FilterTraceAction filterAction;
    private Font font = JFaceResources.getFont((String)"org.eclipse.jface.textfont");

    public void dispose() {
        AspectJPreferences.setEventTraceList(this.filterAction.getCheckedList());
        DebugTracing.setDebug(false);
        EventTrace.removeListener(this);
    }

    public void createPartControl(Composite parent) {
        this.text = new StyledText(parent, 778);
        this.text.setBackground(parent.getDisplay().getSystemColor(29));
        DebugTracing.setDebug(true);
        this.startup();
        EventTrace.addListener(this);
        this.makeActions();
        this.contributeToActionBars();
        this.getSite().setSelectionProvider(new ISelectionProvider(){

            public void addSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public ISelection getSelection() {
                return null;
            }

            public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public void setSelection(ISelection selection) {
            }
        });
    }

    private void startup() {
        this.ajdtEvent(DebugTracing.startupInfo(), 0, new Date());
    }

    public void setFocus() {
        this.text.setFocus();
    }

    public Object getAdapter(Class key) {
        if (key.equals(IContextProvider.class)) {
            return AspectJUIHelp.getHelpContextProvider((IWorkbenchPart)this, "org.eclipse.ajdt.ui.event_trace_view_context");
        }
        return super.getAdapter(key);
    }

    public void ajdtEvent(String msg, final int category, Date time) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(time);
        final String txt = String.valueOf(calendar.get(11)) + ":" + calendar.get(12) + ":" + calendar.get(13) + " " + msg + "\n";
        AspectJUIPlugin.getDefault().getDisplay().asyncExec(new Runnable(){

            public void run() {
                EventTraceView.this.appendEventText(txt, category);
            }
        });
    }

    private void appendEventText(String msg, int category) {
        IViewSite site = this.getViewSite();
        if (site == null) {
            return;
        }
        Shell shell = site.getShell();
        if (shell == null) {
            return;
        }
        Display display = shell.getDisplay();
        if (display == null) {
            return;
        }
        StyleRange styleRange = new StyleRange();
        styleRange.font = this.font;
        styleRange.start = this.text.getText().length();
        styleRange.length = msg.length();
        styleRange.foreground = category == 2 ? display.getSystemColor(10) : (category == 3 ? display.getSystemColor(4) : (category == 1 || category == 4 || category == 5 ? display.getSystemColor(6) : (category == 6 ? display.getSystemColor(14) : (category == 7 ? display.getSystemColor(8) : display.getSystemColor(2)))));
        this.text.append(msg);
        this.text.setStyleRange(styleRange);
        this.text.setTopIndex(this.text.getLineCount() - 1);
    }

    private void makeActions() {
        this.clearEventTraceAction = new ClearEventTraceAction(this.text);
        this.printModelAction = new PrintCrossCuttingModelAction();
        String dlogTitle = UIMessages.eventTrace_filter_dialog_title;
        String dlogMessage = UIMessages.eventTrace_filter_dialog_message;
        List<String> populatingList = Arrays.asList(DebugTracing.categoryNames);
        ArrayList checkedList = AspectJPreferences.getEventTraceCheckedList();
        ArrayList<String> defaultList = new ArrayList<String>();
        defaultList.add(DebugTracing.categoryNames[0]);
        defaultList.add(DebugTracing.categoryNames[3]);
        if (checkedList == null) {
            checkedList = new ArrayList(defaultList);
        }
        DebugTracing.setDebugCategories(checkedList);
        this.filterAction = new FilterTraceAction(this.getSite().getShell(), populatingList, checkedList, defaultList, dlogTitle, dlogMessage, UIMessages.eventTrace_filter_action_tooltip);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.clearEventTraceAction);
        manager.add((IAction)this.printModelAction);
        this.filterAction.fillActionBars(this.getViewSite().getActionBars());
    }
}

