/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.osgi.service.caching.j9;

import com.ibm.oti.shared.HelperAlreadyDefinedException;
import com.ibm.oti.shared.Shared;
import com.ibm.oti.shared.SharedClassURLHelper;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.aspectj.osgi.service.ICachingService;
import org.aspectj.osgi.service.caching.j9.CachingServicePlugin;
import org.osgi.framework.Bundle;

public class CachingService
implements ICachingService {
    private Bundle bundle;
    private ClassLoader classLoader;
    private String partition;
    SharedClassURLHelper urlhelper;

    public CachingService() {
        if (CachingServicePlugin.DEBUG) {
            System.out.println("- CachingService.<init>()");
        }
    }

    public CachingService(ClassLoader loader, Bundle bundle, String key) {
        if (CachingServicePlugin.DEBUG) {
            System.out.println("> CachingService.<init>() bundle=" + bundle.getSymbolicName() + ", loader=" + loader + ", key='" + key + "'");
        }
        this.bundle = bundle;
        this.classLoader = loader;
        this.partition = this.hashNamespace(key);
        try {
            this.urlhelper = Shared.getSharedClassHelperFactory().getURLHelper(this.classLoader);
        }
        catch (HelperAlreadyDefinedException e) {
            e.printStackTrace();
        }
        if (CachingServicePlugin.DEBUG) {
            System.out.println("< CachingService.<init>() partition='" + this.partition + "', urlhelper=" + this.urlhelper);
        }
    }

    public ICachingService getInstance(ClassLoader classLoader, Bundle bundle, String key) {
        return new CachingService(classLoader, bundle, key);
    }

    public byte[] findStoredClass(String namespace, URL sourceFileURL, String name) {
        byte[] bytes = this.urlhelper.findSharedClass(this.partition, sourceFileURL, name);
        if (CachingServicePlugin.DEBUG && bytes != null) {
            System.out.println("- CachingService.findStoredClass() bundle=" + this.bundle.getSymbolicName() + ", name=" + name + ", url=" + sourceFileURL + ", bytes=" + bytes);
        }
        return bytes;
    }

    public boolean storeClass(String namespace, URL sourceFileURL, Class clazz, byte[] classbytes) {
        boolean success = this.urlhelper.storeSharedClass(this.partition, sourceFileURL, clazz);
        if (CachingServicePlugin.DEBUG && success) {
            System.out.println("- CachingService.storeClass() bundle=" + this.bundle.getSymbolicName() + ", clazz=" + clazz + ", url=" + sourceFileURL);
        }
        return success;
    }

    public String hashNamespace(String namespace) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        byte[] bytes = md.digest(namespace.getBytes());
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < bytes.length) {
            int b = bytes[i];
            int num = b < 0 ? b + 256 : b;
            String s = Integer.toHexString(num);
            while (s.length() < 2) {
                s = "0" + s;
            }
            result.append(s);
            ++i;
        }
        return new String(result);
    }
}

