/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.osgi.service.caching.j9;

import com.ibm.oti.shared.Shared;
import org.aspectj.osgi.service.ICachingService;
import org.aspectj.osgi.service.caching.j9.CachingService;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class CachingServicePlugin
extends Plugin {
    public static boolean verbose = Boolean.getBoolean("org.aspectj.osgi.verbose");
    private static CachingServicePlugin plugin;
    public static boolean DEBUG;

    public CachingServicePlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        if (DEBUG) {
            System.out.println("> CachingServicePlugin.start() context=" + context);
        }
        super.start(context);
        this.loadOptions(context);
        if (this.shouldRegister()) {
            if (verbose) {
                System.err.println("[org.aspectj.osgi.service.caching.j9] info starting J9 caching service ...");
            }
            String name = ICachingService.class.getName();
            CachingService singleCachingService = new CachingService();
            context.registerService(name, (Object)singleCachingService, null);
        } else if (verbose) {
            System.err.println("[org.aspectj.osgi.service.caching.j9] warning cannot start J9 caching service");
        }
        if (DEBUG) {
            System.out.println("< CachingServicePlugin.start()");
        }
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static CachingServicePlugin getDefault() {
        return plugin;
    }

    private boolean shouldRegister() {
        boolean enabled;
        if (DEBUG) {
            System.out.println("> CachingServicePlugin.shouldRegister()");
        }
        try {
            Class.forName("com.ibm.oti.vm.VM");
            boolean sharing = Shared.isSharingEnabled();
            if (DEBUG) {
                System.out.println("- CachingServicePlugin.shouldRegister() sharing=" + sharing);
            }
            enabled = sharing;
        }
        catch (ClassNotFoundException ex) {
            if (DEBUG) {
                System.out.println("E CachingServicePlugin.shouldRegister() ex=" + ex);
            }
            enabled = false;
        }
        if (DEBUG) {
            System.out.println("< CachingServicePlugin.shouldRegister() " + enabled);
        }
        return enabled;
    }

    private void loadOptions(BundleContext context) {
        DebugOptions service = null;
        ServiceReference reference = context.getServiceReference(DebugOptions.class.getName());
        if (reference != null) {
            service = (DebugOptions)context.getService(reference);
        }
        if (service == null) {
            return;
        }
        try {
            DEBUG = service.getBooleanOption("org.aspectj.osgi.service.caching.j9/debug", false);
        }
        finally {
            context.ungetService(reference);
        }
    }
}

