/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.osgi.service.weaving;

import java.io.IOException;
import org.aspectj.osgi.service.IWeavingService;
import org.aspectj.osgi.service.weaving.WeavingServicePlugin;
import org.aspectj.osgi.weaver.loadtime.OSGiWeavingAdaptor;
import org.aspectj.osgi.weaver.loadtime.OSGiWeavingContext;
import org.aspectj.weaver.loadtime.IWeavingContext;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.State;

public class WeavingService
implements IWeavingService {
    private ClassLoader loader;
    private BundleDescription bundle;
    private OSGiWeavingAdaptor adaptor1;
    private IWeavingContext weavingContext;

    public WeavingService() {
        if (WeavingServicePlugin.DEBUG) {
            System.out.println("- WeavingService.<init>");
        }
    }

    public WeavingService(ClassLoader loader, State state, BundleDescription bundleDescription) {
        this.loader = loader;
        this.bundle = bundleDescription;
        this.weavingContext = new OSGiWeavingContext(loader, state, bundleDescription);
    }

    public IWeavingService getInstance(ClassLoader loader, State resolverState, BundleDescription bundleDesciption) {
        return new WeavingService(loader, resolverState, bundleDesciption);
    }

    public byte[] preProcess(String name, byte[] classbytes, ClassLoader loader) throws IOException {
        if (WeavingServicePlugin.DEBUG) {
            System.out.println("> WeavingService.preProcess() bundle=" + this.bundle.getSymbolicName() + ", name=" + name + ", bytes=" + classbytes.length);
        }
        this.ensureAdaptorInit();
        byte[] newBytes = this.adaptor1.weaveClass(name, classbytes);
        if (WeavingServicePlugin.DEBUG) {
            System.out.println("< WeavingService.preProcess() bytes=" + newBytes.length);
        }
        return newBytes;
    }

    private void ensureAdaptorInit() {
        if (this.adaptor1 == null) {
            this.adaptor1 = new OSGiWeavingAdaptor(this.loader, this.weavingContext);
            this.adaptor1.initialize();
        }
    }

    public String getKey() {
        if (WeavingServicePlugin.DEBUG) {
            System.out.println("> WeavingService.getKey() bundle=" + this.bundle.getSymbolicName());
        }
        this.ensureAdaptorInit();
        String key = this.adaptor1.getNamespace();
        if (WeavingServicePlugin.DEBUG) {
            System.out.println("< WeavingService.getKey() key='" + key + "'");
        }
        return key;
    }

    public boolean generatedClassesExistFor(ClassLoader loader, String className) {
        this.ensureAdaptorInit();
        return this.adaptor1.generatedClassesExistFor(className);
    }

    public void flushGeneratedClasses(ClassLoader loader) {
        this.ensureAdaptorInit();
        this.adaptor1.flushGeneratedClasses();
    }
}

