/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.osgi.service.weaving;

import java.util.Dictionary;
import java.util.Properties;
import org.aspectj.osgi.service.IWeavingService;
import org.aspectj.osgi.service.weaving.WeavingService;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class WeavingServicePlugin
extends Plugin {
    public static boolean verbose = Boolean.getBoolean("org.aspectj.osgi.verbose");
    private static WeavingServicePlugin plugin;
    public static boolean DEBUG;

    public WeavingServicePlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.loadOptions(context);
        if (verbose) {
            System.err.println("[org.aspectj.osgi.service.weaving] info Starting AspectJ weaving service ...");
        }
        String serviceName = IWeavingService.class.getName();
        WeavingService weavingService = new WeavingService();
        Properties props = new Properties();
        context.registerService(serviceName, (Object)weavingService, (Dictionary)props);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static WeavingServicePlugin getDefault() {
        return plugin;
    }

    private void loadOptions(BundleContext context) {
        DebugOptions service = null;
        ServiceReference reference = context.getServiceReference(DebugOptions.class.getName());
        if (reference != null) {
            service = (DebugOptions)context.getService(reference);
        }
        if (service == null) {
            return;
        }
        try {
            DEBUG = service.getBooleanOption("org.aspectj.osgi.service.weaving/debug", false);
        }
        finally {
            context.ungetService(reference);
        }
    }
}

