/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.osgi.weaver.loadtime;

import java.io.IOException;
import org.aspectj.osgi.service.weaving.WeavingServicePlugin;
import org.aspectj.weaver.loadtime.ClassLoaderWeavingAdaptor;
import org.aspectj.weaver.loadtime.IWeavingContext;

public class OSGiWeavingAdaptor
extends ClassLoaderWeavingAdaptor {
    private boolean initialized;
    private boolean initializing;
    private ClassLoader classLoader;
    private IWeavingContext weavingContext;

    public OSGiWeavingAdaptor(ClassLoader loader, IWeavingContext context) {
        this.classLoader = loader;
        this.weavingContext = context;
    }

    public byte[] weaveClass(String name, byte[] bytes) throws IOException {
        if (!this.initializing) {
            if (!this.initialized) {
                this.initializing = true;
                this.initialize(this.classLoader, this.weavingContext);
                this.initialized = true;
                this.initializing = false;
            }
            bytes = super.weaveClass(name, bytes);
        }
        return bytes;
    }

    public void initialize() {
        super.initialize(this.classLoader, this.weavingContext);
        this.initialized = true;
        if (WeavingServicePlugin.verbose) {
            if (this.isEnabled()) {
                System.err.println("[org.aspectj.osgi.service.weaving] info weaving bundle '" + this.weavingContext.getClassLoaderName() + "'");
            } else {
                System.err.println("[org.aspectj.osgi.service.weaving] info not weaving bundle '" + this.weavingContext.getClassLoaderName() + "'");
            }
        }
    }
}

