/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.osgi.weaver.loadtime;

import java.net.URL;
import org.aspectj.osgi.service.weaving.WeavingServicePlugin;
import org.aspectj.weaver.loadtime.DefaultWeavingContext;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.State;

public class OSGiWeavingContext
extends DefaultWeavingContext {
    private State resolverState;
    private BundleDescription bundle;

    public OSGiWeavingContext(ClassLoader loader, State state, BundleDescription bundleDescription) {
        super(loader);
        this.resolverState = state;
        this.bundle = bundleDescription;
        if (WeavingServicePlugin.DEBUG) {
            System.out.println("- WeavingContext.WeavingContext() locader=" + loader + ", bundle=" + this.bundle.getSymbolicName());
        }
    }

    public String getBundleIdFromURL(URL url) {
        return this.resolverState.getBundle((long)Integer.parseInt(url.getHost())).getSymbolicName();
    }

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getName()) + "[" + this.bundle.getSymbolicName() + "]";
    }

    public String getClassLoaderName() {
        return this.bundle.getSymbolicName();
    }

    public String getFile(URL url) {
        return String.valueOf(this.getBundleIdFromURL(url)) + url.getFile();
    }

    public String getId() {
        return this.bundle.getSymbolicName();
    }
}

