/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.osgi;

import java.io.IOException;
import java.net.URL;
import java.util.Stack;
import org.aspectj.osgi.AspectJAdaptorFactory;
import org.aspectj.osgi.Debug;
import org.aspectj.osgi.IAspectJAdaptor;
import org.aspectj.osgi.hooks.AspectJBundleFile;
import org.aspectj.osgi.service.ICachingService;
import org.aspectj.osgi.service.IWeavingService;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.baseadaptor.loader.BaseClassLoader;
import org.eclipse.osgi.framework.internal.core.BundleFragment;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.osgi.framework.Bundle;

public class AspectJAdaptor
implements IAspectJAdaptor {
    private boolean initialized = false;
    private BaseData data;
    private AspectJAdaptorFactory factory;
    private BaseClassLoader baseLoader;
    private Bundle bundle;
    private String symbolicName;
    private IWeavingService weavingService;
    private ICachingService cachingService;
    private static ThreadLocalStack stack = new ThreadLocalStack();

    public AspectJAdaptor(BaseData baseData, AspectJAdaptorFactory serviceFactory, BaseClassLoader baseClassLoader, IWeavingService weavingService, ICachingService cachingService) {
        this.data = baseData;
        this.factory = serviceFactory;
        this.symbolicName = baseData.getLocation();
        if (Debug.DEBUG_GENERAL) {
            Debug.println("- AspectJAdaptor.AspectJAdaptor() bundle=" + this.symbolicName);
        }
    }

    private void initialize() {
        if (this.initialized) {
            return;
        }
        this.bundle = this.data.getBundle();
        this.symbolicName = this.data.getSymbolicName();
        stack.push(this);
        if (Debug.DEBUG_GENERAL) {
            Debug.println("> AspectJAdaptor.initialize() bundle=" + this.symbolicName + ", baseLoader=" + this.baseLoader);
        }
        if (this.symbolicName.startsWith("org.aspectj")) {
            if (Debug.DEBUG_GENERAL) {
                Debug.println("I AspectJAdaptor.initialize() symbolicName=" + this.symbolicName + ", baseLoader=" + this.baseLoader);
            }
        } else if (this.baseLoader != null) {
            this.weavingService = this.factory.getWeavingService(this.baseLoader);
            this.cachingService = this.factory.getCachingService(this.baseLoader, this.bundle, this.weavingService);
        } else if (this.bundle instanceof BundleFragment) {
            BaseData hostData;
            BundleFile bundleFile;
            BundleFragment fragment = (BundleFragment)this.bundle;
            BundleHost host = (BundleHost)this.factory.getHost((Bundle)fragment);
            if (Debug.DEBUG_GENERAL) {
                Debug.println("I AspectJAdaptor.initialize() symbolicName=" + this.symbolicName + ", host=" + host);
            }
            if ((bundleFile = (hostData = (BaseData)host.getBundleData()).getBundleFile()) instanceof AspectJBundleFile) {
                AspectJBundleFile hostFile = (AspectJBundleFile)bundleFile;
                AspectJAdaptor hostAdaptor = (AspectJAdaptor)hostFile.getAdaptor();
                this.weavingService = hostAdaptor.weavingService;
            }
        } else if (Debug.DEBUG_GENERAL) {
            Debug.println("W AspectJAdaptor.initialize() symbolicName=" + this.symbolicName + ", baseLoader=" + this.baseLoader);
        }
        this.initialized = true;
        stack.pop();
        if (Debug.DEBUG_GENERAL) {
            Debug.println("< AspectJAdaptor.initialize() weavingService=" + (this.weavingService != null) + ", cachingService=" + (this.cachingService != null));
        }
    }

    public void setBaseClassLoader(BaseClassLoader baseClassLoader) {
        this.baseLoader = baseClassLoader;
        if (Debug.DEBUG_GENERAL) {
            Debug.println("- AspectJAdaptor.setBaseClassLoader() bundle=" + this.symbolicName + ", baseLoader=" + this.baseLoader);
        }
    }

    public byte[] findClass(String name, URL sourceFileURL) {
        if (Debug.DEBUG_CACHE) {
            Debug.println("> AspectJAdaptor.findClass() bundle=" + this.symbolicName + ", url=" + sourceFileURL + ", name=" + name);
        }
        byte[] bytes = null;
        this.initialize();
        if (this.cachingService != null) {
            bytes = this.cachingService.findStoredClass("", sourceFileURL, name);
        }
        if (Debug.DEBUG_CACHE) {
            Debug.println("< AspectJAdaptor.findClass() bytes=" + bytes);
        }
        return bytes;
    }

    public byte[] weaveClass(String name, byte[] bytes) {
        if (Debug.DEBUG_WEAVE) {
            Debug.println("> AspectJAdaptor.weaveClass() bundle=" + this.symbolicName + ", name=" + name + ", bytes=" + bytes.length);
        }
        byte[] newBytes = null;
        this.initialize();
        if (this.shouldWeave(bytes) && this.weavingService != null) {
            try {
                newBytes = this.weavingService.preProcess(name, bytes, (ClassLoader)this.baseLoader);
            }
            catch (IOException ex) {
                throw new ClassFormatError(ex.toString());
            }
        }
        if (Debug.DEBUG_WEAVE) {
            Debug.println("< AspectJAdaptor.weaveClass() newBytes=" + newBytes);
        }
        return newBytes;
    }

    private boolean shouldWeave(byte[] bytes) {
        if (bytes.length < 4) {
            return false;
        }
        if (bytes[0] != -54) {
            return false;
        }
        if (bytes[1] != -2) {
            return false;
        }
        if (bytes[2] != -70) {
            return false;
        }
        return bytes[3] == -66;
    }

    public boolean storeClass(String name, URL sourceFileURL, Class clazz, byte[] classbytes) {
        if (Debug.DEBUG_CACHE) {
            Debug.println("> AspectJAdaptor.storeClass() bundle=" + this.symbolicName + ", url=" + sourceFileURL + ", name=" + name + ", clazz=" + clazz);
        }
        boolean stored = false;
        this.initialize();
        if (this.cachingService != null) {
            if (this.weavingService != null && this.weavingService.generatedClassesExistFor((ClassLoader)this.baseLoader, name)) {
                this.weavingService.flushGeneratedClasses((ClassLoader)this.baseLoader);
            } else {
                stored = this.cachingService.storeClass("", sourceFileURL, clazz, classbytes);
                if (!stored && Debug.DEBUG_CACHE) {
                    Debug.println("E AspectJHook.storeClass() bundle=" + this.symbolicName + ", name=" + name);
                }
            }
        }
        if (Debug.DEBUG_CACHE) {
            Debug.println("< AspectJAdaptor.storeClass() stored=" + stored);
        }
        return stored;
    }

    public String toString() {
        return "AspectJAdaptor[" + this.symbolicName + "]";
    }

    private static class ThreadLocalStack
    extends ThreadLocal {
        private ThreadLocalStack() {
        }

        public boolean empty() {
            Stack stack = (Stack)this.get();
            return stack.empty();
        }

        public Object peek() {
            Object obj = null;
            Stack stack = (Stack)this.get();
            if (!stack.empty()) {
                obj = stack.peek();
            }
            return obj;
        }

        public void push(Object obj) {
            Stack stack = (Stack)this.get();
            if (!stack.empty() && obj == stack.peek()) {
                throw new RuntimeException(obj.toString());
            }
            stack.push(obj);
        }

        public Object pop() {
            Stack stack = (Stack)this.get();
            return stack.pop();
        }

        protected Object initialValue() {
            return new Stack();
        }
    }
}

