/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.osgi;

import org.aspectj.osgi.Debug;
import org.aspectj.osgi.service.ICachingService;
import org.aspectj.osgi.service.IWeavingService;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.loader.BaseClassLoader;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.State;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

public class AspectJAdaptorFactory {
    private BundleContext bundleContext;
    private IWeavingService singletonWeavingService;
    private ICachingService singletonCachingService;
    private PackageAdmin packageAdminService;

    public AspectJAdaptorFactory(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.initialize(bundleContext);
    }

    private void initialize(BundleContext context) {
        if (Debug.DEBUG_GENERAL) {
            Debug.println("> AspectJAdaptorFactory.initialize() context=" + context);
        }
        this.bundleContext = context;
        String weavingFilter = "(objectclass=" + IWeavingService.class.getName() + ")";
        String cachingFilter = "(objectclass=" + ICachingService.class.getName() + ")";
        ServiceListener weavingListener = new ServiceListener(){

            public void serviceChanged(ServiceEvent event) {
                if (event.getType() == 1) {
                    AspectJAdaptorFactory.this.initializeWeavingService();
                }
            }
        };
        ServiceListener cachingListener = new ServiceListener(){

            public void serviceChanged(ServiceEvent event) {
                if (event.getType() == 1) {
                    AspectJAdaptorFactory.this.initializeCachingService();
                }
            }
        };
        try {
            this.bundleContext.addServiceListener(weavingListener, weavingFilter);
            this.bundleContext.addServiceListener(cachingListener, cachingFilter);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.initializePackageAdminService(context);
        if (Debug.DEBUG_GENERAL) {
            Debug.println("< AspectJAdaptorFactory.initialize() weavingListener=" + weavingListener + ", cachingListener=" + cachingListener);
        }
    }

    protected void initializeWeavingService() {
        ServiceReference ref;
        if (Debug.DEBUG_GENERAL) {
            Debug.println("> AspectJAdaptorFactory.initializeWeavingService()");
        }
        if ((ref = this.bundleContext.getServiceReference(IWeavingService.class.getName())) != null) {
            this.singletonWeavingService = (IWeavingService)this.bundleContext.getService(ref);
        }
        if (Debug.DEBUG_GENERAL) {
            Debug.println("< AspectJAdaptorFactory.initializeWeavingService() weavingService=" + this.singletonWeavingService);
        }
    }

    protected IWeavingService getWeavingService(BaseClassLoader loader) {
        if (Debug.DEBUG_WEAVE) {
            Debug.println("> AspectJAdaptorFactory.getWeavingService() baseClassLoader=" + loader);
        }
        IWeavingService weavingService = null;
        if (this.singletonWeavingService != null) {
            BaseData baseData = loader.getClasspathManager().getBaseData();
            State state = baseData.getAdaptor().getState();
            Bundle bundle = baseData.getBundle();
            BundleDescription bundleDescription = state.getBundle(bundle.getBundleId());
            weavingService = this.singletonWeavingService.getInstance((ClassLoader)loader, state, bundleDescription);
        }
        if (Debug.DEBUG_WEAVE) {
            Debug.println("< AspectJAdaptorFactory.getWeavingService() service=" + weavingService);
        }
        return weavingService;
    }

    protected void initializeCachingService() {
        ServiceReference ref;
        if (Debug.DEBUG_CACHE) {
            Debug.println("> AspectJAdaptorFactory.initializeCachingService()");
        }
        if ((ref = this.bundleContext.getServiceReference(ICachingService.class.getName())) != null) {
            this.singletonCachingService = (ICachingService)this.bundleContext.getService(ref);
        }
        if (Debug.DEBUG_CACHE) {
            Debug.println("< AspectJAdaptorFactory.initializeCachingService() singletonCachingService=" + this.singletonCachingService);
        }
    }

    protected ICachingService getCachingService(BaseClassLoader loader, Bundle bundle, IWeavingService weavingService) {
        if (Debug.DEBUG_CACHE) {
            Debug.println("> AspectJAdaptorFactory.getCachingService() bundle=" + bundle + ", weavingService=" + weavingService);
        }
        ICachingService service = null;
        String key = "";
        if (weavingService != null) {
            key = weavingService.getKey();
        }
        if (this.singletonCachingService != null) {
            service = this.singletonCachingService.getInstance((ClassLoader)loader, bundle, key);
        }
        if (Debug.DEBUG_CACHE) {
            Debug.println("< AspectJAdaptorFactory.getCachingService() service=" + service + ", key='" + key + "'");
        }
        return service;
    }

    private void initializePackageAdminService(BundleContext context) {
        ServiceReference ref;
        if (Debug.DEBUG_GENERAL) {
            Debug.println("> AspectJAdaptorFactory.initializePackageAdminService() context=" + context);
        }
        if ((ref = context.getServiceReference(PackageAdmin.class.getName())) != null) {
            this.packageAdminService = (PackageAdmin)context.getService(ref);
        }
        if (Debug.DEBUG_GENERAL) {
            Debug.println("< AspectJAdaptorFactory.initializePackageAdminService() " + this.packageAdminService);
        }
    }

    public Bundle getHost(Bundle fragment) {
        if (Debug.DEBUG_GENERAL) {
            Debug.println("> AspectJAdaptorFactory.getHost() fragment=" + fragment);
        }
        Bundle host = null;
        if (this.packageAdminService != null) {
            host = this.packageAdminService.getHosts(fragment)[0];
        }
        if (Debug.DEBUG_GENERAL) {
            Debug.println("< AspectJAdaptorFactory.getHost() " + host);
        }
        return host;
    }
}

