/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.osgi.hooks;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.aspectj.osgi.IAspectJAdaptor;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;

public class AspectJBundleEntry
extends BundleEntry {
    private IAspectJAdaptor adaptor;
    private String name;
    private byte[] bytes;
    private URL bundleFileURL;
    private BundleEntry delegate;

    protected AspectJBundleEntry(IAspectJAdaptor aspectjAdaptor, URL url) {
        this.adaptor = aspectjAdaptor;
        this.bundleFileURL = url;
    }

    public AspectJBundleEntry(IAspectJAdaptor aspectjAdaptor, BundleEntry be, URL u) {
        this(aspectjAdaptor, u);
        this.delegate = be;
        this.bundleFileURL = u;
    }

    public AspectJBundleEntry(IAspectJAdaptor aspectjAdaptor, String s, byte[] ba, URL u) {
        this(aspectjAdaptor, u);
        this.name = s;
        this.bytes = ba;
        this.bundleFileURL = u;
    }

    public URL getBundleFileURL() {
        return this.bundleFileURL;
    }

    public IAspectJAdaptor getAdaptor() {
        return this.adaptor;
    }

    public URL getFileURL() {
        if (this.delegate != null) {
            return this.delegate.getFileURL();
        }
        return null;
    }

    public InputStream getInputStream() throws IOException {
        if (this.delegate != null) {
            return this.delegate.getInputStream();
        }
        return new ByteArrayInputStream(this.bytes);
    }

    public URL getLocalURL() {
        if (this.delegate != null) {
            return this.delegate.getLocalURL();
        }
        return null;
    }

    public String getName() {
        if (this.delegate != null) {
            return this.delegate.getName();
        }
        return this.name;
    }

    public long getSize() {
        if (this.delegate != null) {
            return this.delegate.getSize();
        }
        return this.bytes.length;
    }

    public long getTime() {
        if (this.delegate != null) {
            return this.delegate.getTime();
        }
        return 0L;
    }
}

