/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.osgi.hooks;

import java.io.IOException;
import java.net.URL;
import org.aspectj.osgi.Debug;
import org.aspectj.osgi.IAspectJAdaptor;
import org.aspectj.osgi.hooks.AbstractAJBundleFile;
import org.aspectj.osgi.hooks.AspectJBundleEntry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;

public class AspectJBundleFile
extends AbstractAJBundleFile {
    private URL url;

    public AspectJBundleFile(IAspectJAdaptor aa, BundleFile bundleFile) throws IOException {
        super(aa, bundleFile);
        this.url = this.delegate.getBaseFile().toURL();
    }

    public URL getURL() {
        return this.url;
    }

    public BundleEntry getEntry(String path) {
        BundleEntry entry;
        if (Debug.DEBUG_BUNDLE) {
            Debug.println("> AspectJBundleFile.getEntry() path=" + path + ", url=" + this.url);
        }
        if (path.endsWith(".class")) {
            int offset = path.lastIndexOf(46);
            String name = path.substring(0, offset).replace('/', '.');
            byte[] bytes = this.adaptor.findClass(name, this.url);
            if (bytes == null) {
                entry = this.delegate.getEntry(path);
                if (entry != null) {
                    entry = new AspectJBundleEntry(this.adaptor, entry, this.url);
                    if (Debug.DEBUG_BUNDLE) {
                        Debug.println("- AspectJBundleFile.getEntry() path=" + path + ", entry=" + entry);
                    }
                }
            } else {
                entry = new AspectJBundleEntry(this.adaptor, path, bytes, this.url);
            }
        } else {
            entry = this.delegate.getEntry(path);
        }
        if (Debug.DEBUG_BUNDLE) {
            Debug.println("< AspectJBundleFile.getEntry() entry=" + entry);
        }
        return entry;
    }
}

