/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.osgi.hooks;

import java.io.IOException;
import java.net.URL;
import org.aspectj.osgi.AspectJAdaptor;
import org.aspectj.osgi.AspectJAdaptorFactory;
import org.aspectj.osgi.Debug;
import org.aspectj.osgi.IAspectJAdaptor;
import org.aspectj.osgi.hooks.AbstractAspectJHook;
import org.aspectj.osgi.hooks.AspectJBundleEntry;
import org.aspectj.osgi.hooks.AspectJBundleFile;
import org.aspectj.osgi.hooks.BaseAjBundleFile;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.baseadaptor.loader.BaseClassLoader;
import org.eclipse.osgi.baseadaptor.loader.ClasspathEntry;
import org.eclipse.osgi.baseadaptor.loader.ClasspathManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class AspectJHook
extends AbstractAspectJHook {
    private BundleContext bundleContext;
    private AspectJAdaptorFactory adaptorFactory;

    public AspectJHook() {
        if (Debug.DEBUG_GENERAL) {
            Debug.println("- AspectJHook.<init>()");
        }
    }

    private void initialize(BundleContext context) {
        if (Debug.DEBUG_GENERAL) {
            Debug.println("> AspectJHook.initialize() context=" + context);
        }
        this.bundleContext = context;
        this.adaptorFactory = new AspectJAdaptorFactory(context);
        if (Debug.DEBUG_GENERAL) {
            Debug.println("< AspectJHook.initialize() adaptorFactory=" + this.adaptorFactory);
        }
    }

    public void frameworkStart(BundleContext context) throws BundleException {
        this.initialize(context);
    }

    public void recordClassDefine(String name, Class clazz, byte[] classbytes, ClasspathEntry classpathEntry, BundleEntry entry, ClasspathManager manager) {
        if (entry instanceof AspectJBundleEntry) {
            AspectJBundleEntry ajBundleEntry = (AspectJBundleEntry)entry;
            IAspectJAdaptor adaptor = ajBundleEntry.getAdaptor();
            URL sourceFileURL = ajBundleEntry.getBundleFileURL();
            adaptor.storeClass(name, sourceFileURL, clazz, classbytes);
        }
    }

    public void initializedClassLoader(BaseClassLoader baseClassLoader, BaseData data) {
        if (Debug.DEBUG_GENERAL) {
            Debug.println("> AspectJHook.initializedClassLoader() bundle=" + data.getSymbolicName() + ", loader=" + baseClassLoader + ", data=" + data + ", bundleFile=" + data.getBundleFile());
        }
        IAspectJAdaptor adaptor = null;
        BundleFile bundleFile = data.getBundleFile();
        if (bundleFile instanceof BaseAjBundleFile) {
            BaseAjBundleFile baseBundleFile = (BaseAjBundleFile)bundleFile;
            adaptor = baseBundleFile.getAdaptor();
            adaptor.setBaseClassLoader(baseClassLoader);
        }
        if (Debug.DEBUG_GENERAL) {
            Debug.println("< AspectJHook.initializedClassLoader() adaptor=" + adaptor);
        }
    }

    public byte[] processClass(String name, byte[] classbytes, ClasspathEntry classpathEntry, BundleEntry entry, ClasspathManager manager) {
        byte[] newClassytes = null;
        if (entry instanceof AspectJBundleEntry) {
            AspectJBundleEntry ajBundleEntry = (AspectJBundleEntry)entry;
            IAspectJAdaptor adaptor = ajBundleEntry.getAdaptor();
            newClassytes = adaptor.weaveClass(name, classbytes);
        }
        return newClassytes;
    }

    public BundleFile wrapBundleFile(BundleFile bundleFile, Object content, BaseData data, boolean base) throws IOException {
        AspectJBundleFile wrapped = null;
        if (Debug.DEBUG_BUNDLE) {
            Debug.println("> AspectJBundleFileWrapperFactoryHook.wrapBundleFile() bundle=" + data.getSymbolicName() + " bundleFile=" + bundleFile + ", content=" + content + ", data=" + data + ", base=" + base + ", baseFile=" + bundleFile.getBaseFile());
        }
        if (base) {
            IAspectJAdaptor adaptor = this.createAspectJAdaptor(data);
            if (adaptor != null) {
                wrapped = new BaseAjBundleFile(adaptor, bundleFile);
            }
        } else {
            IAspectJAdaptor adaptor = null;
            if (this.bundleContext != null) {
                adaptor = this.getAspectJAdaptor(data);
                if (Debug.DEBUG_BUNDLE) {
                    Debug.println("- AspectJBundleFileWrapperFactoryHook.wrapBundleFile() adaptor=" + adaptor);
                }
            }
            if (adaptor != null) {
                wrapped = new AspectJBundleFile(adaptor, bundleFile);
            }
        }
        if (Debug.DEBUG_BUNDLE) {
            Debug.println("< AspectJBundleFileWrapperFactoryHook.wrapBundleFile() wrapped=" + (Object)((Object)wrapped));
        }
        return wrapped;
    }

    private IAspectJAdaptor createAspectJAdaptor(BaseData baseData) {
        if (Debug.DEBUG_GENERAL) {
            Debug.println("> AspectJHook.createAspectJAdaptor() location=" + baseData.getLocation());
        }
        AspectJAdaptor adaptor = null;
        if (this.adaptorFactory != null) {
            adaptor = new AspectJAdaptor(baseData, this.adaptorFactory, null, null, null);
        } else if (Debug.DEBUG_GENERAL) {
            Debug.println("- AspectJHook.createAspectJAdaptor() factory=" + this.adaptorFactory);
        }
        if (Debug.DEBUG_GENERAL) {
            Debug.println("< AspectJHook.createAspectJAdaptor() adaptor=" + adaptor);
        }
        return adaptor;
    }

    private IAspectJAdaptor getAspectJAdaptor(BaseData data) {
        IAspectJAdaptor adaptor = null;
        BundleFile bundleFile = data.getBundleFile();
        if (bundleFile instanceof BaseAjBundleFile) {
            BaseAjBundleFile baseBundleFile = (BaseAjBundleFile)bundleFile;
            adaptor = baseBundleFile.getAdaptor();
        }
        return adaptor;
    }
}

