/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.osgi.hooks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.LinkedList;
import java.util.List;
import org.aspectj.osgi.Debug;
import org.aspectj.osgi.hooks.AbstractAspectJHook;
import org.eclipse.core.runtime.internal.adaptor.CachedManifest;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.hooks.StorageHook;
import org.eclipse.osgi.framework.util.Headers;
import org.eclipse.osgi.framework.util.KeyedElement;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.BundleException;

public class AspectJStorageHook
implements StorageHook {
    public static final String SUPPLEMENT_IMPORTER = "Eclipse-SupplementImporter";
    public static final String SUPPLEMENT_EXPORTER = "Eclipse-SupplementExporter";
    public static final String SUPPLEMENT_BUNDLE = "Eclipse-SupplementBundle";
    public static final String KEY = AspectJStorageHook.class.getName();
    public static final int HASHCODE = KEY.hashCode();
    private List hooks;
    private AspectJStorageHook root;
    private BaseData bundleData;
    private ManifestElement[] supplementBundle;
    private ManifestElement[] supplementImporter;
    private ManifestElement[] supplementExporter;

    public AspectJStorageHook() {
        if (Debug.DEBUG_SUPPLEMENTS) {
            Debug.println("- AspectJStorageHook.AspectJStorageHook()");
        }
        this.hooks = new LinkedList();
    }

    public AspectJStorageHook(AspectJStorageHook rootStorageHook, BaseData bd) {
        if (Debug.DEBUG_SUPPLEMENTS) {
            Debug.println("- AspectJStorageHook.AspectJStorageHook() baseDate=" + bd);
        }
        this.root = rootStorageHook;
        this.bundleData = bd;
    }

    private void addSupplementer(AspectJStorageHook hook) {
        this.hooks.add(hook);
    }

    private List getSupplementers(String symbolicName, ManifestElement[] imports, ManifestElement[] exports) {
        LinkedList<String> supplementers = Collections.EMPTY_LIST;
        if (this.hooks.size() > 0) {
            supplementers = new LinkedList<String>();
            for (AspectJStorageHook hook : this.hooks) {
                String supplementerName = hook.getSymbolicName();
                if (supplementerName.equals(symbolicName) || !hook.matchSupplementer(symbolicName) && (imports == null || !hook.matchesSupplementImporter(imports)) && (exports == null || !hook.matchesSupplementExporter(exports))) continue;
                supplementers.add(supplementerName);
            }
        }
        return supplementers;
    }

    private boolean matchSupplementer(String symbolicName) {
        boolean matches = false;
        if (this.supplementBundle != null) {
            int i = 0;
            while (!matches && i < this.supplementBundle.length) {
                ManifestElement bundle = this.supplementBundle[i];
                if (this.equals_wild(bundle.getValue(), symbolicName)) {
                    matches = true;
                }
                ++i;
            }
        }
        return matches;
    }

    private boolean matchesSupplementImporter(ManifestElement[] imports) {
        boolean matches = false;
        if (this.supplementImporter != null) {
            int i = 0;
            while (!matches && i < this.supplementImporter.length) {
                ManifestElement supplementImport = this.supplementImporter[i];
                int j = 0;
                while (!matches && j < imports.length) {
                    ManifestElement importPackage = imports[j];
                    if (supplementImport.getValue().equals(importPackage.getValue())) {
                        matches = true;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return matches;
    }

    private boolean matchesSupplementExporter(ManifestElement[] exports) {
        boolean matches = false;
        if (this.supplementExporter != null) {
            int i = 0;
            while (!matches && i < this.supplementExporter.length) {
                ManifestElement supplementExport = this.supplementExporter[i];
                int j = 0;
                while (!matches && j < exports.length) {
                    ManifestElement exportPackage = exports[j];
                    if (supplementExport.getValue().equals(exportPackage.getValue())) {
                        matches = true;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return matches;
    }

    private String getSymbolicName() {
        return this.bundleData == null ? "root" : this.bundleData.getSymbolicName();
    }

    private boolean equals_wild(String input, String match) {
        if (input.equals(match)) {
            return true;
        }
        if (!input.endsWith("*")) {
            return false;
        }
        String wild_in = input.substring(0, input.length() - 1);
        return match.startsWith(wild_in);
    }

    public void copy(StorageHook storageHook) {
    }

    public StorageHook create(BaseData bundledata) throws BundleException {
        AspectJStorageHook hook = new AspectJStorageHook(this, bundledata);
        return hook;
    }

    public boolean forgetStartLevelChange(int startlevel) {
        return false;
    }

    public boolean forgetStatusChange(int status) {
        return false;
    }

    public Dictionary getManifest(boolean firstLoad) throws BundleException {
        return null;
    }

    public int getStorageVersion() {
        return 0;
    }

    public void initialize(Dictionary manifest) throws BundleException {
        if (Debug.DEBUG_SUPPLEMENTS) {
            Debug.println("> AspectJStorageHook.initialize() " + this.getSymbolicName());
        }
        try {
            this.supplementBundle = ManifestElement.parseHeader((String)SUPPLEMENT_BUNDLE, (String)((String)manifest.get(SUPPLEMENT_BUNDLE)));
            this.supplementImporter = ManifestElement.parseHeader((String)SUPPLEMENT_IMPORTER, (String)((String)manifest.get(SUPPLEMENT_IMPORTER)));
            this.supplementExporter = ManifestElement.parseHeader((String)SUPPLEMENT_EXPORTER, (String)((String)manifest.get(SUPPLEMENT_EXPORTER)));
            if (this.supplementBundle != null || this.supplementImporter != null || this.supplementExporter != null) {
                this.root.addSupplementer(this);
                if (Debug.DEBUG_SUPPLEMENTS) {
                    Debug.println("- AspectJStorageHook.initialize() " + this.getSymbolicName() + " bundles=" + (this.supplementBundle == null ? "[]" : Arrays.asList(this.supplementBundle).toString()) + ", importers=" + (this.supplementImporter == null ? "[]" : Arrays.asList(this.supplementImporter).toString()) + ", exporters=" + (this.supplementExporter == null ? "[]" : Arrays.asList(this.supplementExporter).toString()));
                }
            }
            ManifestElement[] imports = ManifestElement.parseHeader((String)"Import-Package", (String)((String)manifest.get("Import-Package")));
            ManifestElement[] exports = ManifestElement.parseHeader((String)"Export-Package", (String)((String)manifest.get("Export-Package")));
            List supplementers = this.root.getSupplementers(this.bundleData.getSymbolicName(), imports, exports);
            if (!supplementers.isEmpty()) {
                if (Debug.DEBUG_SUPPLEMENTS) {
                    Debug.println("- AspectJStorageHook.initialize() " + this.getSymbolicName() + " supplementers=" + supplementers);
                }
                if (!(this.getSymbolicName().equals("org.eclipse.osgi") || this.getSymbolicName().startsWith("org.eclipse.team.ui") || this.getSymbolicName().startsWith("org.eclipse.update"))) {
                    if (this.addRequiredBundles(supplementers)) {
                        if (AbstractAspectJHook.verbose) {
                            System.err.println("[org.aspectj.osgi] info supplementing " + this.getSymbolicName() + " with " + supplementers);
                        }
                    } else if (AbstractAspectJHook.verbose) {
                        System.err.println("[org.aspectj.osgi] info not supplementing " + this.getSymbolicName());
                    }
                } else if (AbstractAspectJHook.verbose) {
                    System.err.println("[org.aspectj.osgi] info cannot supplement " + this.getSymbolicName());
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (Debug.DEBUG_SUPPLEMENTS) {
            Debug.println("< AspectJStorageHook.initialize() ");
        }
    }

    private boolean addRequiredBundles(List bundles) throws BundleException {
        Dictionary manifest = this.bundleData.getManifest();
        if ((manifest = ((CachedManifest)manifest).getManifest()) != null) {
            String value = (String)manifest.get("Require-Bundle");
            for (String name : bundles) {
                value = value == null ? name : String.valueOf(value) + "," + name;
            }
            if (Debug.DEBUG_SUPPLEMENTS) {
                Debug.println("- AspectJStorageHook.addRequiredBundles() " + this.bundleData.getSymbolicName() + " ,manifest=" + manifest.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(manifest)) + ", value=" + value);
            }
            ((Headers)manifest).set((Object)"Require-Bundle", (Object)value, true);
        }
        return true;
    }

    public StorageHook load(BaseData bundledata, DataInputStream is) throws IOException {
        if (Debug.DEBUG_SUPPLEMENTS) {
            Debug.println("- AspectJStorageHook.load() " + this.getSymbolicName() + " bundleData=" + bundledata);
        }
        return new AspectJStorageHook(this, bundledata);
    }

    public boolean matchDNChain(String pattern) {
        return false;
    }

    public void save(DataOutputStream os) throws IOException {
        if (Debug.DEBUG_SUPPLEMENTS) {
            Debug.println("- AspectJStorageHook.save() " + this.getSymbolicName());
        }
    }

    public void validate() throws IllegalArgumentException {
    }

    public boolean compare(KeyedElement other) {
        return other.getKey() == KEY;
    }

    public Object getKey() {
        return KEY;
    }

    public int getKeyHashCode() {
        return HASHCODE;
    }

    public String toString() {
        return "AspectJStorageHook[" + this.getSymbolicName() + "]";
    }
}

