/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.arduino.core.internal.launch;

import java.io.IOException;
import org.eclipse.cdt.arduino.core.internal.Activator;
import org.eclipse.cdt.arduino.core.internal.Messages;
import org.eclipse.cdt.arduino.core.internal.build.ArduinoBuildConfiguration;
import org.eclipse.cdt.arduino.core.internal.console.ArduinoConsoleService;
import org.eclipse.cdt.arduino.core.internal.remote.ArduinoRemoteConnection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionType;
import org.eclipse.remote.core.IRemoteServicesManager;

public class ArduinoLaunchConfigurationDelegate
extends LaunchConfigurationDelegate {
    public static final String TYPE_ID = "org.eclipse.cdt.arduino.core.launchConfigurationType";
    public static final String CONNECTION_NAME = String.valueOf(Activator.getId()) + ".connectionName";

    private static IRemoteConnection getTarget(ILaunchConfiguration configuration) throws CoreException {
        IRemoteServicesManager remoteManager = Activator.getService(IRemoteServicesManager.class);
        IRemoteConnectionType connectionType = remoteManager.getConnectionType("org.eclipse.cdt.arduino.core.connectionType");
        String connectionName = configuration.getAttribute(CONNECTION_NAME, "");
        return connectionType.getConnection(connectionName);
    }

    public boolean buildForLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        IRemoteConnection target = ArduinoLaunchConfigurationDelegate.getTarget(configuration);
        if (target != null) {
            ArduinoRemoteConnection arduinoTarget = (ArduinoRemoteConnection)target.getService(ArduinoRemoteConnection.class);
            IProject project = configuration.getMappedResources()[0].getProject();
            ArduinoBuildConfiguration arduinoConfig = ArduinoBuildConfiguration.getConfig(project, arduinoTarget, monitor);
            arduinoConfig.setActive(monitor);
        }
        return super.buildForLaunch(configuration, mode, monitor);
    }

    protected IProject[] getBuildOrder(ILaunchConfiguration configuration, String mode) throws CoreException {
        IProject project = configuration.getMappedResources()[0].getProject();
        return new IProject[]{project};
    }

    public void launch(final ILaunchConfiguration configuration, String mode, final ILaunch launch, IProgressMonitor monitor) throws CoreException {
        new Job(Messages.ArduinoLaunchConfigurationDelegate_0){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ArduinoConsoleService consoleService = Activator.getConsoleService();
                    IRemoteConnection target = ArduinoLaunchConfigurationDelegate.getTarget(configuration);
                    if (target == null) {
                        Status status = new Status(4, Activator.getId(), Messages.ArduinoLaunchConfigurationDelegate_2);
                        return status;
                    }
                    try {
                        ArduinoRemoteConnection arduinoTarget = (ArduinoRemoteConnection)target.getService(ArduinoRemoteConnection.class);
                        IProject project = (IProject)configuration.getMappedResources()[0];
                        ArduinoBuildConfiguration arduinoConfig = ArduinoBuildConfiguration.getConfig(project, arduinoTarget, monitor);
                        String[] uploadCmd = arduinoConfig.getUploadCommand(arduinoTarget.getPortName());
                        boolean wasOpened = target.isOpen();
                        if (wasOpened) {
                            arduinoTarget.pause();
                        }
                        StringBuffer cmdStr = new StringBuffer(uploadCmd[0]);
                        int i = 1;
                        while (i < uploadCmd.length) {
                            cmdStr.append(' ');
                            cmdStr.append(uploadCmd[i]);
                            ++i;
                        }
                        cmdStr.append('\n');
                        consoleService.writeOutput(cmdStr.toString());
                        ProcessBuilder processBuilder = new ProcessBuilder(uploadCmd).directory(arduinoConfig.getBuildDirectory());
                        arduinoConfig.setEnvironment(processBuilder.environment());
                        Process process = processBuilder.start();
                        consoleService.monitor(process, null, null);
                        try {
                            process.waitFor();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        consoleService.writeOutput("Upload complete\n");
                        if (wasOpened) {
                            arduinoTarget.resume();
                        }
                    }
                    catch (CoreException e) {
                        IStatus iStatus = e.getStatus();
                        return iStatus;
                    }
                    catch (IOException e) {
                        Status status = new Status(4, Activator.getId(), e.getLocalizedMessage(), (Throwable)e);
                        return status;
                    }
                }
                finally {
                    DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }
}

