/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.application;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.cdt.debug.application.ApplicationActionBarAdvisor;
import org.eclipse.cdt.debug.application.CoreFileDialog;
import org.eclipse.cdt.debug.application.CoreFileInfo;
import org.eclipse.cdt.debug.application.Messages;
import org.eclipse.cdt.debug.application.NewExecutableDialog;
import org.eclipse.cdt.debug.application.NewExecutableInfo;
import org.eclipse.cdt.debug.application.RemoteExecutableDialog;
import org.eclipse.cdt.debug.application.RemoteExecutableInfo;
import org.eclipse.cdt.internal.debug.application.DebugAttachedExecutable;
import org.eclipse.cdt.internal.debug.application.DebugCoreFile;
import org.eclipse.cdt.internal.debug.application.DebugExecutable;
import org.eclipse.cdt.internal.debug.application.DebugRemoteExecutable;
import org.eclipse.cdt.internal.debug.application.JobContainer;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;

public class ApplicationWorkbenchWindowAdvisor
extends WorkbenchWindowAdvisor {
    private static final String STANDALONE_QUALIFIER = "org.eclipse.cdt.debug.application";
    private static final String LAST_LAUNCH = "lastLaunch";
    private ILaunchConfiguration config;

    public ApplicationWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        super(configurer);
    }

    public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {
        return new ApplicationActionBarAdvisor(configurer);
    }

    public void preWindowOpen() {
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        configurer.setShowCoolBar(true);
        configurer.setShowStatusLine(true);
        configurer.setShowMenuBar(true);
        configurer.setShowProgressIndicator(true);
        configurer.setTitle(Messages.Debugger_Title);
    }

    public void postWindowCreate() {
        super.postWindowCreate();
        try {
            PostWindowCreateRunnable op = new PostWindowCreateRunnable();
            new ProgressMonitorDialog(this.getWindowConfigurer().getWindow().getShell()).run(true, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private String findExecutable(String input) {
        String result;
        block8: {
            result = input;
            Path x = new Path(input);
            try {
                if (x.isAbsolute() || x.segmentCount() != 1) break block8;
                String command = "which " + input;
                Process p = null;
                InputStream in = null;
                try {
                    p = ProcessFactory.getFactory().exec(command);
                    in = p.getInputStream();
                    InputStreamReader reader = new InputStreamReader(in);
                    BufferedReader br = new BufferedReader(reader);
                    String line = br.readLine();
                    if (line != null) {
                        result = line;
                    }
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                    if (p != null) {
                        p.destroy();
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }

    public void postWindowClose() {
        if (ResourcesPlugin.getWorkspace() != null) {
            this.disconnectFromWorkspace();
        }
        super.postWindowClose();
    }

    private void disconnectFromWorkspace() {
        final MultiStatus status = new MultiStatus("GDBStandalone", 1, Messages.ProblemSavingWorkbench, null);
        try {
            ProgressMonitorDialog p = new ProgressMonitorDialog(null);
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    try {
                        status.merge(ResourcesPlugin.getWorkspace().save(true, monitor));
                    }
                    catch (CoreException e) {
                        status.merge(e.getStatus());
                    }
                }
            };
            p.run(true, false, runnable);
        }
        catch (InvocationTargetException e) {
            status.merge((IStatus)new Status(4, "GDBStandalone", 1, Messages.InternalError, e.getTargetException()));
        }
        catch (InterruptedException e) {
            status.merge((IStatus)new Status(4, "GDBStandalone", 1, Messages.InternalError, (Throwable)e));
        }
        ErrorDialog.openError(null, (String)Messages.ProblemsSavingWorkspace, null, (IStatus)status, (int)6);
        if (!status.isOK()) {
            ResourcesPlugin.getPlugin().getLog().log((IStatus)status);
        }
    }

    public class PostWindowCreateRunnable
    implements IRunnableWithProgress {
        /*
         * Loose catch block
         */
        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor.beginTask(Messages.InitializingDebugger, 10);
            boolean attachExecutable = false;
            String executable = null;
            String corefile = null;
            String buildLog = null;
            String arguments = null;
            String remoteAddress = null;
            String remotePort = null;
            String pid = null;
            String[] args = Platform.getCommandLineArgs();
            try {
                try {
                    String executablePath;
                    Status errorStatus;
                    Object info;
                    int i = 0;
                    while (i < args.length) {
                        if ("-application".equals(args[i])) {
                            ++i;
                        } else if ("-product".equals(args[i])) {
                            ++i;
                        } else if ("-b".equals(args[i])) {
                            if (++i < args.length) {
                                buildLog = args[i];
                            }
                        } else if ("-a".equals(args[i])) {
                            attachExecutable = true;
                            executable = null;
                            if (i + 1 < args.length && !args[i + 1].startsWith("-")) {
                                pid = args[++i];
                            }
                        } else if ("-c".equals(args[i])) {
                            corefile = "";
                            executable = "";
                            if (++i < args.length) {
                                corefile = args[i];
                            }
                        } else if ("-r".equals(args[i])) {
                            String[] params;
                            ++i;
                            remoteAddress = "";
                            if (!attachExecutable) {
                                executable = "";
                            }
                            if (i < args.length && (params = args[i].split(":")).length == 2) {
                                remoteAddress = params[0];
                                remotePort = params[1];
                            }
                        } else if ("-e".equals(args[i])) {
                            if (++i < args.length) {
                                executable = ApplicationWorkbenchWindowAdvisor.this.findExecutable(args[i]);
                            }
                            StringBuffer argBuffer = new StringBuffer();
                            if (++i < args.length) {
                                argBuffer.append(args[i++]);
                            }
                            while (i < args.length) {
                                argBuffer.append(" ");
                                argBuffer.append(args[i++]);
                            }
                            arguments = argBuffer.toString();
                        }
                        ++i;
                    }
                    if (corefile != null) {
                        File executableFile = null;
                        if (executable != null) {
                            executableFile = new File(executable);
                            executable = executableFile.getCanonicalPath();
                        }
                        File coreFile = new File(corefile);
                        corefile = coreFile.getCanonicalPath();
                        if (executableFile == null || !executableFile.exists() || !coreFile.exists()) {
                            info = new CoreFileInfo("", "", "");
                            errorStatus = new Status(4, "GDBStandalone", 0, Messages.GdbDebugNewExecutableCommand_Binary_file_does_not_exist, null);
                            executablePath = executable;
                            final String coreFilePath = corefile;
                            Display.getDefault().syncExec(new Runnable((CoreFileInfo)info, (IStatus)errorStatus){
                                private final /* synthetic */ CoreFileInfo val$info;
                                private final /* synthetic */ IStatus val$errorStatus;
                                {
                                    this.val$info = coreFileInfo;
                                    this.val$errorStatus = iStatus;
                                }

                                @Override
                                public void run() {
                                    CoreFileDialog dialog = new CoreFileDialog(ApplicationWorkbenchWindowAdvisor.this.getWindowConfigurer().getWindow().getShell(), 0, executablePath, coreFilePath);
                                    dialog.setBlockOnOpen(true);
                                    if (dialog.open() == 0) {
                                        CoreFileInfo info2 = dialog.getCoreFileInfo();
                                        this.val$info.setHostPath(info2.getHostPath());
                                        this.val$info.setCoreFilePath(info2.getCoreFilePath());
                                    } else {
                                        ErrorDialog.openError(null, (String)Messages.DebuggerInitializingProblem, null, (IStatus)this.val$errorStatus, (int)6);
                                    }
                                }
                            });
                            if (((CoreFileInfo)info).getHostPath().equals("")) {
                                monitor.done();
                                throw new StartupException(errorStatus.getMessage());
                            }
                            executable = ((CoreFileInfo)info).getHostPath();
                            corefile = ((CoreFileInfo)info).getCoreFilePath();
                        }
                    } else if (remoteAddress != null) {
                        File executableFile = null;
                        if (executable != null) {
                            executableFile = new File(executable);
                            executable = executableFile.getCanonicalPath();
                        }
                        Integer port = null;
                        try {
                            port = Integer.parseInt(remotePort);
                        }
                        catch (NumberFormatException e) {
                            port = null;
                        }
                        if (!attachExecutable && (executableFile == null || !executableFile.exists()) || remoteAddress.length() == 0 || port == null) {
                            info = new RemoteExecutableInfo[1];
                            errorStatus = new Status(4, "GDBStandalone", 0, Messages.GdbDebugNewExecutableCommand_Binary_file_does_not_exist, null);
                            executablePath = executable;
                            final String addressStr = remoteAddress;
                            final String portStr = remotePort;
                            final String buildLogPath = buildLog;
                            final boolean attach = attachExecutable;
                            Display.getDefault().syncExec(new Runnable((RemoteExecutableInfo[])info, (IStatus)errorStatus){
                                private final /* synthetic */ RemoteExecutableInfo[] val$info;
                                private final /* synthetic */ IStatus val$errorStatus;
                                {
                                    this.val$info = remoteExecutableInfoArray;
                                    this.val$errorStatus = iStatus;
                                }

                                @Override
                                public void run() {
                                    RemoteExecutableDialog dialog = new RemoteExecutableDialog(ApplicationWorkbenchWindowAdvisor.this.getWindowConfigurer().getWindow().getShell(), executablePath, buildLogPath, addressStr, portStr, attach);
                                    dialog.setBlockOnOpen(true);
                                    if (dialog.open() == 0) {
                                        this.val$info[0] = dialog.getExecutableInfo();
                                    } else {
                                        this.val$info[0] = null;
                                        ErrorDialog.openError(null, (String)Messages.DebuggerInitializingProblem, null, (IStatus)this.val$errorStatus, (int)6);
                                    }
                                }
                            });
                            if (info[0] == null) {
                                monitor.done();
                                throw new StartupException(errorStatus.getMessage());
                            }
                            executable = ((RemoteExecutableInfo)info[0]).getHostPath();
                            buildLog = ((RemoteExecutableInfo)info[0]).getBuildLog();
                            remoteAddress = ((RemoteExecutableInfo)info[0]).getAddress();
                            remotePort = ((RemoteExecutableInfo)info[0]).getPort();
                            attachExecutable = ((RemoteExecutableInfo)info[0]).isAttach();
                        }
                    } else if (executable != null) {
                        File executableFile = new File(executable);
                        executable = executableFile.getCanonicalPath();
                        File buildLogFile = null;
                        if (buildLog != null) {
                            buildLogFile = new File(buildLog);
                            buildLog = buildLogFile.getCanonicalPath();
                        }
                        if (!executableFile.exists() || buildLogFile != null && !buildLogFile.exists()) {
                            info = new NewExecutableInfo("", "", "", "");
                            errorStatus = new Status(4, "GDBStandalone", 0, Messages.GdbDebugNewExecutableCommand_Binary_file_does_not_exist, null);
                            executablePath = executable;
                            final String executableArgs = arguments;
                            final String buildLogPath = buildLog;
                            Display.getDefault().syncExec(new Runnable((NewExecutableInfo)info, (IStatus)errorStatus){
                                private final /* synthetic */ NewExecutableInfo val$info;
                                private final /* synthetic */ IStatus val$errorStatus;
                                {
                                    this.val$info = newExecutableInfo;
                                    this.val$errorStatus = iStatus;
                                }

                                @Override
                                public void run() {
                                    NewExecutableDialog dialog = new NewExecutableDialog(ApplicationWorkbenchWindowAdvisor.this.getWindowConfigurer().getWindow().getShell(), 0, executablePath, buildLogPath, executableArgs);
                                    dialog.setBlockOnOpen(true);
                                    if (dialog.open() == 0) {
                                        NewExecutableInfo info2 = dialog.getExecutableInfo();
                                        this.val$info.setHostPath(info2.getHostPath());
                                        this.val$info.setArguments(info2.getArguments());
                                    } else {
                                        ErrorDialog.openError(null, (String)Messages.DebuggerInitializingProblem, null, (IStatus)this.val$errorStatus, (int)6);
                                    }
                                }
                            });
                            if (((NewExecutableInfo)info).getHostPath().equals("")) {
                                monitor.done();
                                throw new StartupException(errorStatus.getMessage());
                            }
                            executable = ((NewExecutableInfo)info).getHostPath();
                            arguments = ((NewExecutableInfo)info).getArguments();
                        }
                    }
                    monitor.worked(1);
                    if (remoteAddress != null && remoteAddress.length() > 0 && remotePort != null && remotePort.length() > 0) {
                        ApplicationWorkbenchWindowAdvisor.this.config = DebugRemoteExecutable.createLaunchConfig(monitor, buildLog, executable, remoteAddress, remotePort, attachExecutable);
                    } else if (attachExecutable) {
                        ApplicationWorkbenchWindowAdvisor.this.config = DebugAttachedExecutable.createLaunchConfig(monitor, buildLog, pid);
                    } else if (corefile != null && corefile.length() > 0) {
                        ApplicationWorkbenchWindowAdvisor.this.config = DebugCoreFile.createLaunchConfig(monitor, buildLog, executable, corefile);
                    } else if (executable != null && executable.length() > 0) {
                        ApplicationWorkbenchWindowAdvisor.this.config = DebugExecutable.importAndCreateLaunchConfig(monitor, executable, buildLog, arguments, true);
                    } else {
                        monitor.subTask(Messages.RestorePreviousLaunch);
                        String memento = ResourcesPlugin.getWorkspace().getRoot().getPersistentProperty(new QualifiedName(ApplicationWorkbenchWindowAdvisor.STANDALONE_QUALIFIER, ApplicationWorkbenchWindowAdvisor.LAST_LAUNCH));
                        if (memento != null) {
                            ApplicationWorkbenchWindowAdvisor.this.config = DebugExecutable.getLaunchManager().getLaunchConfiguration(memento);
                        }
                        String oldExecutable = "";
                        String oldArguments = "";
                        String oldBuildLog = "";
                        if (ApplicationWorkbenchWindowAdvisor.this.config != null) {
                            oldExecutable = ApplicationWorkbenchWindowAdvisor.this.config.getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", "");
                            oldArguments = ApplicationWorkbenchWindowAdvisor.this.config.getAttribute("org.eclipse.cdt.launch.PROGRAM_ARGUMENTS", "");
                            oldBuildLog = ApplicationWorkbenchWindowAdvisor.this.config.getAttribute("org.eclipse.cdt.debug.application.launch.build.log", "");
                        }
                        final NewExecutableInfo info2 = new NewExecutableInfo("", "", "", "");
                        Status errorStatus2 = new Status(2, "GDBStandalone", 0, Messages.GdbDebugNewExecutableCommand_Binary_file_does_not_exist, null);
                        final String executablePath2 = oldExecutable;
                        final String executableArgs = oldArguments;
                        final String buildLogPath = oldBuildLog;
                        Display.getDefault().syncExec(new Runnable((IStatus)errorStatus2){
                            private final /* synthetic */ IStatus val$errorStatus;
                            {
                                this.val$errorStatus = iStatus;
                            }

                            @Override
                            public void run() {
                                NewExecutableDialog dialog = new NewExecutableDialog(ApplicationWorkbenchWindowAdvisor.this.getWindowConfigurer().getWindow().getShell(), 0, executablePath2, buildLogPath, executableArgs);
                                dialog.setBlockOnOpen(true);
                                if (dialog.open() == 0) {
                                    NewExecutableInfo info22 = dialog.getExecutableInfo();
                                    info2.setHostPath(info22.getHostPath());
                                    info2.setArguments(info22.getArguments());
                                    info2.setBuildLog(info22.getBuildLog());
                                } else {
                                    ErrorDialog.openError(null, (String)Messages.DebuggerInitializingProblem, null, (IStatus)this.val$errorStatus, (int)6);
                                }
                            }
                        });
                        if (info2.getHostPath().equals("")) {
                            monitor.done();
                            throw new StartupException(errorStatus2.getMessage());
                        }
                        executable = info2.getHostPath();
                        arguments = info2.getArguments();
                        buildLog = info2.getBuildLog();
                        if (ApplicationWorkbenchWindowAdvisor.this.config == null || !executable.equals(oldExecutable)) {
                            ApplicationWorkbenchWindowAdvisor.this.config = DebugExecutable.importAndCreateLaunchConfig(monitor, executable, buildLog, arguments, true);
                        }
                        ILaunchConfigurationWorkingCopy wc = ApplicationWorkbenchWindowAdvisor.this.config.getWorkingCopy();
                        wc.setAttribute("org.eclipse.cdt.debug.application.launch.build.log", buildLog);
                        if (arguments != null) {
                            wc.setAttribute("org.eclipse.cdt.launch.PROGRAM_ARGUMENTS", arguments);
                        }
                        ApplicationWorkbenchWindowAdvisor.this.config = wc.doSave();
                        monitor.worked(7);
                    }
                    if (ApplicationWorkbenchWindowAdvisor.this.config != null) {
                        final JobContainer LaunchJobs = new JobContainer();
                        Job.getJobManager().addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                            public void scheduled(IJobChangeEvent event) {
                                Job job = event.getJob();
                                if (job.getName().contains(ApplicationWorkbenchWindowAdvisor.this.config.getName())) {
                                    LaunchJobs.setLaunchJob(job);
                                }
                            }

                            public void done(IJobChangeEvent event) {
                            }
                        });
                        monitor.subTask(Messages.LaunchingConfig);
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                DebugUITools.launch((ILaunchConfiguration)ApplicationWorkbenchWindowAdvisor.this.config, (String)"debug");
                            }
                        });
                        if (LaunchJobs.getLaunchJob() != null) {
                            try {
                                LaunchJobs.getLaunchJob().join();
                            }
                            catch (InterruptedException e) {
                                Status status = new Status(4, "GDBStandalone", 0, Messages.LaunchInterruptedError, (Throwable)e);
                                ResourcesPlugin.getPlugin().getLog().log((IStatus)status);
                            }
                        }
                    }
                }
                catch (InterruptedException e) {
                    throw e;
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    monitor.done();
                }
                catch (StartupException e) {
                    monitor.done();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    monitor.done();
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    private class StartupException
    extends FileNotFoundException {
        private static final long serialVersionUID = 1L;

        public StartupException(String s) {
        }
    }
}

