/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.examples.dsf.filebrowser;

import java.io.File;
import java.util.LinkedList;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.ui.viewmodel.AbstractVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.AbstractVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.VMDelta;
import org.eclipse.cdt.examples.dsf.filebrowser.FileVMContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;

class FilesystemRootsVMNode
extends AbstractVMNode
implements IElementLabelProvider {
    public FilesystemRootsVMNode(AbstractVMProvider provider) {
        super((IVMProvider)provider);
    }

    public String toString() {
        return "FilesystemRootsVMNode";
    }

    public void update(final IChildrenUpdate[] updates) {
        new Job(""){
            {
                super($anonymous0);
                this.setSystem(true);
                this.setPriority(10);
            }

            protected IStatus run(IProgressMonitor monitor) {
                File[] files = File.listRoots();
                IChildrenUpdate[] iChildrenUpdateArray = updates;
                int n = updates.length;
                int n2 = 0;
                while (n2 < n) {
                    IChildrenUpdate update = iChildrenUpdateArray[n2];
                    int offset = update.getOffset() != -1 ? update.getOffset() : 0;
                    int length = update.getLength() != -1 ? update.getLength() : files.length;
                    int i = offset;
                    while (i < files.length && i < offset + length) {
                        update.setChild((Object)new FileVMContext((IVMNode)FilesystemRootsVMNode.this, files[i]), i);
                        ++i;
                    }
                    update.done();
                    ++n2;
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public void update(IHasChildrenUpdate[] updates) {
        IHasChildrenUpdate[] iHasChildrenUpdateArray = updates;
        int n = updates.length;
        int n2 = 0;
        while (n2 < n) {
            IHasChildrenUpdate update = iHasChildrenUpdateArray[n2];
            update.setHasChilren(true);
            update.done();
            ++n2;
        }
    }

    public void update(final IChildrenCountUpdate[] updates) {
        new Job(""){
            {
                super($anonymous0);
                this.setSystem(true);
                this.setPriority(10);
            }

            protected IStatus run(IProgressMonitor monitor) {
                IChildrenCountUpdate[] iChildrenCountUpdateArray = updates;
                int n = updates.length;
                int n2 = 0;
                while (n2 < n) {
                    IChildrenCountUpdate update = iChildrenCountUpdateArray[n2];
                    if (FilesystemRootsVMNode.this.checkUpdate((IViewerUpdate)update)) {
                        update.setChildCount(File.listRoots().length);
                        update.done();
                    }
                    ++n2;
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public void update(final ILabelUpdate[] updates) {
        new Job(""){
            {
                super($anonymous0);
                this.setSystem(true);
                this.setPriority(10);
            }

            protected IStatus run(IProgressMonitor monitor) {
                ILabelUpdate[] iLabelUpdateArray = updates;
                int n = updates.length;
                int n2 = 0;
                while (n2 < n) {
                    ILabelUpdate update = iLabelUpdateArray[n2];
                    update.setLabel(FilesystemRootsVMNode.this.getLabel((FileVMContext)((Object)update.getElement())), 0);
                    update.done();
                    ++n2;
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private String getLabel(FileVMContext vmc) {
        return vmc.getFile().getAbsolutePath();
    }

    public int getDeltaFlags(Object e) {
        int retVal = 0;
        if (e instanceof String) {
            retVal |= 0x300000;
        }
        return retVal;
    }

    public void buildDelta(final Object event, final VMDelta parentDelta, int nodeOffset, final RequestMonitor requestMonitor) {
        if (event instanceof String) {
            new Job(""){
                {
                    super($anonymous0);
                    this.setSystem(true);
                    this.setPriority(10);
                }

                protected IStatus run(IProgressMonitor monitor) {
                    File eventFile = new File((String)event);
                    if (eventFile.exists()) {
                        LinkedList<File> filePath = new LinkedList<File>();
                        File file = eventFile;
                        while (file != null) {
                            filePath.add(0, file);
                            file = file.getParentFile();
                        }
                        File eventRoot = (File)filePath.get(0);
                        File[] roots = File.listRoots();
                        int index = 0;
                        while (index < roots.length) {
                            if (eventRoot.equals(roots[index])) break;
                            ++index;
                        }
                        if (index < roots.length) {
                            VMDelta delta = parentDelta.addNode((Object)new FileVMContext((IVMNode)FilesystemRootsVMNode.this, eventRoot), index, 0);
                            if (eventFile.equals(eventRoot)) {
                                delta.setFlags(delta.getFlags() | 0x200000 | 0x100000);
                            }
                        }
                    }
                    requestMonitor.done();
                    return Status.OK_STATUS;
                }
            }.schedule();
        } else {
            requestMonitor.done();
        }
    }
}

