/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.examples.dsf.timers;

import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.Immutable;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.AbstractDMContext;
import org.eclipse.cdt.dsf.datamodel.AbstractDMEvent;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.service.AbstractDsfService;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.examples.dsf.DsfExamplesPlugin;
import org.eclipse.cdt.examples.dsf.timers.TimerService;
import org.osgi.framework.BundleContext;

public class AlarmService
extends AbstractDsfService {
    private int fTriggerNumberCounter = 1;
    private Map<TriggerDMContext, Integer> fTriggers = new LinkedHashMap<TriggerDMContext, Integer>();

    AlarmService(DsfSession session) {
        super(session);
    }

    protected BundleContext getBundleContext() {
        return DsfExamplesPlugin.getDefault().getBundle().getBundleContext();
    }

    public void initialize(final RequestMonitor requestMonitor) {
        super.initialize(new RequestMonitor((Executor)this.getExecutor(), requestMonitor){

            protected void handleSuccess() {
                AlarmService.this.doInitialize(requestMonitor);
            }
        });
    }

    private void doInitialize(RequestMonitor requestMonitor) {
        this.getSession().addServiceEventListener((Object)this, null);
        this.register(new String[]{AlarmService.class.getName()}, new Hashtable());
        requestMonitor.done();
    }

    public void shutdown(RequestMonitor requestMonitor) {
        this.getSession().removeServiceEventListener((Object)this);
        this.unregister();
        super.shutdown(requestMonitor);
    }

    public boolean isValid() {
        return true;
    }

    @DsfServiceEventHandler
    public void eventDispatched(TimerService.TimerTickDMEvent event) {
        TimerService.TimerDMContext timerContext = (TimerService.TimerDMContext)event.getDMContext();
        int timerValue = ((TimerService)((Object)this.getServicesTracker().getService(TimerService.class))).getTimerValue((TimerService.TimerDMContext)event.getDMContext());
        this.checkAlarmsForTimer(timerContext, timerValue);
    }

    private void checkAlarmsForTimer(TimerService.TimerDMContext timerContext, int timerValue) {
        for (Map.Entry<TriggerDMContext, Integer> entry : this.fTriggers.entrySet()) {
            if (timerValue != entry.getValue()) continue;
            AlarmDMContext alarmCtx = new AlarmDMContext(this.getSession().getId(), timerContext, entry.getKey());
            this.getSession().dispatchEvent((Object)new AlarmTriggeredDMEvent(alarmCtx), this.getProperties());
        }
    }

    public TriggerDMContext[] getTriggers() {
        return this.fTriggers.keySet().toArray(new TriggerDMContext[this.fTriggers.size()]);
    }

    public int getTriggerValue(TriggerDMContext alarmCtx) {
        Integer value = this.fTriggers.get((Object)alarmCtx);
        if (value != null) {
            return value;
        }
        return -1;
    }

    public AlarmDMContext getAlarm(TriggerDMContext alarmCtx, TimerService.TimerDMContext timerCtx) {
        return new AlarmDMContext(this.getSession().getId(), timerCtx, alarmCtx);
    }

    public boolean isAlarmTriggered(AlarmDMContext alarmCtx) {
        TimerService.TimerDMContext timerCtx = (TimerService.TimerDMContext)DMContexts.getAncestorOfType((IDMContext)alarmCtx, TimerService.TimerDMContext.class);
        TriggerDMContext triggerCtx = (TriggerDMContext)DMContexts.getAncestorOfType((IDMContext)alarmCtx, TriggerDMContext.class);
        assert (triggerCtx != null && timerCtx != null);
        if (this.fTriggers.containsKey((Object)triggerCtx)) {
            int timerValue = ((TimerService)((Object)this.getServicesTracker().getService(TimerService.class))).getTimerValue(timerCtx);
            return timerValue >= this.fTriggers.get((Object)triggerCtx);
        }
        return false;
    }

    public TriggerDMContext createTrigger(int value) {
        TriggerDMContext triggerCtx = new TriggerDMContext(this.getSession().getId(), this.fTriggerNumberCounter++);
        this.fTriggers.put(triggerCtx, value);
        this.getSession().dispatchEvent((Object)new TriggersChangedEvent(), this.getProperties());
        return triggerCtx;
    }

    public void deleteTrigger(TriggerDMContext alarmCtx) {
        this.fTriggers.remove((Object)alarmCtx);
        this.getSession().dispatchEvent((Object)new TriggersChangedEvent(), this.getProperties());
    }

    public void setTriggerValue(TriggerDMContext ctx, int newValue) {
        if (this.fTriggers.containsKey((Object)ctx)) {
            this.fTriggers.put(ctx, newValue);
        }
        this.getSession().dispatchEvent((Object)new TriggersChangedEvent(), this.getProperties());
    }

    @Immutable
    public static class AlarmDMContext
    extends AbstractDMContext {
        private AlarmDMContext(String sessionId, TimerService.TimerDMContext timerCtx, TriggerDMContext alarmCtx) {
            super(sessionId, new IDMContext[]{timerCtx, alarmCtx});
        }

        public boolean equals(Object other) {
            return this.baseEquals(other);
        }

        public int hashCode() {
            return this.baseHashCode();
        }

        public String toString() {
            return String.valueOf(this.baseToString()) + ":alarm";
        }
    }

    public class AlarmTriggeredDMEvent
    extends AbstractDMEvent<AlarmDMContext> {
        public AlarmTriggeredDMEvent(AlarmDMContext context) {
            super((IDMContext)context);
        }
    }

    @Immutable
    public static class TriggerDMContext
    extends AbstractDMContext {
        final int fNumber;

        private TriggerDMContext(String sessionId, int number) {
            super(sessionId, new IDMContext[0]);
            this.fNumber = number;
        }

        public boolean equals(Object other) {
            return this.baseEquals(other) && ((TriggerDMContext)((Object)other)).fNumber == this.fNumber;
        }

        public int getTriggerNumber() {
            return this.fNumber;
        }

        public int hashCode() {
            return this.baseHashCode() + this.fNumber;
        }

        public String toString() {
            return String.valueOf(this.baseToString()) + ".trigger[" + this.fNumber + "]";
        }
    }

    @Immutable
    public static class TriggersChangedEvent {
    }
}

